/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ha.javax.sip;

import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.ConfirmedNoAppDataReplicationSipDialog;
import gov.nist.javax.sip.stack.ConfirmedReplicationSipDialog;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import org.mobicents.ha.javax.sip.HASipDialog;
import org.mobicents.ha.javax.sip.ReplicationStrategy;

public class HASipDialogFactory {
    public static HASipDialog createHASipDialog(ReplicationStrategy replicationStrategy, SIPTransaction transaction) {
        switch (replicationStrategy) {
            case ConfirmedDialog: {
                return new ConfirmedReplicationSipDialog(transaction);
            }
            case ConfirmedDialogNoApplicationData: {
                return new ConfirmedNoAppDataReplicationSipDialog(transaction);
            }
            case EarlyDialog: {
                return new ConfirmedReplicationSipDialog(transaction);
            }
        }
        throw new IllegalArgumentException("Replication Strategy " + (Object)((Object)replicationStrategy) + " is not supported");
    }

    public static HASipDialog createHASipDialog(ReplicationStrategy replicationStrategy, SIPClientTransaction transaction, SIPResponse sipResponse) {
        switch (replicationStrategy) {
            case ConfirmedDialog: {
                return new ConfirmedReplicationSipDialog(transaction, sipResponse);
            }
            case ConfirmedDialogNoApplicationData: {
                return new ConfirmedNoAppDataReplicationSipDialog(transaction, sipResponse);
            }
            case EarlyDialog: {
                return new ConfirmedReplicationSipDialog(transaction, sipResponse);
            }
        }
        throw new IllegalArgumentException("Replication Strategy " + (Object)((Object)replicationStrategy) + " is not supported");
    }

    public static HASipDialog createHASipDialog(ReplicationStrategy replicationStrategy, SipProviderImpl sipProvider, SIPResponse sipResponse) {
        switch (replicationStrategy) {
            case ConfirmedDialog: {
                return new ConfirmedReplicationSipDialog(sipProvider, sipResponse);
            }
            case ConfirmedDialogNoApplicationData: {
                return new ConfirmedNoAppDataReplicationSipDialog(sipProvider, sipResponse);
            }
            case EarlyDialog: {
                return new ConfirmedReplicationSipDialog(sipProvider, sipResponse);
            }
        }
        throw new IllegalArgumentException("Replication Strategy " + (Object)((Object)replicationStrategy) + " is not supported");
    }
}

