/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ha.javax.sip;

import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MobicentsHASIPClientTransaction;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sip.DialogState;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.PeerUnavailableException;
import javax.sip.ProviderDoesNotExistException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import org.mobicents.ext.javax.sip.SipStackImpl;
import org.mobicents.ha.javax.sip.ClusteredSipStack;
import org.mobicents.ha.javax.sip.HASipDialog;
import org.mobicents.ha.javax.sip.HASipDialogFactory;
import org.mobicents.ha.javax.sip.LoadBalancerElector;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingService;
import org.mobicents.ha.javax.sip.MobicentsHATransactionFactory;
import org.mobicents.ha.javax.sip.ReplicationStrategy;
import org.mobicents.ha.javax.sip.cache.SipCache;
import org.mobicents.ha.javax.sip.cache.SipCacheException;
import org.mobicents.ha.javax.sip.cache.SipCacheFactory;

public abstract class ClusteredSipStackImpl
extends SipStackImpl
implements ClusteredSipStack {
    protected SipCache sipCache = null;
    protected LoadBalancerHeartBeatingService loadBalancerHeartBeatingService = null;
    protected ReplicationStrategy replicationStrategy = ReplicationStrategy.ConfirmedDialog;
    protected LoadBalancerElector loadBalancerElector = null;
    private boolean replicateApplicationData = false;

    public ClusteredSipStackImpl(Properties configurationProperties) throws PeerUnavailableException {
        super(configurationProperties);
        String replicateApplicationDataProperty;
        String replicationStrategyProperty;
        String lbHbServiceClassName = configurationProperties.getProperty("org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingServiceClassName");
        if (lbHbServiceClassName != null) {
            try {
                this.loadBalancerHeartBeatingService = (LoadBalancerHeartBeatingService)Class.forName(lbHbServiceClassName).newInstance();
            }
            catch (Exception e) {
                String errmsg = "The loadBalancerHeartBeatingService class name: " + lbHbServiceClassName + " could not be instantiated. Ensure the " + "org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingServiceClassName" + " property has been set correctly and that the class is on the classpath.";
                throw new PeerUnavailableException(errmsg, (Throwable)e);
            }
            String lbElectorClassName = configurationProperties.getProperty(LoadBalancerElector.IMPLEMENTATION_CLASS_NAME_PROPERTY);
            if (lbElectorClassName != null) {
                try {
                    this.loadBalancerElector = (LoadBalancerElector)Class.forName(lbElectorClassName).newInstance();
                }
                catch (Exception e) {
                    String errmsg = "The loadBalancerElector class name: " + lbElectorClassName + " could not be instantiated. Ensure the " + LoadBalancerElector.IMPLEMENTATION_CLASS_NAME_PROPERTY + " property has been set correctly and that the class is on the classpath.";
                    throw new PeerUnavailableException(errmsg, (Throwable)e);
                }
                this.loadBalancerElector.setAddressFactory(SipFactory.getInstance().createAddressFactory());
                this.loadBalancerElector.setStackLogger(this.getStackLogger());
                this.loadBalancerElector.setService(this.loadBalancerHeartBeatingService);
            }
        }
        if ((replicationStrategyProperty = configurationProperties.getProperty("org.mobicents.ha.javax.sip.REPLICATION_STRATEGY")) != null) {
            this.replicationStrategy = ReplicationStrategy.valueOf(replicationStrategyProperty);
            if (this.replicationStrategy == ReplicationStrategy.EarlyDialog && this.transactionFactory == null) {
                this.transactionFactory = new MobicentsHATransactionFactory();
                this.transactionFactory.setSipStack((SipStack)this);
            }
        }
        this.sipCache = SipCacheFactory.createSipCache(this, configurationProperties);
        try {
            this.sipCache.init();
        }
        catch (Exception e) {
            throw new PeerUnavailableException("Unable to initialize the SipCache", (Throwable)e);
        }
        if (this.loadBalancerHeartBeatingService != null) {
            this.loadBalancerHeartBeatingService.init(this, configurationProperties);
        }
        if ((replicateApplicationDataProperty = configurationProperties.getProperty("org.mobicents.ha.javax.sip.REPLICATE_APPLICATION_DATA")) != null) {
            this.replicateApplicationData = Boolean.valueOf(replicateApplicationDataProperty);
        }
        if (replicateApplicationDataProperty == null && this.replicationStrategy == ReplicationStrategy.ConfirmedDialog) {
            this.replicateApplicationData = true;
        }
        if (this.getStackLogger().isLoggingEnabled(16)) {
            this.getStackLogger().logInfo("Replication Strategy is " + (Object)((Object)this.replicationStrategy) + " replicating application data " + this.replicateApplicationData);
        }
    }

    public void start() throws ProviderDoesNotExistException, SipException {
        try {
            this.sipCache.start();
        }
        catch (Exception e) {
            throw new SipException("Unable to start the SipCache", (Throwable)e);
        }
        if (this.loadBalancerHeartBeatingService != null) {
            this.loadBalancerHeartBeatingService.start();
        }
        super.start();
    }

    public void closeAllTcpSockets() {
        this.ioHandler.closeAll();
    }

    public void stop() {
        super.stop();
        try {
            this.sipCache.stop();
        }
        catch (Exception e) {
            this.getStackLogger().logError("Unable to stop the SipCache", e);
        }
        if (this.loadBalancerHeartBeatingService != null) {
            this.loadBalancerHeartBeatingService.stop();
        }
    }

    public SIPDialog createDialog(SIPTransaction transaction) {
        if (this.sipCache.inLocalMode()) {
            return super.createDialog(transaction);
        }
        SIPDialog retval = null;
        if (transaction instanceof SIPClientTransaction) {
            String dialogId = ((SIPRequest)transaction.getRequest()).getDialogId(false);
            retval = (SIPDialog)this.earlyDialogTable.get(dialogId);
            if (retval == null || retval.getState() != null && retval.getState() != DialogState.EARLY) {
                retval = (SIPDialog)HASipDialogFactory.createHASipDialog(this.replicationStrategy, transaction);
                this.earlyDialogTable.put(dialogId, retval);
            }
        } else {
            retval = (SIPDialog)HASipDialogFactory.createHASipDialog(this.replicationStrategy, transaction);
        }
        return retval;
    }

    public SIPDialog createDialog(SIPClientTransaction transaction, SIPResponse sipResponse) {
        if (this.sipCache.inLocalMode()) {
            return super.createDialog(transaction, sipResponse);
        }
        String dialogId = ((SIPRequest)transaction.getRequest()).getDialogId(false);
        SIPDialog retval = (SIPDialog)this.earlyDialogTable.get(dialogId);
        if (retval != null && sipResponse.isFinalResponse()) {
            this.earlyDialogTable.remove(dialogId);
        } else {
            retval = (SIPDialog)HASipDialogFactory.createHASipDialog(this.replicationStrategy, transaction, sipResponse);
        }
        return retval;
    }

    public SIPDialog createDialog(SipProviderImpl sipProvider, SIPResponse sipResponse) {
        if (this.sipCache.inLocalMode()) {
            return super.createDialog(sipProvider, sipResponse);
        }
        return (SIPDialog)HASipDialogFactory.createHASipDialog(this.replicationStrategy, sipProvider, sipResponse);
    }

    public SIPDialog getDialog(String dialogId) {
        if (this.sipCache.inLocalMode()) {
            return super.getDialog(dialogId);
        }
        if (this.getStackLogger().isLoggingEnabled(32)) {
            this.getStackLogger().logDebug("checking if the dialog " + dialogId + " is present in the local cache");
        }
        SIPDialog sipDialog = super.getDialog(dialogId);
        int nbToken = new StringTokenizer(dialogId, ":").countTokens();
        if (nbToken >= 3) {
            if (sipDialog == null) {
                if (this.getStackLogger().isLoggingEnabled(32)) {
                    this.getStackLogger().logDebug("local dialog " + dialogId + " is null, checking in the distributed cache");
                }
                if ((sipDialog = this.getDialogFromDistributedCache(dialogId)) != null) {
                    SIPDialog existingDialog;
                    if (this.getStackLogger().isLoggingEnabled(32)) {
                        this.getStackLogger().logDebug("dialog " + dialogId + " found in the distributed cache, storing it locally");
                    }
                    if ((existingDialog = super.putDialog(sipDialog)) != null) {
                        sipDialog = existingDialog;
                    }
                } else if (this.getStackLogger().isLoggingEnabled(32)) {
                    this.getStackLogger().logDebug("dialog " + dialogId + " not found in the distributed cache");
                }
            } else if (sipDialog.getState() == DialogState.CONFIRMED) {
                if (this.getStackLogger().isLoggingEnabled(32)) {
                    this.getStackLogger().logDebug("local dialog " + dialogId + " is present locally " + sipDialog + " checking if it needs to be updated from the cache");
                }
                try {
                    this.sipCache.updateDialog(sipDialog);
                }
                catch (SipCacheException e) {
                    this.getStackLogger().logError("sipStack " + this + " problem updating dialog " + dialogId + " from the distributed cache", (Exception)e);
                }
            }
        }
        return sipDialog;
    }

    public SIPDialog putDialog(SIPDialog dialog) {
        return super.putDialog(dialog);
    }

    public void removeDialog(SIPDialog dialog) {
        if (!this.sipCache.inLocalMode()) {
            this.removeDialogFromDistributedCache(dialog.getDialogId());
        }
        super.removeDialog(dialog);
    }

    public void remoteDialogRemoval(String dialogId) {
        String mergeId;
        SIPDialog sipDialog;
        if (this.getStackLogger().isLoggingEnabled(32)) {
            this.getStackLogger().logDebug("sipStack " + this + " remote Dialog Removal of dialogId : " + dialogId);
        }
        if ((sipDialog = (SIPDialog)this.dialogTable.remove(dialogId)) != null && (mergeId = sipDialog.getMergeId()) != null) {
            this.serverDialogMergeTestTable.remove(mergeId);
        }
    }

    protected SIPDialog getDialogFromDistributedCache(String dialogId) {
        if (this.getStackLogger().isLoggingEnabled(32)) {
            this.getStackLogger().logDebug("sipStack " + this + " checking if the dialog " + dialogId + " is present in the distributed cache");
        }
        SIPDialog sipDialog = null;
        try {
            sipDialog = this.sipCache.getDialog(dialogId);
        }
        catch (SipCacheException e) {
            this.getStackLogger().logError("sipStack " + this + " problem getting dialog " + dialogId + " from the distributed cache", (Exception)e);
        }
        if (sipDialog != null) {
            if (this.getStackLogger().isLoggingEnabled(32)) {
                this.getStackLogger().logDebug("sipStack " + this + " dialog " + dialogId + " was present in the distributed cache, initializing it after the load");
            }
            ((HASipDialog)sipDialog).initAfterLoad(this);
        }
        return sipDialog;
    }

    protected void putDialogIntoDistributedCache(SIPDialog dialog) {
        String dialogId = dialog.getDialogId();
        if (this.getStackLogger().isLoggingEnabled(32)) {
            this.getStackLogger().logDebug("sipStack " + this + " storing the dialog " + dialogId + " in the distributed cache");
        }
        try {
            this.sipCache.putDialog(dialog);
        }
        catch (SipCacheException e) {
            this.getStackLogger().logError("sipStack " + this + " problem storing the dialog " + dialogId + " into the distributed cache", (Exception)e);
        }
    }

    protected void removeDialogFromDistributedCache(String dialogId) {
        if (this.getStackLogger().isLoggingEnabled(32)) {
            this.getStackLogger().logDebug("sipStack " + this + " removing the dialog " + dialogId + " from the distributed cache");
        }
        try {
            this.sipCache.removeDialog(dialogId);
        }
        catch (SipCacheException e) {
            this.getStackLogger().logError("sipStack " + this + " problem removing dialog " + dialogId + " from the distributed cache", (Exception)e);
        }
    }

    public SIPTransaction findTransaction(String transactionId, boolean isServer) {
        if (this.sipCache.inLocalMode() || this.replicationStrategy != ReplicationStrategy.EarlyDialog) {
            return super.findTransaction(transactionId, isServer);
        }
        String txId = transactionId.toLowerCase();
        SIPTransaction sipTransaction = super.findTransaction(txId, isServer);
        if (sipTransaction == null && this.transactionFactory != null) {
            if (this.getStackLogger().isLoggingEnabled(32)) {
                this.getStackLogger().logDebug("local transaction " + txId + " server = " + isServer + " is null, checking in the distributed cache");
            }
            if (this.getStackLogger().isLoggingEnabled(32)) {
                this.getStackLogger().logDebug("sipStack " + this + " checking if the transaction " + txId + " server = " + isServer + " is present in the distributed cache");
            }
            if (isServer) {
                try {
                    sipTransaction = this.sipCache.getServerTransaction(txId);
                    if (sipTransaction != null) {
                        SIPServerTransaction retval;
                        if (this.getStackLogger().isLoggingEnabled(32)) {
                            this.getStackLogger().logDebug("sipStack " + this + " transaction " + txId + " server = " + isServer + " is present in the distributed cache");
                        }
                        if ((retval = this.serverTransactionTable.putIfAbsent(txId, (SIPServerTransaction)sipTransaction)) != null) {
                            sipTransaction = retval;
                        }
                    } else if (this.getStackLogger().isLoggingEnabled(32)) {
                        this.getStackLogger().logDebug("sipStack " + this + " transaction " + txId + " server = " + isServer + " is not present in the distributed cache");
                    }
                }
                catch (SipCacheException e) {
                    this.getStackLogger().logError("sipStack " + this + " problem getting transaction " + txId + " server = " + isServer + " from the distributed cache", (Exception)e);
                }
            } else {
                try {
                    sipTransaction = this.sipCache.getClientTransaction(txId);
                    if (sipTransaction != null) {
                        SIPClientTransaction retval;
                        if (this.getStackLogger().isLoggingEnabled(32)) {
                            this.getStackLogger().logDebug("sipStack " + this + " transaction " + txId + " server = " + isServer + " is present in the distributed cache");
                        }
                        if ((retval = this.clientTransactionTable.putIfAbsent(txId, (SIPClientTransaction)sipTransaction)) != null) {
                            sipTransaction = retval;
                        } else {
                            ((MobicentsHASIPClientTransaction)sipTransaction).startTransactionTimerOnFailover();
                        }
                    } else if (this.getStackLogger().isLoggingEnabled(32)) {
                        this.getStackLogger().logDebug("sipStack " + this + " transaction " + txId + " server = " + isServer + " is not present in the distributed cache");
                    }
                }
                catch (SipCacheException e) {
                    this.getStackLogger().logError("sipStack " + this + " problem getting transaction " + txId + " server = " + isServer + " from the distributed cache", (Exception)e);
                }
            }
        }
        return sipTransaction;
    }

    public void removeTransaction(SIPTransaction sipTransaction) {
        super.removeTransaction(sipTransaction);
        if (this.sipCache.inLocalMode()) {
            return;
        }
        if (this.transactionFactory != null && sipTransaction != null && this.replicationStrategy == ReplicationStrategy.EarlyDialog && sipTransaction.getMethod().equalsIgnoreCase("INVITE")) {
            if (sipTransaction instanceof ServerTransaction) {
                try {
                    this.sipCache.removeServerTransaction(sipTransaction.getTransactionId());
                }
                catch (SipCacheException e) {
                    this.getStackLogger().logError("sipStack " + this + " problem getting transaction " + sipTransaction.getTransactionId() + " from the distributed cache", (Exception)e);
                }
            } else {
                try {
                    this.sipCache.removeClientTransaction(sipTransaction.getTransactionId());
                }
                catch (SipCacheException e) {
                    this.getStackLogger().logError("sipStack " + this + " problem getting transaction " + sipTransaction.getTransactionId() + " from the distributed cache", (Exception)e);
                }
            }
        }
    }

    protected void removeTransactionHash(SIPTransaction sipTransaction) {
        super.removeTransactionHash(sipTransaction);
        if (this.sipCache.inLocalMode()) {
            return;
        }
        if (this.transactionFactory != null && sipTransaction != null && this.replicationStrategy == ReplicationStrategy.EarlyDialog && sipTransaction.getMethod().equalsIgnoreCase("INVITE")) {
            if (sipTransaction instanceof ServerTransaction) {
                try {
                    this.sipCache.removeServerTransaction(sipTransaction.getTransactionId());
                }
                catch (SipCacheException e) {
                    this.getStackLogger().logError("sipStack " + this + " problem getting transaction " + sipTransaction.getTransactionId() + " from the distributed cache", (Exception)e);
                }
            } else {
                try {
                    this.sipCache.removeClientTransaction(sipTransaction.getTransactionId());
                }
                catch (SipCacheException e) {
                    this.getStackLogger().logError("sipStack " + this + " problem getting transaction " + sipTransaction.getTransactionId() + " from the distributed cache", (Exception)e);
                }
            }
        }
    }

    public void setSipCache(SipCache sipCache) {
        this.sipCache = sipCache;
    }

    public SipCache getSipCache() {
        return this.sipCache;
    }

    public LoadBalancerHeartBeatingService getLoadBalancerHeartBeatingService() {
        return this.loadBalancerHeartBeatingService;
    }

    public ReplicationStrategy getReplicationStrategy() {
        return this.replicationStrategy;
    }

    public LoadBalancerElector getLoadBalancerElector() {
        return this.loadBalancerElector;
    }

    public SIPClientTransaction createClientTransaction(SIPRequest sipRequest, MessageChannel encapsulatedMessageChannel) {
        if (this.sipCache.inLocalMode() || this.transactionFactory == null) {
            return super.createClientTransaction(sipRequest, encapsulatedMessageChannel);
        }
        return this.transactionFactory.createClientTransaction(sipRequest, encapsulatedMessageChannel);
    }

    public SIPServerTransaction createServerTransaction(MessageChannel encapsulatedMessageChannel) {
        if (this.sipCache.inLocalMode() || this.transactionFactory == null) {
            return super.createServerTransaction(encapsulatedMessageChannel);
        }
        return this.transactionFactory.createServerTransaction(encapsulatedMessageChannel);
    }

    public boolean isReplicateApplicationData() {
        return this.replicateApplicationData;
    }

    public void remoteServerTransactionRemoval(String transactionId) {
        SIPServerTransaction sipServerTransaction;
        String txId = transactionId.toLowerCase();
        if (this.getStackLogger().isLoggingEnabled(32)) {
            this.getStackLogger().logDebug("sipStack " + this + " remote Server Transaction Removal of transaction Id : " + txId);
        }
        if ((sipServerTransaction = (SIPServerTransaction)this.serverTransactionTable.remove(txId)) != null) {
            super.removeFromMergeTable(sipServerTransaction);
            super.removePendingTransaction(sipServerTransaction);
            super.removeTransactionPendingAck(sipServerTransaction);
        }
    }

    public void remoteClientTransactionRemoval(String transactionId) {
        String txId = transactionId.toLowerCase();
        if (this.getStackLogger().isLoggingEnabled(32)) {
            this.getStackLogger().logDebug("sipStack " + this + " remote Client Transaction Removal of transaction Id : " + txId);
        }
        SIPClientTransaction sipClientTransaction = (SIPClientTransaction)this.clientTransactionTable.remove(txId);
    }

    public SipProvider createSipProvider(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (this.sipProviderFactory != null) {
            return this.sipProviderFactory.createSipProvider(listeningPoint);
        }
        return super.createSipProvider(listeningPoint);
    }
}

