/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ha.javax.sip;

import gov.nist.core.StackLogger;
import gov.nist.javax.sip.address.SipUri;
import java.text.ParseException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.URI;
import org.mobicents.ha.javax.sip.LoadBalancerElector;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingListener;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingService;
import org.mobicents.ha.javax.sip.SipLoadBalancer;

public abstract class AbstractLoadBalancerElector
implements LoadBalancerElector,
LoadBalancerHeartBeatingListener {
    protected LoadBalancerHeartBeatingService service;
    protected AddressFactory addressFactory;
    protected StackLogger logger;

    abstract void addLoadBalancer(SipLoadBalancer var1);

    private Address createAddress(String balancerDescription) {
        String host = balancerDescription;
        int sipPort = 5065;
        if (balancerDescription.indexOf(":") != -1) {
            String[] balancerDescriptionSplitted = balancerDescription.split(":");
            host = balancerDescriptionSplitted[0];
            try {
                sipPort = Integer.parseInt(balancerDescriptionSplitted[1]);
            }
            catch (NumberFormatException e) {
                this.logger.logError("Impossible to parse the following sip balancer port " + balancerDescriptionSplitted[1], (Exception)e);
                return null;
            }
        }
        return this.createAddress(host, sipPort);
    }

    private Address createAddress(String host, int port) {
        SipUri sipUri = new SipUri();
        try {
            sipUri.setHost(host);
        }
        catch (ParseException e) {
            this.logger.logError("Bad load balancer host " + host, (Exception)e);
            return null;
        }
        sipUri.setPort(port);
        return this.addressFactory.createAddress((URI)sipUri);
    }

    public abstract Address getLoadBalancer();

    public void loadBalancerAdded(SipLoadBalancer balancerDescription) {
        this.addLoadBalancer(balancerDescription);
    }

    public void loadBalancerRemoved(SipLoadBalancer balancerDescription) {
        Address address = this.createAddress(balancerDescription.getAddress().getHostName(), balancerDescription.getSipPort());
        if (address != null) {
            this.removeLoadBalancer(address);
        }
    }

    public void setAddressFactory(AddressFactory addressFactory) throws NullPointerException {
        if (addressFactory == null) {
            throw new NullPointerException("null addressFactory");
        }
        this.addressFactory = addressFactory;
    }

    public void setService(LoadBalancerHeartBeatingService service) throws IllegalStateException, NullPointerException {
        if (service == null) {
            throw new NullPointerException("null service");
        }
        if (this.addressFactory == null || this.logger == null) {
            throw new IllegalStateException();
        }
        this.service = service;
        service.addLoadBalancerHeartBeatingListener(this);
        for (SipLoadBalancer balancer : service.getLoadBalancers()) {
            this.addLoadBalancer(balancer);
        }
    }

    public void setStackLogger(StackLogger logger) throws NullPointerException {
        if (logger == null) {
            throw new NullPointerException("null logger");
        }
        this.logger = logger;
    }

    abstract void removeLoadBalancer(Address var1);
}

