/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ha.balancing.only.javax.sip;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.stack.MessageProcessor;
import java.util.Properties;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.sip.PeerUnavailableException;
import javax.sip.ProviderDoesNotExistException;
import javax.sip.SipException;
import org.mobicents.ha.balancing.only.javax.sip.SipStackImplMBean;
import org.mobicents.ha.javax.sip.ClusteredSipStackImpl;
import org.mobicents.ha.javax.sip.HASipDialog;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingServiceImpl;
import org.mobicents.ha.javax.sip.cache.NoCache;

public class SipStackImpl
extends ClusteredSipStackImpl
implements SipStackImplMBean,
NotificationListener {
    private static StackLogger logger = CommonLogger.getLogger(SipStackImpl.class);
    public static String LOG4J_SERVICE_MBEAN_NAME = "jboss.system:service=Logging,type=Log4jService";

    public SipStackImpl(Properties configurationProperties) throws PeerUnavailableException {
        super(SipStackImpl.updateConfigProperties(configurationProperties));
    }

    public void start() throws ProviderDoesNotExistException, SipException {
        super.start();
        try {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Adding notification listener for logging mbean \"" + LOG4J_SERVICE_MBEAN_NAME + "\" to server " + this.getMBeanServer());
            }
            this.getMBeanServer().addNotificationListener(new ObjectName(LOG4J_SERVICE_MBEAN_NAME), this, null, null);
        }
        catch (Exception e) {
            logger.logWarning("Could not register the stack as a Notification Listener of " + LOG4J_SERVICE_MBEAN_NAME + " runtime changes to log4j.xml won't affect SIP Stack Logging");
        }
    }

    public void stop() {
        try {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Removing notification listener for logging mbean \"" + LOG4J_SERVICE_MBEAN_NAME + "\" to server " + this.getMBeanServer());
            }
            this.getMBeanServer().removeNotificationListener(new ObjectName(LOG4J_SERVICE_MBEAN_NAME), this, null, null);
        }
        catch (Exception e) {
            logger.logWarning("Could not deregister the stack as a Notification Listener of " + LOG4J_SERVICE_MBEAN_NAME + " runtime changes to log4j.xml won't affect SIP Stack Logging");
        }
        super.stop();
    }

    private static final Properties updateConfigProperties(Properties configurationProperties) {
        if (configurationProperties.getProperty("org.mobicents.ha.javax.sip.CACHE_CLASS_NAME") == null) {
            configurationProperties.setProperty("org.mobicents.ha.javax.sip.CACHE_CLASS_NAME", NoCache.class.getName());
        }
        if (configurationProperties.getProperty("org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingServiceClassName") == null) {
            configurationProperties.setProperty("org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingServiceClassName", LoadBalancerHeartBeatingServiceImpl.class.getName());
        }
        return configurationProperties;
    }

    public int getNumberOfClientTransactions() {
        return this.getClientTransactionTableSize();
    }

    public int getNumberOfDialogs() {
        return this.dialogTable.size();
    }

    public int getNumberOfEarlyDialogs() {
        return this.earlyDialogTable.size();
    }

    public int getNumberOfServerTransactions() {
        return this.getServerTransactionTableSize();
    }

    public boolean isLocalMode() {
        return this.getSipCache().inLocalMode();
    }

    public void passivateDialog(HASipDialog dialog) {
    }

    public MessageProcessor[] getStackMessageProcessors() {
        return this.getMessageProcessors();
    }
}

