/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MobicentsSIPServerTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.sip.PeerUnavailableException;
import javax.sip.SipFactory;
import org.mobicents.ha.javax.sip.ClusteredSipStack;
import org.mobicents.ha.javax.sip.cache.SipCacheException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobicentsHASIPServerTransaction
extends MobicentsSIPServerTransaction {
    private static StackLogger logger = CommonLogger.getLogger(MobicentsHASIPServerTransaction.class);
    public static final String MY_PORT = "mp";
    public static final String PEER_PORT = "cp";
    public static final String PEER_IP = "cip";
    public static final String TRANSPORT = "ct";
    public static final String CURRENT_STATE = "cs";
    public static final String DIALOG_ID = "did";
    public static final String ORIGINAL_REQUEST = "req";
    String localDialogId;
    int peerReliablePort = -1;

    public MobicentsHASIPServerTransaction(SIPTransactionStack sipStack, MessageChannel newChannelToUse) {
        super(sipStack, newChannelToUse);
    }

    public Map<String, Object> getMetaDataToReplicate() {
        HashMap<String, Object> transactionMetaData = new HashMap<String, Object>();
        transactionMetaData.put(ORIGINAL_REQUEST, this.getOriginalRequest().toString());
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.transactionId + " : original request " + this.getOriginalRequest());
        }
        if (this.dialogId != null) {
            transactionMetaData.put(DIALOG_ID, this.dialogId);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.transactionId + " : dialog Id " + this.dialogId);
            }
        } else if (this.localDialogId != null) {
            transactionMetaData.put(DIALOG_ID, this.localDialogId);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.transactionId + " : dialog Id " + this.localDialogId);
            }
        }
        if (this.getState() != null) {
            transactionMetaData.put(CURRENT_STATE, this.getState().getValue());
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.transactionId + " : current state " + this.getState());
            }
        }
        transactionMetaData.put(TRANSPORT, this.getMessageChannel().getTransport());
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.transactionId + " : message channel transport " + this.getTransport());
        }
        transactionMetaData.put(PEER_IP, this.getMessageChannel().getPeerInetAddress());
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.transactionId + " : message channel ip " + this.getMessageChannel().getPeerInetAddress());
        }
        int peerPort = this.getMessageChannel().getPeerPort();
        if (this.isReliable()) {
            peerPort = this.peerReliablePort;
        }
        transactionMetaData.put(PEER_PORT, peerPort);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.transactionId + " : message channel peer port " + peerPort);
        }
        transactionMetaData.put(MY_PORT, this.getMessageChannel().getPort());
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.transactionId + " : message channel my port " + this.getMessageChannel().getPort());
        }
        return transactionMetaData;
    }

    public void sendMessage(SIPMessage message) throws IOException {
        SIPResponse response = (SIPResponse)message;
        if (response != null && "INVITE".equals(this.getMethod()) && response.getStatusCode() > 100 && response.getStatusCode() < 200) {
            this.localDialogId = response.getDialogId(true);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.transactionId + " : local dialog Id " + this.localDialogId);
            }
            if (this.isReliable()) {
                this.peerReliablePort = response.getTopmostViaHeader().getPort();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug(this.transactionId + " : peer Reliable Port " + this.peerReliablePort);
                }
            }
            try {
                ((ClusteredSipStack)this.sipStack).getSipCache().putServerTransaction((SIPServerTransaction)this);
            }
            catch (SipCacheException e) {
                logger.logError("problem storing server transaction " + this.transactionId + " into the distributed cache", (Exception)e);
            }
        }
        super.sendMessage(message);
    }

    public void setMetaDataToReplicate(Map<String, Object> transactionMetaData, boolean recreation) throws PeerUnavailableException, ParseException {
        Integer state;
        String dialogId;
        String originalRequestString = (String)transactionMetaData.get(ORIGINAL_REQUEST);
        if (originalRequestString != null) {
            SIPRequest origRequest = (SIPRequest)SipFactory.getInstance().createMessageFactory().createRequest(originalRequestString);
            this.setOriginalRequest(origRequest);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.transactionId + " : original Request " + this.originalRequest);
            }
        }
        if ((dialogId = (String)transactionMetaData.get(DIALOG_ID)) != null) {
            SIPDialog sipDialog = this.sipStack.getDialog(dialogId);
            if (sipDialog != null) {
                this.setDialog(sipDialog, dialogId);
                sipDialog.addTransaction((SIPTransaction)this);
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.transactionId + " : dialog Id " + dialogId + " dialog " + sipDialog);
            }
        }
        if ((state = (Integer)transactionMetaData.get(CURRENT_STATE)) != null && super.getState() == null) {
            this.setState(state);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.transactionId + " : state " + this.getState());
            }
        }
    }

    public void setApplicationData(Object applicationData) {
        super.setApplicationData(applicationData);
    }

    public Object getApplicationDataToReplicate() {
        if (((ClusteredSipStack)this.getSIPStack()).isReplicateApplicationData()) {
            return this.getApplicationData();
        }
        return null;
    }

    public void setApplicationDataToReplicate(Object appData) {
        super.setApplicationData(appData);
    }
}

