/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MobicentsSIPClientTransaction;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.sip.PeerUnavailableException;
import javax.sip.SipFactory;
import org.mobicents.ha.javax.sip.ClusteredSipStack;
import org.mobicents.ha.javax.sip.cache.SipCacheException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobicentsHASIPClientTransaction
extends MobicentsSIPClientTransaction {
    private static StackLogger logger = CommonLogger.getLogger(MobicentsHASIPClientTransaction.class);
    public static final String MY_PORT = "mp";
    public static final String PEER_PORT = "cp";
    public static final String PEER_IP = "cip";
    public static final String TRANSPORT = "ct";
    public static final String CURRENT_STATE = "cs";
    public static final String DIALOG_ID = "did";
    public static final String ORIGINAL_REQUEST = "req";
    String localDialogId;
    int peerReliablePort = -1;
    int lastResponseStatusCode = -1;

    public MobicentsHASIPClientTransaction(SIPTransactionStack newSIPStack, MessageChannel newChannelToUse) {
        super(newSIPStack, newChannelToUse);
    }

    public Map<String, Object> getMetaDataToReplicate() {
        SIPDialog dialog;
        HashMap<String, Object> transactionMetaData = new HashMap<String, Object>();
        transactionMetaData.put(ORIGINAL_REQUEST, this.getOriginalRequest().toString());
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.transactionId + " : original request " + this.getOriginalRequest());
        }
        if ((dialog = this.getDefaultDialog()) != null) {
            transactionMetaData.put(DIALOG_ID, dialog.getDialogId());
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.transactionId + " : dialog Id " + dialog.getDialogId());
            }
        } else if (this.localDialogId != null) {
            transactionMetaData.put(DIALOG_ID, this.localDialogId);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.transactionId + " : dialog Id " + this.localDialogId);
            }
        }
        if (this.getState() != null) {
            transactionMetaData.put(CURRENT_STATE, this.getState().getValue());
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.transactionId + " : current state " + this.getState());
            }
        }
        transactionMetaData.put(TRANSPORT, this.getMessageChannel().getTransport());
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.transactionId + " : message channel transport " + this.getTransport());
        }
        transactionMetaData.put(PEER_IP, this.getMessageChannel().getPeerInetAddress());
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.transactionId + " : message channel ip " + this.getMessageChannel().getPeerInetAddress());
        }
        int peerPort = this.getMessageChannel().getPeerPort();
        if (this.isReliable()) {
            peerPort = this.peerReliablePort;
        }
        transactionMetaData.put(PEER_PORT, peerPort);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.transactionId + " : message channel peer port " + peerPort);
        }
        transactionMetaData.put(MY_PORT, this.getMessageChannel().getPort());
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.transactionId + " : message channel my port " + this.getMessageChannel().getPort());
        }
        return transactionMetaData;
    }

    public void setState(int newState) {
        super.setState(newState);
        if ("INVITE".equalsIgnoreCase(this.getMethod()) && (newState == 1 || newState == 2) && (this.lastResponse == null || this.lastResponse != null && this.lastResponseStatusCode < this.lastResponse.getStatusCode())) {
            if (this.lastResponse != null) {
                this.localDialogId = this.lastResponse.getDialogId(false);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug(this.transactionId + " : local dialog Id " + this.localDialogId);
                }
            }
            try {
                ((ClusteredSipStack)this.sipStack).getSipCache().putClientTransaction((SIPClientTransaction)this);
            }
            catch (SipCacheException e) {
                logger.logError("problem storing server transaction " + this.transactionId + " into the distributed cache", (Exception)e);
            }
        }
    }

    public void setMetaDataToReplicate(Map<String, Object> transactionMetaData, boolean recreation) throws PeerUnavailableException, ParseException {
        String dialogId;
        Integer state;
        String originalRequestString = (String)transactionMetaData.get(ORIGINAL_REQUEST);
        if (originalRequestString != null) {
            SIPRequest origRequest = (SIPRequest)SipFactory.getInstance().createMessageFactory().createRequest(originalRequestString);
            super.setOriginalRequest(origRequest);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.transactionId + " : original Request " + this.originalRequest);
            }
        }
        if ((state = (Integer)transactionMetaData.get(CURRENT_STATE)) != null && super.getState() == null) {
            super.setState(state.intValue());
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.transactionId + " : state " + this.getState());
            }
        }
        if ((dialogId = (String)transactionMetaData.get(DIALOG_ID)) != null) {
            SIPDialog sipDialog = this.sipStack.getDialog(dialogId);
            if (sipDialog != null) {
                this.setDialog(sipDialog, dialogId);
                sipDialog.addTransaction((SIPTransaction)this);
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.transactionId + " : dialog Id " + dialogId + " dialog " + sipDialog);
            }
        }
    }

    public void setApplicationData(Object applicationData) {
        super.setApplicationData(applicationData);
    }

    public Object getApplicationDataToReplicate() {
        if (((ClusteredSipStack)this.getSIPStack()).isReplicateApplicationData()) {
            return this.getApplicationData();
        }
        return null;
    }

    public void setApplicationDataToReplicate(Object appData) {
        super.setApplicationData(appData);
    }

    public void startTransactionTimerOnFailover() {
        super.startTransactionTimer();
    }
}

