/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.EventParser;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.sip.DialogState;
import javax.sip.PeerUnavailableException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.header.ContactHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.HeaderFactory;
import org.mobicents.ha.javax.sip.ClusteredSipStack;
import org.mobicents.ha.javax.sip.HASipDialog;
import org.mobicents.ha.javax.sip.ReplicationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHASipDialog
extends SIPDialog
implements HASipDialog {
    private static StackLogger logger = CommonLogger.getLogger(AbstractHASipDialog.class);
    private static final long serialVersionUID = 1L;
    public static final String B2BUA = "b2b";
    public static final String EVENT_HEADER = "eh";
    public static final String REMOTE_TARGET = "rt";
    public static final String TERMINATE_ON_BYE = "tob";
    public static final String ROUTE_LIST = "rl";
    public static final String IS_REINVITE = "ir";
    public static final String LAST_RESPONSE = "lr";
    public static final String IS_SERVER = "is";
    public static final String IS_LATEST_TX_SERVER = "ilts";
    public static final String FIRST_TX_METHOD = "ftm";
    public static final String FIRST_TX_ID = "ftid";
    public static final String FIRST_TX_PORT = "ftp";
    public static final String FIRST_TX_SECURE = "fts";
    public static final String CONTACT_HEADER = "ch";
    public static final String LOCAL_TAG = "ltag";
    public static final String REMOTE_TAG = "rtag";
    public static final String VERSION = "v";
    public static final String REMOTE_CSEQ = "rc";
    public static final String LOCAL_CSEQ = "lc";
    public static final String DIALOG_METHOD = "dm";
    public static final String ENABLE_CSEQ_VALIDATION = "dc";
    public static final String DIALOG_STATE = "ds";
    public boolean b2buaChanged;
    public boolean eventChanged;
    public boolean remoteTargetChanged;
    public boolean terminateOnByeChanged;
    public boolean isReinviteChanged;
    public boolean storeFirstTxChanged;
    public boolean dialogStateChanged;
    public boolean isLatestTxServer;
    static AddressFactory addressFactory = null;
    static HeaderFactory headerFactory = null;
    boolean isCreated = true;
    private AtomicLong version = new AtomicLong(0L);
    private String lastResponseStringified = null;

    public AbstractHASipDialog(SIPTransaction transaction) {
        super(transaction);
    }

    public AbstractHASipDialog(SIPClientTransaction transaction, SIPResponse sipResponse) {
        super(transaction, sipResponse);
    }

    public AbstractHASipDialog(SipProviderImpl sipProvider, SIPResponse sipResponse) {
        super(sipProvider, sipResponse);
    }

    @Override
    public void initAfterLoad(ClusteredSipStack sipStackImpl) {
        String transport = this.getLastResponseTopMostVia().getTransport();
        Iterator providers = sipStackImpl.getSipProviders();
        boolean providerNotFound = true;
        while (providers.hasNext()) {
            SipProviderImpl providerImpl = (SipProviderImpl)providers.next();
            if (providerImpl.getListeningPoint(transport) == null) continue;
            this.setSipProvider(providerImpl);
            providerNotFound = false;
        }
        if (providerNotFound) {
            throw new RuntimeException("No providers found for transport=" + transport + " on this node. Make sure connectors are configured for this transport");
        }
        this.setStack((SIPTransactionStack)sipStackImpl);
        this.setAssigned();
        this.firstTransactionPort = this.getSipProvider().getListeningPoint(this.getLastResponseTopMostVia().getTransport()).getPort();
        this.ackProcessed = true;
    }

    @Override
    public Map<String, Object> getMetaDataToReplicate() {
        boolean firstTimeReplication;
        HashMap<String, Object> dialogMetaData = new HashMap<String, Object>();
        dialogMetaData.put(VERSION, this.version.incrementAndGet());
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.getDialogIdToReplicate() + " : version " + this.version);
        }
        if (this.dialogStateChanged) {
            dialogMetaData.put(DIALOG_STATE, this.getState().getValue());
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : dialogState " + this.getState());
            }
            this.dialogStateChanged = false;
        }
        boolean bl = firstTimeReplication = this.version.get() == 1L;
        if (firstTimeReplication) {
            dialogMetaData.put(DIALOG_METHOD, this.getMethod());
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : dialog method " + this.getMethod());
            }
        }
        dialogMetaData.put(LAST_RESPONSE, this.getLastResponseStringified());
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.getDialogIdToReplicate() + " : lastResponse " + this.getLastResponseStringified());
        }
        if (this.isReinviteChanged) {
            dialogMetaData.put(IS_REINVITE, this.isReInvite());
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : isReInvite " + this.isReInvite());
            }
            this.isReinviteChanged = false;
        }
        ArrayList<SIPHeader> routeList = new ArrayList<SIPHeader>();
        Iterator it = this.getRouteSet();
        while (it.hasNext()) {
            SIPHeader sipHeader = (SIPHeader)it.next();
            routeList.add(sipHeader);
        }
        String[] routes = new String[routeList.size()];
        int i = 0;
        for (SIPHeader sipHeader : routeList) {
            routes[i++] = sipHeader.getHeaderValue().toString();
        }
        dialogMetaData.put(ROUTE_LIST, routes);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.getDialogIdToReplicate() + " : routes " + routes);
        }
        if (this.terminateOnByeChanged) {
            dialogMetaData.put(TERMINATE_ON_BYE, this.isTerminatedOnBye());
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : terminateOnBye " + this.isTerminatedOnBye());
            }
            this.terminateOnByeChanged = false;
        }
        if (this.remoteTargetChanged) {
            if (this.getRemoteTarget() != null) {
                dialogMetaData.put(REMOTE_TARGET, this.getRemoteTarget().toString());
            } else {
                dialogMetaData.put(REMOTE_TARGET, null);
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : remoteTarget " + this.getRemoteTarget());
            }
            this.remoteTargetChanged = false;
        }
        if (this.eventChanged) {
            if (this.getEventHeader() != null) {
                dialogMetaData.put(EVENT_HEADER, this.getEventHeader().toString());
            } else {
                dialogMetaData.put(EVENT_HEADER, null);
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : evenHeader " + this.getEventHeader());
            }
            this.eventChanged = false;
        }
        if (this.b2buaChanged) {
            dialogMetaData.put(B2BUA, this.isBackToBackUserAgent());
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : isB2BUA " + this.isBackToBackUserAgent());
            }
            this.b2buaChanged = false;
        }
        if (this.storeFirstTxChanged) {
            dialogMetaData.put(IS_SERVER, this.isServer());
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : isServer " + this.isServer());
            }
            dialogMetaData.put(FIRST_TX_SECURE, this.firstTransactionSecure);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : firstTxSecure " + this.firstTransactionSecure);
            }
            dialogMetaData.put(FIRST_TX_ID, this.firstTransactionId);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : firstTransactionId " + this.firstTransactionId);
            }
            dialogMetaData.put(ENABLE_CSEQ_VALIDATION, this.isSequenceNumberValidation());
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : CSeq validation is " + this.isSequenceNumberValidation());
            }
            dialogMetaData.put(FIRST_TX_METHOD, this.firstTransactionMethod);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : firstTransactionMethod " + this.firstTransactionMethod);
            }
            if (this.contactHeader != null) {
                dialogMetaData.put(CONTACT_HEADER, this.contactHeader.getHeaderValue());
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : contactHeader " + this.contactHeader);
            }
            this.storeFirstTxChanged = false;
        }
        dialogMetaData.put(IS_LATEST_TX_SERVER, this.isLatestTxServer);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.getDialogIdToReplicate() + " : isLatestTxServer " + this.isLatestTxServer);
        }
        dialogMetaData.put(REMOTE_TAG, this.getRemoteTag());
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.getDialogIdToReplicate() + " : remoteTag " + this.getRemoteTag());
        }
        dialogMetaData.put(LOCAL_TAG, this.getLocalTag());
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.getDialogIdToReplicate() + " : localTag " + this.getLocalTag());
        }
        dialogMetaData.put(REMOTE_CSEQ, this.getRemoteSeqNumber());
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.getDialogIdToReplicate() + " : remoteCSeq " + this.getRemoteSeqNumber());
        }
        dialogMetaData.put(LOCAL_CSEQ, this.getLocalSeqNumber());
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.getDialogIdToReplicate() + " : localCSeq " + this.getLocalSeqNumber());
        }
        return dialogMetaData;
    }

    @Override
    public Object getApplicationDataToReplicate() {
        return this.getApplicationData();
    }

    @Override
    public void setMetaDataToReplicate(Map<String, Object> metaData, boolean recreation) {
        Boolean enableCSeqValidation;
        Long localCSeq;
        Long remoteCSeq;
        String firstTxMethod;
        String firstTxId;
        Boolean firstTxSecure;
        Boolean isServer;
        String[] routes;
        Boolean terminateOnBye;
        String remoteTargetCache;
        String eventHeaderStringified;
        Boolean isReinvite;
        Boolean isB2BUA;
        String dialogMethod;
        ReplicationStrategy replicationStrategy = ((ClusteredSipStack)this.getStack()).getReplicationStrategy();
        if (replicationStrategy == ReplicationStrategy.EarlyDialog) {
            Integer dialogState = (Integer)metaData.get(DIALOG_STATE);
            if (dialogState != null) {
                super.setState(dialogState.intValue());
            }
        } else {
            super.setState(1);
        }
        this.lastResponseStringified = (String)metaData.get(LAST_RESPONSE);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.getDialogIdToReplicate() + " : lastResponse " + this.lastResponseStringified);
        }
        if ((dialogMethod = (String)metaData.get(DIALOG_METHOD)) != null) {
            this.method = dialogMethod;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : dialog method " + this.method);
            }
        }
        this.version = new AtomicLong((Long)metaData.get(VERSION));
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.getDialogIdToReplicate() + " : version " + this.version);
        }
        if ((isB2BUA = (Boolean)metaData.get(B2BUA)) != null && isB2BUA == Boolean.TRUE) {
            this.setBackToBackUserAgent();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : isB2BUA " + isB2BUA);
            }
        }
        if ((isReinvite = (Boolean)metaData.get(IS_REINVITE)) != null) {
            super.setReInviteFlag(isReinvite.booleanValue());
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : isReInvite " + isReinvite);
            }
        }
        if ((eventHeaderStringified = (String)metaData.get(EVENT_HEADER)) != null) {
            try {
                super.setEventHeader((EventHeader)new EventParser(eventHeaderStringified).parse());
            }
            catch (ParseException e) {
                logger.logError("Unexpected exception while parsing a deserialized eventHeader", (Exception)e);
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : evenHeader " + eventHeaderStringified);
            }
        }
        if ((remoteTargetCache = (String)metaData.get(REMOTE_TARGET)) != null) {
            Contact contact = new Contact();
            try {
                this.remotePartyStringified = remoteTargetCache;
                contact.setAddress(addressFactory.createAddress(remoteTargetCache));
                super.setRemoteTarget((ContactHeader)contact);
            }
            catch (ParseException e) {
                logger.logError("Unexpected exception while parsing a deserialized remoteTarget address", (Exception)e);
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : remoteTarget " + this.remoteTargetStringified);
            }
        }
        if ((terminateOnBye = (Boolean)metaData.get(TERMINATE_ON_BYE)) != null) {
            try {
                this.terminateOnBye(terminateOnBye);
            }
            catch (SipException e) {
                // empty catch block
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : terminateOnBye " + terminateOnBye);
            }
        }
        if ((routes = (String[])metaData.get(ROUTE_LIST)) != null) {
            RouteList routeList = new RouteList();
            for (String route : routes) {
                try {
                    routeList.add((SIPHeader)((Route)headerFactory.createRouteHeader(addressFactory.createAddress(route))));
                }
                catch (ParseException e) {
                    logger.logError("Unexpected exception while parsing a deserialized route address", (Exception)e);
                }
            }
            this.setRouteList(routeList);
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.getDialogIdToReplicate() + " : routes " + routes);
        }
        if ((isServer = (Boolean)metaData.get(IS_SERVER)) != null) {
            this.firstTransactionSeen = true;
            this.firstTransactionIsServerTransaction = isServer;
            super.setServerTransactionFlag(isServer.booleanValue());
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : isServer " + isServer);
            }
        }
        if ((firstTxSecure = (Boolean)metaData.get(FIRST_TX_SECURE)) != null) {
            this.firstTransactionSecure = firstTxSecure;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : firstTxSecure " + firstTxSecure);
            }
        }
        if ((firstTxId = (String)metaData.get(FIRST_TX_ID)) != null) {
            this.firstTransactionId = firstTxId;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : firstTransactionId " + this.firstTransactionId);
            }
        }
        if ((firstTxMethod = (String)metaData.get(FIRST_TX_METHOD)) != null) {
            this.firstTransactionMethod = firstTxMethod;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : firstTransactionMethod " + this.firstTransactionMethod);
            }
        }
        if (recreation) {
            this.isLatestTxServer = (Boolean)metaData.get(IS_LATEST_TX_SERVER);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("HA SIP Dialog is Server ? " + this.isServer() + ", isLatestTxServer ? " + this.isLatestTxServer);
            }
            if (this.isLatestTxServer) {
                long localCSeq2;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("dialog : switching parties on recreation " + this.getDialogIdToReplicate() + " localParty = " + this.getLocalParty());
                }
                Address remoteParty = this.getLocalParty();
                Address localParty = this.getRemoteParty();
                this.setLocalPartyInternal(localParty);
                this.setRemotePartyInternal(remoteParty);
                long remoteCSeq2 = this.getLocalSeqNumber();
                this.localSequenceNumber = localCSeq2 = this.getRemoteSeqNumber();
                this.remoteSequenceNumber = remoteCSeq2;
            }
        }
        String remoteTag = (String)metaData.get(REMOTE_TAG);
        this.setRemoteTagInternal(remoteTag);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.getDialogIdToReplicate() + " : remoteTag " + this.getRemoteTag());
        }
        String localTag = (String)metaData.get(LOCAL_TAG);
        this.setLocalTagInternal(localTag);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(this.getDialogIdToReplicate() + " : localTag " + this.getLocalTag());
        }
        if ((remoteCSeq = (Long)metaData.get(REMOTE_CSEQ)) != null) {
            long cseq = remoteCSeq;
            if (this.getRemoteSeqNumber() > cseq) {
                if (logger.isLoggingEnabled(16)) {
                    logger.logInfo("Concurrency problem. Nodes are out of sync. We will assume the local CSeq is the valid one. Enable request affinity to avoid this problem, remoteSequenceNumber=" + this.getRemoteSeqNumber() + " while other node's remote CSeq" + " number=" + cseq);
                }
            } else {
                this.setRemoteSequenceNumber(cseq);
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : remoteCSeq " + this.getRemoteSeqNumber());
            }
        }
        if ((localCSeq = (Long)metaData.get(LOCAL_CSEQ)) != null) {
            long cseq = localCSeq;
            if (this.localSequenceNumber > cseq) {
                if (logger.isLoggingEnabled(16)) {
                    logger.logInfo("Concurrency problem. Nodes are out of sync. We will assume the local CSeq is the valid one. Enable request affinity to avoid this problem, localSequenceNumber=" + this.localSequenceNumber + " while other node's local CSeq" + " number=" + cseq);
                }
            } else {
                this.localSequenceNumber = cseq;
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : localCSeq " + this.getLocalSeqNumber());
            }
        }
        if ((enableCSeqValidation = (Boolean)metaData.get(ENABLE_CSEQ_VALIDATION)) != null) {
            if (!enableCSeqValidation.booleanValue()) {
                this.disableSequenceNumberValidation();
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getDialogIdToReplicate() + " : CSeq validation is " + enableCSeqValidation);
            }
        }
    }

    @Override
    public void setApplicationDataToReplicate(Object appData) {
        super.setApplicationData(appData);
    }

    protected abstract void replicateState();

    @Override
    public void setLocalTagInternal(String localTag) {
        this.myTag = localTag;
    }

    @Override
    public void setRemoteTagInternal(String remoteTag) {
        this.hisTag = remoteTag;
    }

    @Override
    public void setLocalPartyInternal(Address localParty) {
        this.localParty = localParty;
    }

    @Override
    public void setRemotePartyInternal(Address remoteParty) {
        this.remoteParty = remoteParty;
    }

    @Override
    public void setContactHeader(ContactHeader contactHeader) {
        this.contactHeader = (Contact)contactHeader;
    }

    public void setLastResponse(SIPTransaction transaction, SIPResponse sipResponse) {
        if (this.version != null) {
            boolean lastResponseChanged = false;
            long previousVersion = this.version.get();
            ReplicationStrategy replicationStrategy = ((ClusteredSipStack)this.getStack()).getReplicationStrategy();
            int lowerStatusCodeToReplicateOn = 200;
            if (replicationStrategy == ReplicationStrategy.EarlyDialog) {
                lowerStatusCodeToReplicateOn = 101;
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.dialogId + " lowerStatusCodeToReplicateOn = " + lowerStatusCodeToReplicateOn);
                logger.logDebug(this.dialogId + " lastResponseStr = " + this.lastResponseStringified);
                logger.logDebug(this.dialogId + " sipResponse = " + sipResponse);
            }
            if (sipResponse != null && this.getLastResponseStringified() == null && sipResponse.getStatusCode() >= lowerStatusCodeToReplicateOn) {
                lastResponseChanged = true;
            }
            String responseStringified = sipResponse.toString();
            if (sipResponse != null && this.getLastResponseStringified() != null && sipResponse.getStatusCode() >= lowerStatusCodeToReplicateOn && !responseStringified.equals(this.getLastResponseStringified())) {
                lastResponseChanged = true;
            }
            super.setLastResponse(transaction, sipResponse);
            this.lastResponseStringified = responseStringified;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.dialogId + " lastResponseChanged = " + lastResponseChanged);
                logger.logDebug(this.dialogId + " previousVersion = " + previousVersion);
                logger.logDebug(this.dialogId + " currentVersion = " + this.version.get());
            }
            if (lastResponseChanged && previousVersion == this.version.get()) {
                if (replicationStrategy == ReplicationStrategy.EarlyDialog) {
                    sipResponse.setRetransmission(false);
                }
                this.replicateState();
            }
        }
    }

    @Override
    public void setLastResponse(SIPResponse lastResponse) {
        super.setLastResponse(null, lastResponse);
    }

    public boolean isRemoteTagSet() {
        return this.hisTag != null && this.hisTag.trim().length() > 0;
    }

    public boolean isLocalTagSet() {
        return this.myTag != null && this.myTag.trim().length() > 0;
    }

    @Override
    public long getVersion() {
        return this.version.get();
    }

    @Override
    public String getDialogIdToReplicate() {
        return this.getDialogId();
    }

    public String getLastResponseStringified() {
        return this.lastResponseStringified;
    }

    public void setReInviteFlag(boolean reInviteFlag) {
        boolean oldReinvite = this.isReInvite();
        super.setReInviteFlag(reInviteFlag);
        if (reInviteFlag != oldReinvite) {
            this.isReinviteChanged = true;
        }
    }

    protected void storeFirstTransactionInfo(SIPDialog dialog, SIPTransaction transaction) {
        super.storeFirstTransactionInfo(dialog, transaction);
        this.storeFirstTxChanged = true;
    }

    public boolean addTransaction(SIPTransaction transaction) {
        this.isLatestTxServer = transaction instanceof ServerTransaction;
        return super.addTransaction(transaction);
    }

    public void setRemoteTarget(ContactHeader contact) {
        super.setRemoteTarget(contact);
        this.remoteTargetChanged = true;
    }

    public void setState(int state) {
        DialogState oldState = this.getState();
        super.setState(state);
        ReplicationStrategy replicationStrategy = ((ClusteredSipStack)this.getStack()).getReplicationStrategy();
        if (replicationStrategy == ReplicationStrategy.EarlyDialog && (oldState == null || oldState.getValue() != state && state != DialogState.TERMINATED.getValue())) {
            this.dialogStateChanged = true;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("dialogStateChanged");
            }
        }
    }

    static {
        try {
            headerFactory = SipFactory.getInstance().createHeaderFactory();
            addressFactory = SipFactory.getInstance().createAddressFactory();
        }
        catch (PeerUnavailableException peerUnavailableException) {
            // empty catch block
        }
    }
}

