/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.stack.ByteBufferFactory;
import gov.nist.javax.sip.stack.ClientAuthType;
import gov.nist.javax.sip.stack.NioTlsChannelInterface;
import gov.nist.javax.sip.stack.NioTlsMessageChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLPeerUnverifiedException;

public class SSLStateMachine {
    private static StackLogger logger = CommonLogger.getLogger(SSLStateMachine.class);
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
    protected SSLEngine sslEngine;
    protected Queue<MessageSendItem> pendingOutboundBuffers = new LinkedList<MessageSendItem>();
    protected NioTlsChannelInterface channel;
    protected ByteBuffer tlsRecordBuffer;
    private Object unwrapLock = new Object();
    private Object wrapLock = new Object();

    public SSLStateMachine(SSLEngine sslEngine, NioTlsChannelInterface channel) {
        this.sslEngine = sslEngine;
        this.channel = channel;
    }

    public void wrapRemaining() throws IOException {
        this.wrap(null, this.channel.prepareEncryptedDataBuffer(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void wrap(ByteBuffer src, ByteBuffer dst, MessageSendCallback callback) throws IOException {
        var4_4 = this.wrapLock;
        synchronized (var4_4) {
            if (SSLStateMachine.logger.isLoggingEnabled(32)) {
                SSLStateMachine.logger.logDebug("Wrapping " + src + ", buffers size " + this.pendingOutboundBuffers.size());
            }
            if (src != null) {
                this.pendingOutboundBuffers.offer(new MessageSendItem(src, callback));
            }
            iter = 0;
            block15: while (true) {
                ++iter;
                currentBuffer = this.pendingOutboundBuffers.peek();
                if (currentBuffer == null) break;
                try {
                    result = this.sslEngine.wrap(MessageSendItem.access$000(currentBuffer), dst);
                    if (SSLStateMachine.logger.isLoggingEnabled(32)) {
                        SSLStateMachine.logger.logDebug("Wrap result " + result + " buffers size " + this.pendingOutboundBuffers.size());
                    }
                }
                finally {
                    if (!MessageSendItem.access$000(currentBuffer).hasRemaining()) {
                        this.pendingOutboundBuffers.remove();
                        if (SSLStateMachine.logger.isLoggingEnabled(32)) {
                            SSLStateMachine.logger.logDebug("REMOVED item from encryption queue because it has no more data, all is done, buffers size now is " + this.pendingOutboundBuffers.size() + " current buffer is " + currentBuffer);
                        }
                    }
                }
                remaining = MessageSendItem.access$000(currentBuffer).remaining();
                if (SSLStateMachine.logger.isLoggingEnabled(32)) {
                    SSLStateMachine.logger.logDebug("Remaining " + remaining + " queue size is " + this.pendingOutboundBuffers.size());
                }
                if (result.bytesProduced() > 0) {
                    dst.flip();
                    bytes = new byte[dst.remaining()];
                    dst.get(bytes);
                    if (currentBuffer.getCallBack() != null) {
                        currentBuffer.getCallBack().doSend(bytes);
                    } else {
                        this.sendSSLMetadata(bytes);
                    }
                    dst.clear();
                    continue;
                }
                switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[result.getHandshakeStatus().ordinal()]) {
                    case 1: {
                        if (!MessageSendItem.access$000(currentBuffer).hasRemaining()) break block15;
                        ** GOTO lbl68
                    }
                    case 2: {
                        break block15;
                    }
                    case 3: {
                        this.runDelegatedTasks(result);
                        ** GOTO lbl68
                    }
                    case 4: {
                        if (!(this.channel instanceof NioTlsMessageChannel)) ** GOTO lbl68
                        ((NioTlsMessageChannel)this.channel).setHandshakeCompleted(true);
                        if (this.sslEngine.getSession() == null) ** GOTO lbl68
                        if (ClientAuthType.Disabled.equals((Object)this.channel.getSIPStack().getClientAuth()) || ClientAuthType.DisabledAll.equals((Object)this.channel.getSIPStack().getClientAuth())) ** GOTO lbl63
                        try {
                            ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setPeerCertificates(this.sslEngine.getSession().getPeerCertificates());
                        }
                        catch (SSLPeerUnverifiedException e) {
                            if (!SSLStateMachine.logger.isLoggingEnabled(32)) ** GOTO lbl63
                            SSLStateMachine.logger.logDebug("sslEngine.getSession().getPeerCertificates() are not available, which is normal if running with gov.nist.javax.sip.TLS_CLIENT_AUTH_TYPE=Disabled");
                        }
lbl63:
                        // 4 sources

                        ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setLocalCertificates(this.sslEngine.getSession().getLocalCertificates());
                        ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setCipherSuite(this.sslEngine.getSession().getCipherSuite());
                        ** GOTO lbl68
                    }
                    case 5: {
                        break block15;
                    }
lbl68:
                    // 6 sources

                    default: {
                        continue block15;
                    }
                }
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void wrapNonAppData() throws Exception {
        encryptedDataBuffer = this.channel.prepareEncryptedDataBuffer();
        do {
            result = this.sslEngine.wrap(SSLStateMachine.EMPTY_BUFFER, encryptedDataBuffer);
            if (SSLStateMachine.logger.isLoggingEnabled(32)) {
                SSLStateMachine.logger.logDebug("NonAppWrap result " + result + " buffers size " + this.pendingOutboundBuffers.size());
            }
            if (result.bytesProduced() > 0) {
                encryptedDataBuffer.flip();
                msg = new byte[encryptedDataBuffer.remaining()];
                encryptedDataBuffer.get(msg);
                this.sendSSLMetadata(msg);
                encryptedDataBuffer.clear();
            }
            switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[result.getHandshakeStatus().ordinal()]) {
                case 4: {
                    if (SSLStateMachine.logger.isLoggingEnabled(32)) {
                        SSLStateMachine.logger.logDebug("Handshake complete!");
                    }
                    if (!(this.channel instanceof NioTlsMessageChannel)) break;
                    ((NioTlsMessageChannel)this.channel).setHandshakeCompleted(true);
                    if (this.sslEngine.getSession() == null) break;
                    if (ClientAuthType.Disabled.equals((Object)this.channel.getSIPStack().getClientAuth()) || ClientAuthType.DisabledAll.equals((Object)this.channel.getSIPStack().getClientAuth())) ** GOTO lbl31
                    try {
                        ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setPeerCertificates(this.sslEngine.getSession().getPeerCertificates());
                    }
                    catch (SSLPeerUnverifiedException e) {
                        if (!SSLStateMachine.logger.isLoggingEnabled(32)) ** GOTO lbl31
                        SSLStateMachine.logger.logDebug("sslEngine.getSession().getPeerCertificates() are not available, which is normal if running with gov.nist.javax.sip.TLS_CLIENT_AUTH_TYPE=Disabled");
                    }
lbl31:
                    // 4 sources

                    ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setLocalCertificates(this.sslEngine.getSession().getLocalCertificates());
                    ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setCipherSuite(this.sslEngine.getSession().getCipherSuite());
                    break;
                }
                case 3: {
                    this.runDelegatedTasks(result);
                }
            }
        } while (result.bytesProduced() != 0);
    }

    public void unwrap(ByteBuffer src) throws Exception {
        ByteBuffer outputBuffer = this.channel.prepareAppDataBuffer();
        this.unwrap(src, outputBuffer);
    }

    private void startBuffer(ByteBuffer src) {
        if (this.tlsRecordBuffer == null) {
            this.tlsRecordBuffer = ByteBufferFactory.getInstance().allocateDirect(33270);
            this.tlsRecordBuffer.put(src);
            this.tlsRecordBuffer.flip();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Allocated record buffer for reading " + this.tlsRecordBuffer + " for src = " + src);
            }
        }
    }

    private void clearBuffer() {
        this.tlsRecordBuffer = null;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Buffer cleared");
        }
    }

    private ByteBuffer normalizeTlsRecordBuffer(ByteBuffer src) {
        if (this.tlsRecordBuffer == null) {
            return src;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Normalize buffer " + src + " into record buffer " + this.tlsRecordBuffer);
        }
        this.tlsRecordBuffer.position(this.tlsRecordBuffer.limit());
        this.tlsRecordBuffer.limit(this.tlsRecordBuffer.capacity());
        this.tlsRecordBuffer.put(src);
        this.tlsRecordBuffer.flip();
        return this.tlsRecordBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void unwrap(ByteBuffer src, ByteBuffer dst) throws Exception {
        var3_3 = this.unwrapLock;
        synchronized (var3_3) {
            block16: while (true) {
                src = this.normalizeTlsRecordBuffer(src);
                if (SSLStateMachine.logger.isLoggingEnabled(32)) {
                    SSLStateMachine.logger.logDebug("Unwrap src " + src + " dst " + dst);
                }
                result = null;
                try {
                    result = this.sslEngine.unwrap(src, dst);
                }
                catch (Exception e) {
                    if (SSLStateMachine.logger.isLoggingEnabled(32)) {
                        SSLStateMachine.logger.logDebug("An Exception occured while trying to unwrap the message " + e);
                    }
                    throw e;
                }
                if (SSLStateMachine.logger.isLoggingEnabled(32)) {
                    SSLStateMachine.logger.logDebug("Unwrap result " + result + " buffers size " + this.pendingOutboundBuffers.size() + " src=" + src + " dst=" + dst);
                }
                if (result.getStatus().equals((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW)) {
                    if (SSLStateMachine.logger.isLoggingEnabled(32)) {
                        SSLStateMachine.logger.logDebug("Buffer underflow, wait for the next inbound chunk of data to feed the SSL engine");
                    }
                    this.startBuffer(src);
                    break;
                }
                this.clearBuffer();
                if (result.getStatus().equals((Object)SSLEngineResult.Status.BUFFER_OVERFLOW)) {
                    if (SSLStateMachine.logger.isLoggingEnabled(32)) {
                        SSLStateMachine.logger.logDebug("Buffer overflow , must prepare the buffer again. outNetBuffer remaining: " + dst.remaining() + " outNetBuffer postion: " + dst.position() + " Packet buffer size: " + this.sslEngine.getSession().getPacketBufferSize() + " new buffer size: " + this.sslEngine.getSession().getPacketBufferSize() + dst.position());
                    }
                    newBuf = this.channel.prepareAppDataBuffer(this.sslEngine.getSession().getPacketBufferSize() + dst.position());
                    dst.flip();
                    newBuf.put(dst);
                    dst = newBuf;
                    if (!SSLStateMachine.logger.isLoggingEnabled(32)) continue;
                    SSLStateMachine.logger.logDebug(" new outNetBuffer remaining: " + dst.remaining() + " new outNetBuffer postion: " + dst.position());
                    continue;
                }
                if (result.bytesProduced() > 0) {
                    dst.flip();
                    a = new byte[dst.remaining()];
                    dst.get(a);
                    this.channel.addPlaintextBytes(a);
                }
                switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[result.getHandshakeStatus().ordinal()]) {
                    case 2: {
                        if (SSLStateMachine.logger.isLoggingEnabled(32)) {
                            SSLStateMachine.logger.logDebug("Unwrap has remaining: " + src.hasRemaining() + " buffer " + src);
                        }
                        if (!src.hasRemaining()) break block16;
                        ** GOTO lbl89
                    }
                    case 1: {
                        this.wrapNonAppData();
                        ** GOTO lbl89
                    }
                    case 3: {
                        this.runDelegatedTasks(result);
                        ** GOTO lbl89
                    }
                    case 4: {
                        if (SSLStateMachine.logger.isLoggingEnabled(32)) {
                            SSLStateMachine.logger.logDebug("Handshaking just finnished, but has remaining. Will try to wrap the queues app items.");
                        }
                        this.wrapRemaining();
                        if (src.hasRemaining()) ** GOTO lbl89
                        if (SSLStateMachine.logger.isLoggingEnabled(32)) {
                            SSLStateMachine.logger.logDebug("Handshake passed");
                        }
                        if (!(this.channel instanceof NioTlsMessageChannel)) break block16;
                        ((NioTlsMessageChannel)this.channel).setHandshakeCompleted(true);
                        if (this.sslEngine.getSession() == null) ** GOTO lbl75
                        if (ClientAuthType.Disabled.equals((Object)this.channel.getSIPStack().getClientAuth()) || ClientAuthType.DisabledAll.equals((Object)this.channel.getSIPStack().getClientAuth())) ** GOTO lbl73
                        try {
                            ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setPeerCertificates(this.sslEngine.getSession().getPeerCertificates());
                        }
                        catch (SSLPeerUnverifiedException e) {
                            if (!SSLStateMachine.logger.isLoggingEnabled(32)) ** GOTO lbl73
                            SSLStateMachine.logger.logDebug("sslEngine.getSession().getPeerCertificates() are not available, which is normal if running with gov.nist.javax.sip.TLS_CLIENT_AUTH_TYPE=Disabled");
                        }
lbl73:
                        // 4 sources

                        ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setLocalCertificates(this.sslEngine.getSession().getLocalCertificates());
                        ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setCipherSuite(this.sslEngine.getSession().getCipherSuite());
lbl75:
                        // 2 sources

                        try {
                            this.channel.getSIPStack().getTlsSecurityPolicy().enforceTlsPolicy(this.channel.getEncapsulatedClientTransaction());
                        }
                        catch (SecurityException ex) {
                            throw new IOException(ex.getMessage());
                        }
                        if (!SSLStateMachine.logger.isLoggingEnabled(32)) break block16;
                        SSLStateMachine.logger.logDebug("TLS Security policy passed");
                        break block16;
                    }
                    case 5: {
                        this.wrapRemaining();
                        if (SSLStateMachine.logger.isLoggingEnabled(32)) {
                            SSLStateMachine.logger.logDebug("Not handshaking, but has remaining: " + src.hasRemaining() + " buffer " + src);
                        }
                        if (!src.hasRemaining()) break block16;
                    }
lbl89:
                    // 6 sources

                    default: {
                        continue block16;
                    }
                }
                break;
            }
        }
    }

    private void runDelegatedTasks(SSLEngineResult result) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Running delegated task for " + result);
        }
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable runnable;
            while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
                runnable.run();
            }
            SSLEngineResult.HandshakeStatus hsStatus = this.sslEngine.getHandshakeStatus();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Handshake status after delegated tasks " + (Object)((Object)hsStatus));
            }
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                throw new IOException("handshake shouldn't need additional tasks");
            }
        }
    }

    public void sendSSLMetadata(byte[] msg) throws IOException {
        this.channel.sendEncryptedData(msg);
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus;

        static {
            $SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus = new int[SSLEngineResult.HandshakeStatus.values().length];
            try {
                1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NEED_WRAP.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NEED_UNWRAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NEED_TASK.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.FINISHED.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static class MessageSendItem {
        private ByteBuffer message;
        private MessageSendCallback callback;

        public MessageSendItem(ByteBuffer buffer, MessageSendCallback callback) {
            this.message = buffer;
            this.callback = callback;
        }

        public MessageSendCallback getCallBack() {
            return this.callback;
        }

        public String toString() {
            return MessageSendItem.class.getSimpleName() + " [" + this.message + ", " + this.callback + "]";
        }

        static /* synthetic */ ByteBuffer access$000(MessageSendItem x0) {
            return x0.message;
        }
    }

    public static interface MessageSendCallback {
        public void doSend(byte[] var1) throws IOException;
    }
}

