/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.startup.jboss;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.servlet.sip.SipServletRequest;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.startup.ContextConfig;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.DescriptionImpl;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.DisplayNameImpl;
import org.jboss.metadata.javaee.spec.DisplayNamesImpl;
import org.jboss.metadata.javaee.spec.IconImpl;
import org.jboss.metadata.javaee.spec.IconsImpl;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.TransportGuaranteeType;
import org.mobicents.metadata.sip.jboss.JBossConvergedSipMetaData;
import org.mobicents.metadata.sip.jboss.JBossSipServletsMetaData;
import org.mobicents.metadata.sip.spec.AndMetaData;
import org.mobicents.metadata.sip.spec.ConditionMetaData;
import org.mobicents.metadata.sip.spec.ContainsMetaData;
import org.mobicents.metadata.sip.spec.EqualMetaData;
import org.mobicents.metadata.sip.spec.ExistsMetaData;
import org.mobicents.metadata.sip.spec.NotMetaData;
import org.mobicents.metadata.sip.spec.OrMetaData;
import org.mobicents.metadata.sip.spec.PatternMetaData;
import org.mobicents.metadata.sip.spec.SipApplicationKeyMethodInfo;
import org.mobicents.metadata.sip.spec.SipLoginConfigMetaData;
import org.mobicents.metadata.sip.spec.SipResourceCollectionMetaData;
import org.mobicents.metadata.sip.spec.SipResourceCollectionsMetaData;
import org.mobicents.metadata.sip.spec.SipSecurityConstraintMetaData;
import org.mobicents.metadata.sip.spec.SipServletMappingMetaData;
import org.mobicents.metadata.sip.spec.SipServletSelectionMetaData;
import org.mobicents.metadata.sip.spec.SubdomainOfMetaData;
import org.mobicents.servlet.sip.catalina.CatalinaSipContext;
import org.mobicents.servlet.sip.catalina.SipDeploymentException;
import org.mobicents.servlet.sip.catalina.SipLoginConfig;
import org.mobicents.servlet.sip.catalina.SipSecurityCollection;
import org.mobicents.servlet.sip.catalina.SipSecurityConstraint;
import org.mobicents.servlet.sip.catalina.SipServletImpl;
import org.mobicents.servlet.sip.catalina.rules.AndRule;
import org.mobicents.servlet.sip.catalina.rules.ContainsRule;
import org.mobicents.servlet.sip.catalina.rules.EqualsRule;
import org.mobicents.servlet.sip.catalina.rules.ExistsRule;
import org.mobicents.servlet.sip.catalina.rules.NotRule;
import org.mobicents.servlet.sip.catalina.rules.OrRule;
import org.mobicents.servlet.sip.catalina.rules.SubdomainRule;
import org.mobicents.servlet.sip.core.descriptor.MatchingRule;
import org.mobicents.servlet.sip.core.descriptor.MobicentsSipServletMapping;
import org.mobicents.servlet.sip.core.security.MobicentsSipLoginConfig;
import org.mobicents.servlet.sip.startup.loading.SipServletMapping;

public class SipJBossContextConfig
extends ContextConfig {
    private static transient Logger logger = Logger.getLogger(SipJBossContextConfig.class);

    public SipJBossContextConfig(DeploymentUnit deploymentUnitContext) {
    }

    protected void processSipContextParameters(JBossConvergedSipMetaData metaData) {
        if (metaData.getSipContextParams() != null) {
            for (ParamValueMetaData paramValueMetaData : metaData.getSipContextParams()) {
                this.context.addParameter(paramValueMetaData.getParamName(), paramValueMetaData.getParamValue());
            }
        }
    }

    public void processSipMetaData(JBossConvergedSipMetaData convergedMetaData) throws Exception {
        SipApplicationKeyMethodInfo sipApplicationKeyMethodInfo;
        JBossSipServletsMetaData sipServlets;
        List<ListenerMetaData> sipListeners;
        SipLoginConfigMetaData sipLoginConfig;
        CatalinaSipContext convergedContext = (CatalinaSipContext)this.context;
        convergedContext.setWrapperClass(SipServletImpl.class.getName());
        DescriptionGroupMetaData descriptionGroupMetaData = convergedMetaData.getDescriptionGroup();
        if (descriptionGroupMetaData != null) {
            DisplayNamesImpl displayNamesImpl;
            IconsImpl iconsImpl;
            DescriptionsImpl descriptionsImpl = (DescriptionsImpl)descriptionGroupMetaData.getDescriptions();
            if (descriptionsImpl != null && !descriptionsImpl.isEmpty()) {
                convergedContext.setDescription(((DescriptionImpl)descriptionsImpl.iterator().next()).getDescription());
            }
            if ((iconsImpl = (IconsImpl)descriptionGroupMetaData.getIcons()) != null && !iconsImpl.isEmpty()) {
                IconImpl iconImpl = (IconImpl)iconsImpl.iterator().next();
                convergedContext.setSmallIcon(iconImpl.getSmallIcon());
                convergedContext.setLargeIcon(iconImpl.getLargeIcon());
            }
            if ((displayNamesImpl = (DisplayNamesImpl)descriptionGroupMetaData.getDisplayNames()) != null && !displayNamesImpl.isEmpty()) {
                convergedContext.setDisplayName(((DisplayNameImpl)displayNamesImpl.iterator().next()).getDisplayName());
            }
        }
        if (convergedMetaData.getDistributable() != null) {
            throw new SipDeploymentException("Distributable not supported yet");
        }
        List<? extends ParamValueMetaData> sipContextParams = convergedMetaData.getSipContextParams();
        if (sipContextParams != null) {
            for (ParamValueMetaData paramValueMetaData : sipContextParams) {
                convergedContext.addParameter(paramValueMetaData.getParamName(), paramValueMetaData.getParamValue());
            }
        }
        if (convergedMetaData.getApplicationName() == null) {
            throw new SipDeploymentException("No app-name present in the sip.xml deployment descriptor or no SipApplication annotation defined");
        }
        convergedContext.setApplicationName(convergedMetaData.getApplicationName());
        if (convergedMetaData.getProxyConfig() != null) {
            convergedContext.setProxyTimeout(convergedMetaData.getProxyConfig().getProxyTimeout());
        }
        if (convergedMetaData.getSipSessionConfig() != null) {
            convergedContext.setSipApplicationSessionTimeout(convergedMetaData.getSipSessionConfig().getSessionTimeout());
        }
        String securityDomain = convergedMetaData.getSecurityDomain();
        convergedContext.setSecurityDomain(securityDomain);
        List<SipSecurityConstraintMetaData> list = convergedMetaData.getSipSecurityConstraints();
        if (list != null) {
            for (SipSecurityConstraintMetaData sipConstraintMetaData : list) {
                SipSecurityConstraint sipSecurityConstraint = new SipSecurityConstraint();
                sipSecurityConstraint.setDisplayName(sipConstraintMetaData.getDisplayName());
                if (sipConstraintMetaData.getAuthConstraint() != null) {
                    for (String role : sipConstraintMetaData.getAuthConstraint().getRoleNames()) {
                        sipSecurityConstraint.addAuthRole(role);
                    }
                }
                if (sipConstraintMetaData.getProxyAuthentication() != null) {
                    sipSecurityConstraint.setProxyAuthentication(true);
                }
                TransportGuaranteeType tg = sipConstraintMetaData.getTransportGuarantee();
                sipSecurityConstraint.setUserConstraint(tg.name());
                SipResourceCollectionsMetaData srcs = sipConstraintMetaData.getResourceCollections();
                if (srcs != null) {
                    for (SipResourceCollectionMetaData src : srcs) {
                        List<String> servletNames;
                        SipSecurityCollection securityCollection = new SipSecurityCollection();
                        securityCollection.setName(src.getName());
                        List<String> methods = src.getSipMethods();
                        if (methods != null) {
                            for (String method : src.getSipMethods()) {
                                securityCollection.addSipMethod(method);
                            }
                        }
                        if ((servletNames = src.getServletNames()) != null) {
                            for (String servletName : servletNames) {
                                securityCollection.addServletName(servletName);
                            }
                        }
                        sipSecurityConstraint.addCollection(securityCollection);
                    }
                }
                convergedContext.addConstraint((SecurityConstraint)sipSecurityConstraint);
            }
        }
        if ((sipLoginConfig = convergedMetaData.getSipLoginConfig()) != null) {
            SipLoginConfig sipLoginConfig2 = new SipLoginConfig();
            sipLoginConfig2.setAuthMethod(sipLoginConfig.getAuthMethod());
            sipLoginConfig2.setRealmName(sipLoginConfig.getRealmName());
            if (sipLoginConfig.getIdentityAssertion() != null) {
                sipLoginConfig2.addIdentityAssertion(sipLoginConfig.getIdentityAssertion().getIdentityAssertionScheme(), sipLoginConfig.getIdentityAssertion().getIdentityAssertionSupport());
            }
            convergedContext.setSipLoginConfig((MobicentsSipLoginConfig)sipLoginConfig2);
        }
        if ((sipListeners = convergedMetaData.getSipListeners()) != null) {
            for (ListenerMetaData value : sipListeners) {
                convergedContext.addSipApplicationListener(value.getListenerClass());
            }
        }
        boolean servletSelectionSet = false;
        SipServletSelectionMetaData servletSelectionMetaData = convergedMetaData.getSipServletSelection();
        if (servletSelectionMetaData != null) {
            String mainServlet = servletSelectionMetaData.getMainServlet();
            if (mainServlet != null && mainServlet.length() > 0) {
                convergedContext.setMainServlet(mainServlet);
                servletSelectionSet = true;
            }
            if (servletSelectionMetaData.getSipServletMappings() != null && servletSelectionMetaData.getSipServletMappings().size() > 0) {
                if (servletSelectionSet) {
                    throw new SipDeploymentException("the main servlet and servlet mapping cannot be present at the same time in sip.xml or as annotations !");
                }
                for (SipServletMappingMetaData sipServletMappingMetaData : servletSelectionMetaData.getSipServletMappings()) {
                    SipServletMapping sipMapping = new SipServletMapping();
                    sipMapping.setServletName(sipServletMappingMetaData.getServletName());
                    PatternMetaData pattern = sipServletMappingMetaData.getPattern();
                    MatchingRule matchingRule = SipJBossContextConfig.buildRule(pattern.getCondition());
                    sipMapping.setMatchingRule(matchingRule);
                    convergedContext.addSipServletMapping((MobicentsSipServletMapping)sipMapping);
                }
                servletSelectionSet = true;
            }
            if (servletSelectionMetaData.getSipRubyController() != null) {
                convergedContext.setSipRubyController(servletSelectionMetaData.getSipRubyController());
                servletSelectionSet = true;
            }
        }
        if ((sipServlets = convergedMetaData.getSipServlets()) != null) {
            if (sipServlets.size() > 1 && !servletSelectionSet) {
                throw new SipDeploymentException("the main servlet is not set and there is more than one servlet defined in the sip.xml or as annotations !");
            }
            Iterator i$ = sipServlets.iterator();
            while (i$.hasNext()) {
                SecurityRoleRefsMetaData refs;
                List params;
                ServletMetaData value = (ServletMetaData)i$.next();
                SipServletImpl wrapper = (SipServletImpl)convergedContext.createWrapper();
                wrapper.setName(value.getName());
                if (!servletSelectionSet) {
                    convergedContext.setMainServlet(value.getName());
                }
                wrapper.setServletClass(value.getServletClass());
                wrapper.setServletName(value.getServletName());
                if (value.getJspFile() != null) {
                    wrapper.setJspFile(value.getJspFile());
                }
                wrapper.setLoadOnStartupString(value.getLoadOnStartup());
                wrapper.setLoadOnStartup(value.getLoadOnStartupInt());
                if (value.getRunAs() != null) {
                    wrapper.setRunAs(value.getRunAs().getRoleName());
                }
                if ((params = value.getInitParam()) != null) {
                    for (ParamValueMetaData param : params) {
                        wrapper.addInitParameter(param.getParamName(), param.getParamValue());
                    }
                }
                if ((refs = value.getSecurityRoleRefs()) != null) {
                    for (SecurityRoleRefMetaData ref : refs) {
                        wrapper.addSecurityReference(ref.getRoleName(), ref.getRoleLink());
                    }
                }
                convergedContext.addChild(wrapper);
            }
        }
        if ((sipApplicationKeyMethodInfo = convergedMetaData.getSipApplicationKeyMethodInfo()) != null) {
            String sipApplicationKeyClassName = sipApplicationKeyMethodInfo.getClassName();
            String sipApplicationKeyMethodName = sipApplicationKeyMethodInfo.getMethodName();
            ClassLoader contextCLoader = this.context.getLoader().getClassLoader();
            Method sipApplicationKeyMethod = null;
            sipApplicationKeyMethod = Class.forName(sipApplicationKeyClassName, true, contextCLoader).getMethod(sipApplicationKeyMethodName, SipServletRequest.class);
            convergedContext.setSipApplicationKeyMethod(sipApplicationKeyMethod);
        }
        convergedContext.setConcurrencyControlMode(convergedMetaData.getConcurrencyControlMode());
        convergedContext.setWrapperClass(StandardWrapper.class.getName());
    }

    public static MatchingRule buildRule(ConditionMetaData condition) {
        if (condition instanceof AndMetaData) {
            AndMetaData andMetaData = (AndMetaData)condition;
            AndRule and = new AndRule();
            List<ConditionMetaData> list = andMetaData.getConditions();
            for (ConditionMetaData newCondition : list) {
                and.addCriterion(SipJBossContextConfig.buildRule(newCondition));
            }
            return and;
        }
        if (condition instanceof EqualMetaData) {
            EqualMetaData equalMetaData = (EqualMetaData)condition;
            String var = equalMetaData.getVar();
            String value = equalMetaData.getValue();
            boolean ignoreCase = equalMetaData.isIgnoreCase();
            return new EqualsRule(var, value, ignoreCase);
        }
        if (condition instanceof SubdomainOfMetaData) {
            SubdomainOfMetaData subdomainOfMetaData = (SubdomainOfMetaData)condition;
            String var = subdomainOfMetaData.getVar();
            String value = subdomainOfMetaData.getValue();
            return new SubdomainRule(var, value);
        }
        if (condition instanceof OrMetaData) {
            OrMetaData orMetaData = (OrMetaData)condition;
            OrRule or = new OrRule();
            List<ConditionMetaData> list = orMetaData.getConditions();
            for (ConditionMetaData newCondition : list) {
                or.addCriterion(SipJBossContextConfig.buildRule(newCondition));
            }
            return or;
        }
        if (condition instanceof NotMetaData) {
            NotMetaData notMetaData = (NotMetaData)condition;
            NotRule not = new NotRule();
            not.setCriterion(SipJBossContextConfig.buildRule(notMetaData.getCondition()));
            return not;
        }
        if (condition instanceof ContainsMetaData) {
            ContainsMetaData containsMetaData = (ContainsMetaData)condition;
            String var = containsMetaData.getVar();
            String value = containsMetaData.getValue();
            boolean ignoreCase = containsMetaData.isIgnoreCase();
            return new ContainsRule(var, value, ignoreCase);
        }
        if (condition instanceof ExistsMetaData) {
            ExistsMetaData existsMetaData = (ExistsMetaData)condition;
            return new ExistsRule(existsMetaData.getVar());
        }
        throw new IllegalArgumentException("Unknown rule: " + (Object)((Object)condition));
    }
}

