/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.metadata.sip.spec;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    AND("and"),
    APPLICATION_NAME("app-name"),
    AUTH_CONSTRAINT("auth-constraint"),
    AUTH_METHOD("auth-method"),
    CONDITION("condition"),
    CONTAINS("contains"),
    CONTEXT_PARAM("context-param"),
    DESCRIPTION("description"),
    DISPLAY_NAME("display-name"),
    DISTRIBUTABLE("distributable"),
    EQUAL("equal"),
    EXISTS("exists"),
    IDENTITY_ASSERTION("identity-assertion"),
    IDENTITY_ASSERTION_SCHEME("identity-assertion-scheme"),
    IDENTITY_ASSERTION_SUPPORT("identity-assertion-support"),
    LISTENER("listener"),
    LOCALE_ENCODING_MAPPING_LIST("locale-encoding-mapping-list"),
    LOGIN_CONFIG("login-config"),
    MAIN_SERVLET("main-servlet"),
    MESSAGE_DESTINATION("message-destination"),
    NOT("not"),
    OR("or"),
    PATTERN("pattern"),
    PROXY_AUTHENTICATION("proxy-authentication"),
    PROXY_CONFIG("proxy-config"),
    PROXY_TIMEOUT("proxy-timeout"),
    REALM_NAME("realm-name"),
    RESOURCE_COLLECTION("resource-collection"),
    RESOURCE_NAME("resource-name"),
    SECURITY_CONSTRAINT("security-constraint"),
    SECURITY_ROLE("security-role"),
    SERVLET_MAPPING("servlet-mapping"),
    SERVLET_NAME("servlet-name"),
    SERVLET_SELECTION("servlet-selection"),
    SERVLET("servlet"),
    SESSION_CONFIG("session-config"),
    SIP_METHOD("sip-method"),
    SUBDOMAIN_OF("subdomain-of"),
    USER_DATA_CONSTRAINT("user-data-constraint"),
    VALUE("value"),
    VAR("var");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

