/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.metadata.sip.parser;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.parser.ee.EnvironmentRefsGroupMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.mobicents.metadata.sip.parser.SipCommonMetaDataParser;
import org.mobicents.metadata.sip.spec.Attribute;
import org.mobicents.metadata.sip.spec.Element;
import org.mobicents.metadata.sip.spec.Sip11MetaData;
import org.mobicents.metadata.sip.spec.SipMetaData;

public class SipMetaDataParser
extends MetaDataElementParser {
    public static SipMetaData parse(XMLStreamReader reader, MetaDataElementParser.DTDInfo info) throws XMLStreamException {
        return SipMetaDataParser.parse(reader, info, false);
    }

    public static SipMetaData parse(XMLStreamReader reader, MetaDataElementParser.DTDInfo info, boolean validation) throws XMLStreamException {
        if (reader == null) {
            throw new IllegalArgumentException("Null reader");
        }
        if (info == null) {
            throw new IllegalArgumentException("Null info");
        }
        reader.require(7, null, null);
        while (reader.hasNext() && reader.next() != 1) {
        }
        String schemaLocation = SipMetaDataParser.readSchemaLocation((XMLStreamReader)reader);
        Sip11MetaData smd = new Sip11MetaData();
        if (info != null) {
            smd.setDTD(info.getBaseURI(), info.getPublicID(), info.getSystemID());
        }
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (SipMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSION: {
                    smd.setVersion(value);
                    continue block7;
                }
                case METADATA_COMPLETE: {
                    if (smd instanceof Sip11MetaData) {
                        if (!Boolean.TRUE.equals(Boolean.valueOf(value))) continue block7;
                        smd.setMetadataComplete(true);
                        continue block7;
                    }
                    throw SipMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
                default: {
                    throw SipMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        EnvironmentRefsGroupMetaData env = new EnvironmentRefsGroupMetaData();
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (EnvironmentRefsGroupMetaDataParser.parse((XMLStreamReader)reader, (EnvironmentRefsGroupMetaData)env)) {
                if (smd.getJndiEnvironmentRefsGroup() != null) continue;
                smd.setJndiEnvironmentRefsGroup(env);
                continue;
            }
            if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (DescriptionGroupMetaData)descriptionGroup)) {
                if (smd.getDescriptionGroup() != null) continue;
                smd.setDescriptionGroup(descriptionGroup);
                continue;
            }
            if (SipCommonMetaDataParser.parse(reader, smd)) continue;
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            throw SipMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return smd;
    }
}

