/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.metadata.sip.parser;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.parser.ee.MessageDestinationMetaDataParser;
import org.jboss.metadata.parser.ee.ParamValueMetaDataParser;
import org.jboss.metadata.parser.ee.SecurityRoleMetaDataParser;
import org.jboss.metadata.parser.servlet.ListenerMetaDataParser;
import org.jboss.metadata.parser.servlet.LocaleEncodingsMetaDataParser;
import org.jboss.metadata.parser.servlet.ServletMetaDataParser;
import org.jboss.metadata.parser.servlet.SessionConfigMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.mobicents.metadata.sip.parser.ProxyConfigMetaDataParser;
import org.mobicents.metadata.sip.parser.SipLoginConfigMetaDataParser;
import org.mobicents.metadata.sip.parser.SipSecurityConstraintMetaDataParser;
import org.mobicents.metadata.sip.parser.SipServletSelectionMetaDataParser;
import org.mobicents.metadata.sip.spec.Element;
import org.mobicents.metadata.sip.spec.SipMetaData;
import org.mobicents.metadata.sip.spec.SipSecurityConstraintMetaData;
import org.mobicents.metadata.sip.spec.SipServletsMetaData;

public class SipCommonMetaDataParser
extends MetaDataElementParser {
    public static boolean parse(XMLStreamReader reader, SipMetaData smd) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case APPLICATION_NAME: {
                smd.setApplicationName(SipCommonMetaDataParser.getElementText((XMLStreamReader)reader));
                break;
            }
            case DISTRIBUTABLE: {
                throw SipCommonMetaDataParser.unexpectedElement((XMLStreamReader)reader);
            }
            case CONTEXT_PARAM: {
                ArrayList<ParamValueMetaData> contextParams = smd.getContextParams();
                if (contextParams == null) {
                    contextParams = new ArrayList<ParamValueMetaData>();
                    smd.setContextParams(contextParams);
                }
                contextParams.add(ParamValueMetaDataParser.parse((XMLStreamReader)reader));
                break;
            }
            case LISTENER: {
                ArrayList<ListenerMetaData> listeners = smd.getListeners();
                if (listeners == null) {
                    listeners = new ArrayList<ListenerMetaData>();
                    smd.setListeners(listeners);
                }
                listeners.add(ListenerMetaDataParser.parse((XMLStreamReader)reader, (PropertyReplacer)PropertyReplacers.noop()));
                break;
            }
            case SERVLET_SELECTION: {
                smd.setServletSelection(SipServletSelectionMetaDataParser.parse(reader));
                break;
            }
            case SERVLET: {
                SipServletsMetaData servlets = smd.getSipServlets();
                if (servlets == null) {
                    servlets = new SipServletsMetaData();
                    smd.setSipServlets(servlets);
                }
                servlets.add((MappableMetaData)ServletMetaDataParser.parse((XMLStreamReader)reader, (PropertyReplacer)PropertyReplacers.noop()));
                break;
            }
            case PROXY_CONFIG: {
                smd.setProxyConfig(ProxyConfigMetaDataParser.parse(reader));
                break;
            }
            case SESSION_CONFIG: {
                if (smd.getSessionConfig() != null) {
                    throw new XMLStreamException("Multiple session-config elements detected", reader.getLocation());
                }
                smd.setSessionConfig(SessionConfigMetaDataParser.parse((XMLStreamReader)reader, (PropertyReplacer)PropertyReplacers.noop()));
                break;
            }
            case SECURITY_CONSTRAINT: {
                List<SipSecurityConstraintMetaData> sipSecurityConstraints = smd.getSipSecurityConstraints();
                if (sipSecurityConstraints == null) {
                    sipSecurityConstraints = new ArrayList<SipSecurityConstraintMetaData>();
                    smd.setSipSecurityConstraints(sipSecurityConstraints);
                }
                sipSecurityConstraints.add(SipSecurityConstraintMetaDataParser.parse(reader));
                break;
            }
            case LOGIN_CONFIG: {
                if (smd.getSipLoginConfig() != null) {
                    throw new XMLStreamException("Multiple login-config elements detected", reader.getLocation());
                }
                smd.setSipLoginConfig(SipLoginConfigMetaDataParser.parse(reader));
                break;
            }
            case SECURITY_ROLE: {
                SecurityRolesMetaData securityRoles = smd.getSecurityRoles();
                if (securityRoles == null) {
                    securityRoles = new SecurityRolesMetaData();
                    smd.setSecurityRoles(securityRoles);
                }
                securityRoles.add((MappableMetaData)SecurityRoleMetaDataParser.parse((XMLStreamReader)reader));
                break;
            }
            case MESSAGE_DESTINATION: {
                MessageDestinationsMetaData messageDestinations = smd.getMessageDestinations();
                if (messageDestinations == null) {
                    messageDestinations = new MessageDestinationsMetaData();
                    smd.setMessageDestinations(messageDestinations);
                }
                messageDestinations.add((MappableMetaData)MessageDestinationMetaDataParser.parse((XMLStreamReader)reader, (PropertyReplacer)PropertyReplacers.noop()));
                break;
            }
            case LOCALE_ENCODING_MAPPING_LIST: {
                smd.setLocalEncodings(LocaleEncodingsMetaDataParser.parse((XMLStreamReader)reader, (PropertyReplacer)PropertyReplacers.noop()));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

