/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.as7.deployment;

import java.util.Iterator;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.dmr.ModelNode;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.vfs.VirtualFile;
import org.mobicents.as7.SipDeploymentDefinition;
import org.mobicents.as7.SipMessages;
import org.mobicents.as7.SipSubsystemServices;
import org.mobicents.as7.deployment.SipDeploymentService;
import org.mobicents.metadata.sip.spec.SipMetaData;

public class SipWarDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData metaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (metaData == null) {
            return;
        }
        this.processDeployment(deploymentUnit, phaseContext.getServiceTarget());
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected void processDeployment(DeploymentUnit deploymentUnit, ServiceTarget serviceTarget) throws DeploymentUnitProcessingException {
        VirtualFile deploymentRoot = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw new DeploymentUnitProcessingException(SipMessages.MESSAGES.failedToResolveModule(deploymentRoot));
        }
        SipMetaData sipMetaData = (SipMetaData)((Object)deploymentUnit.getAttachment(SipMetaData.ATTACHMENT_KEY));
        if (sipMetaData != null) {
            String appNameMgmt = sipMetaData.getApplicationName();
            ServiceName deploymentServiceName = SipSubsystemServices.deploymentServiceName(appNameMgmt);
            try {
                SipDeploymentService sipDeploymentService = new SipDeploymentService(deploymentUnit);
                ServiceBuilder builder = serviceTarget.addService(deploymentServiceName, (Service)sipDeploymentService);
                builder.addDependency(deploymentServiceName);
                builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
            }
            catch (ServiceRegistryException e) {
                throw new DeploymentUnitProcessingException(SipMessages.MESSAGES.failedToAddSipDeployment(), (Throwable)e);
            }
            ModelNode node = deploymentUnit.getDeploymentSubsystemModel("sip");
            node.get(SipDeploymentDefinition.APP_NAME.getName()).set("".equals(appNameMgmt) ? "/" : appNameMgmt);
            this.processManagement(deploymentUnit, sipMetaData);
        }
    }

    void processManagement(DeploymentUnit unit, SipMetaData sipMetaData) {
        if (sipMetaData.getSipServlets() != null) {
            Iterator i$ = sipMetaData.getSipServlets().iterator();
            while (i$.hasNext()) {
                ServletMetaData servlet = (ServletMetaData)i$.next();
                try {
                    String name = servlet.getName().replace(' ', '_');
                    ModelNode node = unit.createDeploymentSubModel("sip", PathElement.pathElement((String)"servlet", (String)name));
                    node.get("servlet-class").set(servlet.getServletClass());
                    node.get("servlet-name").set(servlet.getServletName());
                    node.get("load-on-startup").set(servlet.getLoadOnStartup());
                }
                catch (Exception e) {}
            }
        }
    }
}

