/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.as7.deployment;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.vfs.VirtualFile;
import org.mobicents.metadata.sip.parser.SipMetaDataParser;
import org.mobicents.metadata.sip.spec.SipMetaData;

public class SipParsingDeploymentProcessor
implements DeploymentUnitProcessor {
    protected static final String SIP_XML = "WEB-INF/sip.xml";
    private final boolean schemaValidation = true;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        VirtualFile rootFile = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        VirtualFile sipXml = null;
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            sipXml = rootFile.getChild(SIP_XML);
        }
        if (sipXml == null || !sipXml.exists()) {
            return;
        }
        InputStream is = null;
        try {
            is = sipXml.openStream();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            MetaDataElementParser.DTDInfo dtdInfo = new MetaDataElementParser.DTDInfo();
            inputFactory.setXMLResolver((XMLResolver)dtdInfo);
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
            SipMetaData sipMetaData = SipMetaDataParser.parse(xmlReader, dtdInfo);
            deploymentUnit.putAttachment(SipMetaData.ATTACHMENT_KEY, (Object)sipMetaData);
        }
        catch (XMLStreamException e) {
            throw new DeploymentUnitProcessingException("Failed to parse " + sipXml + " at [" + e.getLocation().getLineNumber() + "," + e.getLocation().getColumnNumber() + "]");
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException("Failed to parse " + sipXml, (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

