/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.as7.deployment;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessor;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessorRegistry;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.mobicents.as7.deployment.SIPWebContext;
import org.mobicents.as7.deployment.SipFactoryInjectionSource;
import org.mobicents.as7.deployment.SipFactoryResourceProcessor;
import org.mobicents.as7.deployment.SipSessionsUtilInjectionSource;
import org.mobicents.as7.deployment.SipSessionsUtilResourceProcessor;
import org.mobicents.as7.deployment.SipTimerServiceInjectionSource;
import org.mobicents.as7.deployment.SipTimerServiceResourceProcessor;
import org.mobicents.metadata.sip.spec.SipAnnotationMetaData;
import org.mobicents.metadata.sip.spec.SipMetaData;

public class SipJndiBindingProcessor
implements DeploymentUnitProcessor {
    static final String[] JNDI_BASE_FOR_SIP = new String[]{"java:comp/env/", "java:app/"};
    static final String SIP_PREFIX_JNDI = "sip/";
    static final String SIP_FACTORY_JNDI = "SipFactory";
    static final String SIP_SESSIONS_UTIL_JNDI = "SipSessionsUtil";
    static final String SIP_TIMER_SERVICE_JNDI = "TimerService";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parentDU = deploymentUnit.getParent();
        String sipApplicationName = null;
        SipMetaData sipMetaData = (SipMetaData)((Object)deploymentUnit.getAttachment(SipMetaData.ATTACHMENT_KEY));
        SipAnnotationMetaData sipAnnotationMetaData = (SipAnnotationMetaData)deploymentUnit.getAttachment(SipAnnotationMetaData.ATTACHMENT_KEY);
        if (sipMetaData != null) {
            sipApplicationName = sipMetaData.getApplicationName();
        } else if (sipAnnotationMetaData != null && sipAnnotationMetaData.isSipApplicationAnnotationPresent()) {
            sipApplicationName = ((SipMetaData)((Object)sipAnnotationMetaData.get("classes"))).getApplicationName();
        } else if (parentDU != null) {
            AttachmentList subDeploymentList = (AttachmentList)parentDU.getAttachment(org.jboss.as.server.deployment.Attachments.SUB_DEPLOYMENTS);
            for (DeploymentUnit subDeployment : subDeploymentList) {
                sipMetaData = (SipMetaData)((Object)subDeployment.getAttachment(SipMetaData.ATTACHMENT_KEY));
                sipAnnotationMetaData = (SipAnnotationMetaData)deploymentUnit.getAttachment(SipAnnotationMetaData.ATTACHMENT_KEY);
                if (sipMetaData != null) {
                    sipApplicationName = sipMetaData.getApplicationName();
                    break;
                }
                if (sipAnnotationMetaData == null || !sipAnnotationMetaData.isSipApplicationAnnotationPresent()) continue;
                sipApplicationName = ((SipMetaData)((Object)sipAnnotationMetaData.get("classes"))).getApplicationName();
                break;
            }
        }
        if (sipApplicationName == null) {
            return;
        }
        DeploymentUnit anchorDU = SIPWebContext.getSipContextAnchorDu(deploymentUnit);
        SipJndiBindingProcessor.setupSipJndiBindingsPerDeploymentUnit(anchorDU, deploymentUnit, sipApplicationName);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static void setupSipJndiBindingsPerDeploymentUnit(DeploymentUnit anchorDU, DeploymentUnit subDU, String sipApplicationName) {
        EEResourceReferenceProcessorRegistry registry = (EEResourceReferenceProcessorRegistry)subDU.getAttachment(Attachments.RESOURCE_REFERENCE_PROCESSOR_REGISTRY);
        registry.registerResourceReferenceProcessor((EEResourceReferenceProcessor)new SipFactoryResourceProcessor(anchorDU));
        registry.registerResourceReferenceProcessor((EEResourceReferenceProcessor)new SipSessionsUtilResourceProcessor(anchorDU));
        registry.registerResourceReferenceProcessor((EEResourceReferenceProcessor)new SipTimerServiceResourceProcessor(anchorDU));
        EEModuleDescription description = (EEModuleDescription)subDU.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (description == null) {
            return;
        }
        for (String jndiBaseSip : JNDI_BASE_FOR_SIP) {
            String jndiBaseMapped = jndiBaseSip + SIP_PREFIX_JNDI + sipApplicationName + "/";
            description.getBindingConfigurations().add(new BindingConfiguration(jndiBaseMapped + SIP_FACTORY_JNDI, (InjectionSource)new SipFactoryInjectionSource(anchorDU)));
            description.getBindingConfigurations().add(new BindingConfiguration(jndiBaseMapped + SIP_SESSIONS_UTIL_JNDI, (InjectionSource)new SipSessionsUtilInjectionSource(anchorDU)));
            description.getBindingConfigurations().add(new BindingConfiguration(jndiBaseMapped + SIP_TIMER_SERVICE_JNDI, (InjectionSource)new SipTimerServiceInjectionSource(anchorDU)));
        }
    }
}

