/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.as7.deployment;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.ext.WebContextFactory;
import org.jboss.logging.Logger;
import org.mobicents.as7.deployment.SIPContextFactory;
import org.mobicents.metadata.sip.spec.SipAnnotationMetaData;
import org.mobicents.metadata.sip.spec.SipMetaData;

public class SipContextFactoryDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(SipContextFactoryDeploymentProcessor.class);
    public static final DeploymentUnitProcessor INSTANCE = new SipContextFactoryDeploymentProcessor();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        SipMetaData sipMetaData = (SipMetaData)((Object)deploymentUnit.getAttachment(SipMetaData.ATTACHMENT_KEY));
        if (sipMetaData == null) {
            SipAnnotationMetaData sipAnnotationMetaData;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(deploymentUnit.getName() + " has null sipMetaData, checking annotations"));
            }
            if ((sipAnnotationMetaData = (SipAnnotationMetaData)deploymentUnit.getAttachment(SipAnnotationMetaData.ATTACHMENT_KEY)) == null || !sipAnnotationMetaData.isSipApplicationAnnotationPresent()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(deploymentUnit.getName() + " has null sipMetaData and no SipApplication annotation, no Sip context factory installed"));
                }
                return;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(deploymentUnit.getName() + " sip context factory installed"));
        }
        SIPContextFactory contextFactory = new SIPContextFactory();
        deploymentUnit.putAttachment(WebContextFactory.ATTACHMENT, (Object)contextFactory);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

