/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.as7.deployment;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.web.deployment.WebAttachments;
import org.jboss.as.web.deployment.component.WebComponentDescription;
import org.jboss.as.web.deployment.component.WebComponentInstantiator;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.mobicents.metadata.sip.spec.SipAnnotationMetaData;
import org.mobicents.metadata.sip.spec.SipMetaData;

public class SipComponentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        HashMap<String, ComponentDescription> componentByClass = new HashMap<String, ComponentDescription>();
        HashMap<String, WebComponentInstantiator> webComponents = (HashMap<String, WebComponentInstantiator>)deploymentUnit.getAttachment(WebAttachments.WEB_COMPONENT_INSTANTIATORS);
        if (webComponents == null) {
            webComponents = new HashMap<String, WebComponentInstantiator>();
            deploymentUnit.putAttachment(WebAttachments.WEB_COMPONENT_INSTANTIATORS, webComponents);
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationClasses applicationClassesDescription = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (moduleDescription == null) {
            return;
        }
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            componentByClass.put(component.getComponentClassName(), component);
        }
        SipMetaData sipMetaData = (SipMetaData)((Object)deploymentUnit.getAttachment(SipMetaData.ATTACHMENT_KEY));
        SipAnnotationMetaData sipAnnotationMetaData = (SipAnnotationMetaData)deploymentUnit.getAttachment(SipAnnotationMetaData.ATTACHMENT_KEY);
        if (sipMetaData == null && sipAnnotationMetaData == null) {
            return;
        }
        Set<String> classes = this.getAllComponentClasses(deploymentUnit, compositeIndex, sipMetaData, sipAnnotationMetaData);
        for (String clazz : classes) {
            ComponentDescription description;
            if (clazz == null || clazz.trim().isEmpty() || (description = (ComponentDescription)componentByClass.get(clazz)) != null) continue;
            description = new WebComponentDescription(clazz, clazz, moduleDescription, deploymentUnit.getServiceName(), applicationClassesDescription);
            moduleDescription.addComponent(description);
            webComponents.put(clazz, new WebComponentInstantiator(deploymentUnit, description));
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private Set<String> getAllComponentClasses(DeploymentUnit deploymentUnit, CompositeIndex index, SipMetaData sipMetaData, SipAnnotationMetaData sipAnnotationMetaData) {
        HashSet<String> classes = new HashSet<String>();
        if (sipAnnotationMetaData != null) {
            for (Map.Entry metaData : sipAnnotationMetaData.entrySet()) {
                this.getAllComponentClasses((SipMetaData)((Object)metaData.getValue()), classes);
            }
        }
        if (sipMetaData != null) {
            this.getAllComponentClasses(sipMetaData, classes);
        }
        return classes;
    }

    private void getAllComponentClasses(SipMetaData sipMetaData, Set<String> classes) {
        if (sipMetaData.getSipServlets() != null) {
            Iterator i$ = sipMetaData.getSipServlets().iterator();
            while (i$.hasNext()) {
                ServletMetaData servlet = (ServletMetaData)i$.next();
                if (servlet.getServletClass() == null) continue;
                classes.add(servlet.getServletClass());
            }
        }
        if (sipMetaData.getListeners() != null) {
            for (ListenerMetaData listener : sipMetaData.getListeners()) {
                classes.add(listener.getListenerClass());
            }
        }
    }
}

