/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.as7.deployment;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.annotation.SipApplication;
import javax.servlet.sip.annotation.SipApplicationKey;
import javax.servlet.sip.annotation.SipListener;
import javax.servlet.sip.annotation.SipServlet;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.annotation.javaee.DisplayNames;
import org.jboss.annotation.javaee.Icons;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.AnnotationIndexUtils;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.DescriptionImpl;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.DisplayNameImpl;
import org.jboss.metadata.javaee.spec.DisplayNamesImpl;
import org.jboss.metadata.javaee.spec.IconImpl;
import org.jboss.metadata.javaee.spec.IconsImpl;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.vfs.VirtualFile;
import org.mobicents.metadata.sip.spec.ProxyConfigMetaData;
import org.mobicents.metadata.sip.spec.Sip11MetaData;
import org.mobicents.metadata.sip.spec.SipAnnotationMetaData;
import org.mobicents.metadata.sip.spec.SipApplicationKeyMethodInfo;
import org.mobicents.metadata.sip.spec.SipMetaData;
import org.mobicents.metadata.sip.spec.SipServletSelectionMetaData;
import org.mobicents.metadata.sip.spec.SipServletsMetaData;
import org.mobicents.servlet.sip.annotation.ConcurrencyControl;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;

public class SipAnnotationDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(SipAnnotationDeploymentProcessor.class);
    protected static final DotName sipListener = DotName.createSimple((String)SipListener.class.getName());
    protected static final DotName sipServlet = DotName.createSimple((String)SipServlet.class.getName());
    protected static final DotName sipApplication = DotName.createSimple((String)SipApplication.class.getName());
    protected static final DotName sipApplicationKey = DotName.createSimple((String)SipApplicationKey.class.getName());
    protected static final DotName concurrencyControl = DotName.createSimple((String)ConcurrencyControl.class.getName());
    static final String SIP_XML = "WEB-INF/sip.xml";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        SipAnnotationMetaData sipAnnotationsMetaData = (SipAnnotationMetaData)deploymentUnit.getAttachment(SipAnnotationMetaData.ATTACHMENT_KEY);
        if (sipAnnotationsMetaData == null) {
            sipAnnotationsMetaData = new SipAnnotationMetaData();
            deploymentUnit.putAttachment(SipAnnotationMetaData.ATTACHMENT_KEY, (Object)sipAnnotationsMetaData);
        }
        Map indexes = AnnotationIndexUtils.getAnnotationIndexes((DeploymentUnit)deploymentUnit);
        for (Map.Entry entry : indexes.entrySet()) {
            Index jarIndex;
            SipMetaData sipMetaData;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("doDeploy(): processing annotations from " + ((ResourceRoot)entry.getKey()).getRootName()));
            }
            if ((sipMetaData = this.processAnnotations(sipAnnotationsMetaData, jarIndex = (Index)entry.getValue())) == null) continue;
            sipAnnotationsMetaData.put(((ResourceRoot)entry.getKey()).getRootName(), sipMetaData);
        }
    }

    protected SipMetaData processAnnotations(SipAnnotationMetaData sipAnotationsMetaData, Index index) throws DeploymentUnitProcessingException {
        List concurrencyControlAnnotations;
        List sipApplicationKeyAnnotations;
        List sipServletAnnotations;
        AnnotationTarget target;
        Sip11MetaData sipMetaData = null;
        List sipListenerAnnotations = index.getAnnotations(sipListener);
        if (sipListenerAnnotations != null && sipListenerAnnotations.size() > 0) {
            sipMetaData = new Sip11MetaData();
            ArrayList<ListenerMetaData> listeners = new ArrayList<ListenerMetaData>();
            for (AnnotationInstance annotation : sipListenerAnnotations) {
                DescriptionGroupMetaData descriptionGroup;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("processAnnotations(): @SipListener: " + annotation));
                }
                ListenerMetaData listener = new ListenerMetaData();
                target = annotation.target();
                if (!(target instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException("@SipListener is only allowed at class level " + target);
                }
                ClassInfo classInfo = (ClassInfo)ClassInfo.class.cast(target);
                listener.setListenerClass(classInfo.toString());
                AnnotationValue descriptionValue = annotation.value();
                if (descriptionValue != null && (descriptionGroup = this.getDescriptionGroup(descriptionValue.asString())) != null) {
                    listener.setDescriptionGroup(descriptionGroup);
                }
                for (AnnotationValue value : annotation.values()) {
                    if (value.name().compareTo("name") == 0 || value.name().compareTo("applicationName") != 0) continue;
                    if (sipMetaData.getApplicationName() == null) {
                        sipMetaData.setApplicationName(value.asString());
                        continue;
                    }
                    if (sipMetaData.getApplicationName() == null || sipMetaData.getApplicationName().compareTo(value.asString()) == 0) continue;
                    throw new DeploymentUnitProcessingException("Sip Application Name mismatch: already loaded: " + sipMetaData.getApplicationName() + " - from @SipListener annotation (" + listener.getListenerClass() + "): " + value.asString());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("processAnnotations(): sipListener added " + listener));
                }
                listeners.add(listener);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("processAnnotations(): " + listeners.size() + " sipListeners added"));
            }
            sipMetaData.setListeners(listeners);
        }
        if ((sipServletAnnotations = index.getAnnotations(sipServlet)) != null && sipServletAnnotations.size() > 0) {
            if (sipMetaData == null) {
                sipMetaData = new Sip11MetaData();
            }
            SipServletsMetaData sipServlets = new SipServletsMetaData();
            List sipApplicationAnnotations = index.getAnnotations(sipApplication);
            boolean sipApplicationPresent = false;
            String parsedAnnotatedPackage = null;
            if (sipApplicationAnnotations != null && sipApplicationAnnotations.size() > 0) {
                sipApplicationPresent = true;
            }
            for (AnnotationInstance annotation : sipServletAnnotations) {
                DescriptionGroupMetaData descriptionGroup;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("processAnnotations(): @SipServlet: " + annotation));
                }
                ServletMetaData servlet = new ServletMetaData();
                AnnotationTarget target2 = annotation.target();
                if (!(target2 instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException("@SipServlet is only allowed at class level " + target2);
                }
                ClassInfo classInfo = (ClassInfo)ClassInfo.class.cast(target2);
                servlet.setServletClass(classInfo.toString());
                AnnotationValue descriptionValue = annotation.value();
                if (descriptionValue != null && (descriptionGroup = this.getDescriptionGroup(descriptionValue.asString())) != null) {
                    servlet.setDescriptionGroup(descriptionGroup);
                }
                for (AnnotationValue value : annotation.values()) {
                    if (value.name().compareTo("name") == 0) {
                        servlet.setName(value.asString());
                        continue;
                    }
                    if (value.name().compareTo("loadOnStartup") == 0) {
                        servlet.setLoadOnStartup(value.asString());
                        continue;
                    }
                    if (value.name().compareTo("applicationName") != 0) continue;
                    if (sipMetaData.getApplicationName() == null) {
                        sipMetaData.setApplicationName(value.asString());
                        continue;
                    }
                    if (sipMetaData.getApplicationName() == null || sipMetaData.getApplicationName().compareTo(value.asString()) == 0) continue;
                    throw new DeploymentUnitProcessingException("Sip Application Name mismatch: already loaded: " + sipMetaData.getApplicationName() + " - from @SipServlet annotation (" + servlet.getServletClass() + "): " + value.asString());
                }
                if (servlet.getName() == null) {
                    servlet.setName(servlet.getServletClass());
                }
                if (sipApplicationPresent) {
                    sipAnotationsMetaData.setSipApplicationAnnotationPresent(true);
                    AnnotationInstance sipAppAnnotation = (AnnotationInstance)sipApplicationAnnotations.get(0);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("processAnnotations(): @SipAnnotation: " + annotation));
                    }
                    AnnotationTarget sipAppTarget = sipAppAnnotation.target();
                    if (!(target2 instanceof ClassInfo)) {
                        throw new DeploymentUnitProcessingException("@SipAnnotation is only allowed at class level " + target2);
                    }
                    ClassInfo sipAppClassInfo = (ClassInfo)ClassInfo.class.cast(sipAppTarget);
                    String packageName = sipAppClassInfo.toString().substring(0, sipAppClassInfo.toString().lastIndexOf(46));
                    if (parsedAnnotatedPackage != null && !parsedAnnotatedPackage.equals(packageName)) {
                        throw new DeploymentUnitProcessingException("Cant have two different applications in a single context - " + packageName + " and " + parsedAnnotatedPackage);
                    }
                    if (parsedAnnotatedPackage == null) {
                        parsedAnnotatedPackage = packageName;
                        this.parseSipApplication(sipMetaData, sipAppAnnotation, packageName);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("processAnnotations(): sipServlet added " + servlet));
                }
                sipServlets.add((MappableMetaData)servlet);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("processAnnotations(): " + sipServlets.size() + " sipServlets added"));
            }
            sipMetaData.setSipServlets(sipServlets);
        }
        if ((sipApplicationKeyAnnotations = index.getAnnotations(sipApplicationKey)) != null && sipApplicationKeyAnnotations.size() > 0) {
            if (sipMetaData == null) {
                sipMetaData = new Sip11MetaData();
            }
            for (AnnotationInstance annotation : sipApplicationKeyAnnotations) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("processAnnotations(): @SipApplicationKey: " + annotation));
                }
                if (!((target = annotation.target()) instanceof MethodInfo)) {
                    throw new DeploymentUnitProcessingException("@SipApplicationKey is only allowed at method level " + target);
                }
                MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
                if (!Modifier.isStatic(methodInfo.flags()) || !Modifier.isPublic(methodInfo.flags())) {
                    throw new DeploymentUnitProcessingException("A method annotated with the @SipApplicationKey annotation MUST be public and static");
                }
                if (!methodInfo.returnType().name().toString().equals(String.class.getName())) {
                    throw new DeploymentUnitProcessingException("A method annotated with the @SipApplicationKey annotation MUST return a String");
                }
                Type[] types = methodInfo.args();
                if (types.length != 1 || !types[0].name().toString().equals(SipServletRequest.class.getName())) {
                    throw new DeploymentUnitProcessingException("A method annotated with the @SipApplicationKey annotation MUST have a single argument of type SipServletRequest");
                }
                if (sipMetaData.getSipApplicationKeyMethodInfo() != null && !sipMetaData.getSipApplicationKeyMethodInfo().equals(methodInfo)) {
                    throw new DeploymentUnitProcessingException("More than one SipApplicationKey annotated method is not allowed.");
                }
                SipApplicationKeyMethodInfo sipApplicationKeyMethodInfo = new SipApplicationKeyMethodInfo(methodInfo.declaringClass().name().toString(), methodInfo.name());
                sipMetaData.setSipApplicationKeyMethodInfo(sipApplicationKeyMethodInfo);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("processAnnotations(): added " + sipApplicationKeyMethodInfo + " as @SipApplicationKey method"));
            }
        }
        if ((concurrencyControlAnnotations = index.getAnnotations(concurrencyControl)) != null && concurrencyControlAnnotations.size() > 0) {
            if (sipMetaData == null) {
                sipMetaData = new Sip11MetaData();
            }
            for (AnnotationInstance annotation : concurrencyControlAnnotations) {
                AnnotationTarget target3;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("processAnnotations(): @ConcurrencyControl: " + annotation));
                }
                if (!((target3 = annotation.target()) instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException("@ConcurrencyControl is only allowed at package level " + target3);
                }
                ConcurrencyControlMode mode = ConcurrencyControlMode.valueOf((String)annotation.value("mode").asString());
                sipMetaData.setConcurrencyControlMode(mode);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("processAnnotations(): ConcurrencyControl set to " + mode));
            }
        }
        return sipMetaData;
    }

    protected Descriptions getDescription(String description) {
        DescriptionsImpl descriptions = null;
        if (description.length() > 0) {
            DescriptionImpl di = new DescriptionImpl();
            di.setDescription(description);
            descriptions = new DescriptionsImpl();
            descriptions.add((MappableMetaData)di);
        }
        return descriptions;
    }

    protected DisplayNames getDisplayName(String displayName) {
        DisplayNamesImpl displayNames = null;
        if (displayName.length() > 0) {
            DisplayNameImpl dn = new DisplayNameImpl();
            dn.setDisplayName(displayName);
            displayNames = new DisplayNamesImpl();
            displayNames.add((MappableMetaData)dn);
        }
        return displayNames;
    }

    protected Icons getIcons(String smallIcon, String largeIcon) {
        IconsImpl icons = null;
        if (smallIcon.length() > 0 || largeIcon.length() > 0) {
            IconImpl i = new IconImpl();
            i.setSmallIcon(smallIcon);
            i.setLargeIcon(largeIcon);
            icons = new IconsImpl();
            icons.add((MappableMetaData)i);
        }
        return icons;
    }

    protected DescriptionGroupMetaData getDescriptionGroup(String description) {
        DescriptionGroupMetaData dg = null;
        if (description.length() > 0) {
            dg = new DescriptionGroupMetaData();
            Descriptions descriptions = this.getDescription(description);
            dg.setDescriptions(descriptions);
        }
        return dg;
    }

    protected DescriptionGroupMetaData getDescriptionGroup(String description, String displayName, String smallIcon, String largeIcon) {
        DescriptionGroupMetaData dg = null;
        if (description.length() > 0 || displayName.length() > 0 || smallIcon.length() > 0 || largeIcon.length() > 0) {
            Icons icons;
            DisplayNames displayNames;
            dg = new DescriptionGroupMetaData();
            Descriptions descriptions = this.getDescription(description);
            if (descriptions != null) {
                dg.setDescriptions(descriptions);
            }
            if ((displayNames = this.getDisplayName(displayName)) != null) {
                dg.setDisplayNames(displayNames);
            }
            if ((icons = this.getIcons(smallIcon, largeIcon)) != null) {
                dg.setIcons(icons);
            }
        }
        return dg;
    }

    private static SipApplication getApplicationAnnotation(Package pack) {
        if (pack == null) {
            return null;
        }
        SipApplication sipApp = pack.getAnnotation(SipApplication.class);
        if (sipApp != null) {
            return sipApp;
        }
        return null;
    }

    private void parseSipApplication(SipMetaData sipMetaData, AnnotationInstance sipAppAnnInstance, String packageName) throws DeploymentUnitProcessingException {
        Object description = null;
        Object displayName = null;
        String largeIcon = null;
        String smallIcon = null;
        for (AnnotationValue value : sipAppAnnInstance.values()) {
            if (value.name().compareTo("name") == 0) {
                if (sipMetaData.getApplicationName() == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("parseSipApplication(): @SipApplication: " + value.asString()));
                    }
                    sipMetaData.setApplicationName(value.asString());
                    continue;
                }
                if (sipMetaData.getApplicationName() == null || sipMetaData.getApplicationName().compareTo(value.asString()) == 0) continue;
                throw new DeploymentUnitProcessingException("Sip Application Name mismatch! Already defined: " + sipMetaData.getApplicationName() + " - from @SipAnnotation (package " + packageName + "): " + value.asString());
            }
            if (value.name().compareTo("description") == 0) {
                DescriptionImpl di = new DescriptionImpl();
                di.setDescription(value.asString());
                SipAnnotationDeploymentProcessor.getOrCreateDs(SipAnnotationDeploymentProcessor.getOrCreateDG(sipMetaData)).add((MappableMetaData)di);
                continue;
            }
            if (value.name().compareTo("displayName") == 0) {
                DisplayNameImpl dn = new DisplayNameImpl();
                dn.setDisplayName(value.asString());
                SipAnnotationDeploymentProcessor.getOrCreateDn(SipAnnotationDeploymentProcessor.getOrCreateDG(sipMetaData)).add((MappableMetaData)dn);
                continue;
            }
            if (value.name().compareTo("distributable") == 0) {
                throw new DeploymentUnitProcessingException("Distributable not supported yet");
            }
            if (value.name().compareTo("largeIcon") == 0) {
                largeIcon = value.asString();
                continue;
            }
            if (value.name().compareTo("smallIcon") == 0) {
                smallIcon = value.asString();
                continue;
            }
            if (value.name().compareTo("mainServlet") == 0) {
                if (sipMetaData.getServletSelection() == null) {
                    sipMetaData.setServletSelection(new SipServletSelectionMetaData());
                }
                sipMetaData.getServletSelection().setMainServlet(value.asString());
                continue;
            }
            if (value.name().compareTo("proxyTimeout") == 0) {
                if (sipMetaData.getProxyConfig() == null) {
                    sipMetaData.setProxyConfig(new ProxyConfigMetaData());
                }
                sipMetaData.getProxyConfig().setProxyTimeout(value.asInt());
                continue;
            }
            if (value.name().compareTo("sessionTimeout") != 0) continue;
            if (sipMetaData.getSessionConfig() == null) {
                sipMetaData.setSessionConfig(new SessionConfigMetaData());
            }
            sipMetaData.getSessionConfig().setSessionTimeout(value.asInt());
        }
        if (smallIcon != null || largeIcon != null) {
            IconImpl icon = new IconImpl();
            if (smallIcon != null) {
                icon.setSmallIcon(smallIcon);
            }
            if (largeIcon != null) {
                icon.setLargeIcon(largeIcon);
            }
            SipAnnotationDeploymentProcessor.getOrCreateIs(SipAnnotationDeploymentProcessor.getOrCreateDG(sipMetaData)).add((MappableMetaData)icon);
        }
        if (sipMetaData.getApplicationName() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parseSipApplication(): @SipApplication: " + packageName));
            }
            sipMetaData.setApplicationName(packageName);
        }
    }

    private static DescriptionGroupMetaData getOrCreateDG(SipMetaData sipMetaData) {
        DescriptionGroupMetaData dg = sipMetaData.getDescriptionGroup();
        if (dg == null) {
            dg = new DescriptionGroupMetaData();
            sipMetaData.setDescriptionGroup(dg);
        }
        return dg;
    }

    private static DescriptionsImpl getOrCreateDs(DescriptionGroupMetaData dg) {
        DescriptionsImpl ds = (DescriptionsImpl)dg.getDescriptions();
        if (ds == null) {
            ds = new DescriptionsImpl();
            dg.setDescriptions((Descriptions)ds);
        }
        return ds;
    }

    private static DisplayNamesImpl getOrCreateDn(DescriptionGroupMetaData dg) {
        DisplayNamesImpl dn = (DisplayNamesImpl)dg.getDisplayNames();
        if (dn == null) {
            dn = new DisplayNamesImpl();
            dg.setDisplayNames((DisplayNames)dn);
        }
        return dn;
    }

    private static IconsImpl getOrCreateIs(DescriptionGroupMetaData dg) {
        IconsImpl ii = (IconsImpl)dg.getIcons();
        if (ii == null) {
            ii = new IconsImpl();
            dg.setIcons((Icons)ii);
        }
        return ii;
    }

    protected boolean canHandle(DeploymentUnit deploymentUnit) {
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile sipXml = deploymentRoot.getRoot().getChild(SIP_XML);
        return DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit) && sipXml.exists();
    }

    public void undeploy(DeploymentUnit context) {
    }
}

