/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.as7.deployment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.merge.web.jboss.JBossWebMetaDataMerger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.mobicents.as7.SipServer;
import org.mobicents.metadata.sip.jboss.JBossConvergedSipMetaData;
import org.mobicents.metadata.sip.merge.JBossSipMetaDataMerger;
import org.mobicents.metadata.sip.spec.ProxyConfigMetaData;
import org.mobicents.metadata.sip.spec.Sip11MetaData;
import org.mobicents.metadata.sip.spec.SipAnnotationMetaData;
import org.mobicents.metadata.sip.spec.SipMetaData;
import org.mobicents.metadata.sip.spec.SipServletSelectionMetaData;
import org.mobicents.metadata.sip.spec.SipServletsMetaData;
import org.mobicents.servlet.sip.core.SipService;
import org.mobicents.servlet.sip.startup.SipStandardContext;
import org.mobicents.servlet.sip.startup.jboss.SipJBossContextConfig;

public class SIPWebContext
extends SipStandardContext {
    static AttachmentKey<SIPWebContext> ATTACHMENT = AttachmentKey.create(SIPWebContext.class);
    private static final Logger logger = Logger.getLogger(SIPWebContext.class);
    private final DeploymentUnit deploymentUnit;
    private SipJBossContextConfig sipJBossContextConfig;

    public SIPWebContext(DeploymentUnit du) {
        this.deploymentUnit = du;
        this.sipJBossContextConfig = this.createContextConfig(this, this.deploymentUnit);
        DeploymentUnit anchorDu = SIPWebContext.getSipContextAnchorDu(du);
        if (anchorDu != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attaching SIPWebContext " + (Object)((Object)this) + " to " + anchorDu.getName()));
            }
            anchorDu.putAttachment(ATTACHMENT, (Object)this);
        } else {
            logger.error((Object)("Can't attach SIPWebContext " + (Object)((Object)this) + " to " + this.deploymentUnit.getName() + " - This is probably a bug"));
        }
    }

    public void postProcessContext(DeploymentUnit deploymentUnit) {
    }

    public void init() throws Exception {
        SipServer sipServer = (SipServer)this.deploymentUnit.getAttachment(SipServer.ATTACHMENT_KEY);
        if (sipServer.getService() instanceof SipService) {
            this.sipApplicationDispatcher = ((SipService)sipServer.getService()).getSipApplicationDispatcher();
        }
        super.init();
    }

    public void start() throws LifecycleException {
        if (logger.isDebugEnabled()) {
            logger.debugf("Starting sip web context for deployment %s", (Object)this.deploymentUnit.getName());
        }
        SipMetaData sipMetaData = (SipMetaData)((Object)this.deploymentUnit.getAttachment(SipMetaData.ATTACHMENT_KEY));
        SipAnnotationMetaData sipAnnotationMetaData = (SipAnnotationMetaData)this.deploymentUnit.getAttachment(SipAnnotationMetaData.ATTACHMENT_KEY);
        JBossConvergedSipMetaData mergedMetaData = null;
        mergedMetaData = new JBossConvergedSipMetaData();
        WarMetaData warMetaData = (WarMetaData)this.deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaData override = warMetaData.getJBossWebMetaData();
        WebMetaData original = null;
        JBossWebMetaDataMerger.merge((JBossWebMetaData)mergedMetaData, (JBossWebMetaData)override, original);
        if (logger.isDebugEnabled()) {
            logger.debugf("security domain " + mergedMetaData.getSecurityDomain() + " for deployment %s", (Object)this.deploymentUnit.getName());
        }
        if (sipMetaData == null && sipAnnotationMetaData != null && sipAnnotationMetaData.isSipApplicationAnnotationPresent()) {
            logger.debugf("sip meta data is null, creating a new one", new Object[0]);
            sipMetaData = new Sip11MetaData();
        }
        this.augmentAnnotations(mergedMetaData, sipMetaData, sipAnnotationMetaData);
        try {
            this.processMetaData(mergedMetaData, sipMetaData);
        }
        catch (Exception e) {
            throw new LifecycleException("An unexpected exception happened while parsing sip meta data from " + this.deploymentUnit.getName(), (Throwable)e);
        }
        super.start();
    }

    private void augmentAnnotations(JBossWebMetaData mergedMetaData, SipMetaData sipMetaData, SipAnnotationMetaData sipAnnotationMetaData) throws LifecycleException {
        Iterator i$;
        ListenerMetaData check2;
        Iterator i$2;
        SipMetaData annotatedSipMetaData;
        String annotatedSipMetaDataKey;
        Set annotationsEntrySet = sipAnnotationMetaData.entrySet();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sipAnnotationMetaData " + sipAnnotationMetaData));
            if (sipAnnotationMetaData != null) {
                for (Map.Entry annotationEntry : annotationsEntrySet) {
                    annotatedSipMetaDataKey = (String)annotationEntry.getKey();
                    annotatedSipMetaData = (SipMetaData)((Object)annotationEntry.getValue());
                    logger.debug((Object)("sipAnnotationMetaDataKey " + annotatedSipMetaDataKey + " value " + (Object)((Object)annotatedSipMetaData)));
                    if (annotatedSipMetaData.getListeners() != null) {
                        for (ListenerMetaData listenerMetaData : annotatedSipMetaData.getListeners()) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("@SipListener: " + listenerMetaData.getListenerClass() + " in " + annotatedSipMetaDataKey));
                        }
                    }
                    if (annotatedSipMetaData.getSipServlets() == null) continue;
                    i$2 = annotatedSipMetaData.getSipServlets().iterator();
                    while (i$2.hasNext()) {
                        ServletMetaData sipServletMetaData = (ServletMetaData)i$2.next();
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("@SipServlet: " + sipServletMetaData.getServletClass() + " in " + annotatedSipMetaDataKey));
                    }
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<Before clumsy augmentation>");
            if (sipMetaData.getListeners() != null) {
                logger.debug((Object)("Listeners: " + sipMetaData.getListeners().size()));
                for (ListenerMetaData check2 : sipMetaData.getListeners()) {
                    logger.debug((Object)("Listener: " + check2.getListenerClass()));
                }
            }
            if (sipMetaData.getSipServlets() != null) {
                logger.debug((Object)("SipServlets: " + sipMetaData.getSipServlets().size()));
                i$ = sipMetaData.getSipServlets().iterator();
                while (i$.hasNext()) {
                    check2 = (ServletMetaData)i$.next();
                    logger.debug((Object)("SipServlet: " + check2.getName() + " - class: " + check2.getServletClass() + " - load-on-startup: " + check2.getLoadOnStartup()));
                }
            }
            logger.debug((Object)"</Before clumsy augmentation>");
        }
        if (sipAnnotationMetaData != null) {
            for (Map.Entry annotationEntry : annotationsEntrySet) {
                boolean found;
                annotatedSipMetaDataKey = (String)annotationEntry.getKey();
                annotatedSipMetaData = (SipMetaData)((Object)annotationEntry.getValue());
                if (annotatedSipMetaData.getServletSelection() != null && annotatedSipMetaData.getServletSelection().getMainServlet() != null && sipMetaData.getServletSelection() == null) {
                    sipMetaData.setServletSelection(new SipServletSelectionMetaData());
                    sipMetaData.getServletSelection().setMainServlet(annotatedSipMetaData.getServletSelection().getMainServlet());
                }
                if (annotatedSipMetaData.getProxyConfig() != null && annotatedSipMetaData.getProxyConfig().getProxyTimeout() != 0 && sipMetaData.getProxyConfig() == null) {
                    sipMetaData.setProxyConfig(new ProxyConfigMetaData());
                    sipMetaData.getProxyConfig().setProxyTimeout(annotatedSipMetaData.getProxyConfig().getProxyTimeout());
                }
                if (annotatedSipMetaData.getSessionConfig() != null && annotatedSipMetaData.getSessionConfig().getSessionTimeout() != 0 && sipMetaData.getSessionConfig() == null) {
                    sipMetaData.setSessionConfig(new SessionConfigMetaData());
                    sipMetaData.getSessionConfig().setSessionTimeout(annotatedSipMetaData.getSessionConfig().getSessionTimeout());
                }
                if (annotatedSipMetaData.getApplicationName() != null) {
                    if (sipMetaData.getApplicationName() == null) {
                        sipMetaData.setApplicationName(annotatedSipMetaData.getApplicationName());
                    } else if (sipMetaData.getApplicationName().compareTo(annotatedSipMetaData.getApplicationName()) != 0) {
                        throw new LifecycleException("Sip application name mismatch: " + sipMetaData.getApplicationName() + " (from sip.xml) vs " + annotatedSipMetaData.getApplicationName() + " from annotations " + annotatedSipMetaDataKey);
                    }
                }
                if (annotatedSipMetaData.getDescriptionGroup() != null && sipMetaData.getDescriptionGroup() == null) {
                    sipMetaData.setDescriptionGroup(annotatedSipMetaData.getDescriptionGroup());
                }
                if (annotatedSipMetaData.getListeners() != null) {
                    if (sipMetaData.getListeners() == null) {
                        sipMetaData.setListeners(new ArrayList());
                    }
                    for (ListenerMetaData listenerMetaData : annotatedSipMetaData.getListeners()) {
                        found = false;
                        for (ListenerMetaData check3 : sipMetaData.getListeners()) {
                            if (!check3.getListenerClass().equals(listenerMetaData.getListenerClass())) continue;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("@SipListener already present: " + listenerMetaData.getListenerClass() + " from " + annotatedSipMetaDataKey));
                            }
                            found = true;
                        }
                        if (found) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Added @SipListener: " + listenerMetaData.getListenerClass() + " from " + annotatedSipMetaDataKey));
                        }
                        sipMetaData.getListeners().add(listenerMetaData);
                    }
                }
                if (annotatedSipMetaData.getSipServlets() != null) {
                    if (sipMetaData.getSipServlets() == null) {
                        sipMetaData.setSipServlets(new SipServletsMetaData());
                    }
                    i$2 = annotatedSipMetaData.getSipServlets().iterator();
                    while (i$2.hasNext()) {
                        ServletMetaData servletMetaData = (ServletMetaData)i$2.next();
                        found = false;
                        Iterator i$3 = sipMetaData.getSipServlets().iterator();
                        while (i$3.hasNext()) {
                            ListenerMetaData check3;
                            check3 = (ServletMetaData)i$3.next();
                            if (!check3.getServletClass().equals(servletMetaData.getServletClass())) continue;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("@SipServlet already present: " + servletMetaData.getServletClass() + " from " + annotatedSipMetaDataKey));
                            }
                            found = true;
                        }
                        if (found) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Added @SipServlet: " + servletMetaData.getServletClass() + " from " + annotatedSipMetaDataKey));
                        }
                        sipMetaData.getSipServlets().add((MappableMetaData)servletMetaData);
                    }
                }
                if (annotatedSipMetaData.getSipApplicationKeyMethodInfo() != null) {
                    sipMetaData.setSipApplicationKeyMethodInfo(annotatedSipMetaData.getSipApplicationKeyMethodInfo());
                }
                if (annotatedSipMetaData.getConcurrencyControlMode() == null || sipMetaData.getConcurrencyControlMode() != null) continue;
                sipMetaData.setConcurrencyControlMode(annotatedSipMetaData.getConcurrencyControlMode());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<After clumsy augmentation>");
            if (sipMetaData.getListeners() != null) {
                logger.debug((Object)("Listeners: " + sipMetaData.getListeners().size()));
                for (ListenerMetaData check2 : sipMetaData.getListeners()) {
                    logger.debug((Object)("Listener: " + check2.getListenerClass()));
                }
            }
            if (sipMetaData.getSipServlets() != null) {
                logger.debug((Object)("SipServlets: " + sipMetaData.getSipServlets().size()));
                i$ = sipMetaData.getSipServlets().iterator();
                while (i$.hasNext()) {
                    check2 = (ServletMetaData)i$.next();
                    logger.debug((Object)("SipServlet: " + check2.getName() + " - class: " + check2.getServletClass() + " - load-on-startup: " + check2.getLoadOnStartup()));
                }
            }
            logger.debug((Object)"</After clumsy augmentation>");
        }
        JBossSipMetaDataMerger.merge((JBossConvergedSipMetaData)mergedMetaData, null, sipMetaData);
    }

    private void processMetaData(JBossWebMetaData mergedMetaData, SipMetaData sipMetaData) throws Exception {
        JBossSipMetaDataMerger.merge((JBossConvergedSipMetaData)mergedMetaData, null, sipMetaData);
        this.sipJBossContextConfig.processSipMetaData((JBossConvergedSipMetaData)mergedMetaData);
    }

    private SipJBossContextConfig createContextConfig(SipStandardContext sipContext, DeploymentUnit deploymentUnit) {
        SipJBossContextConfig config = new SipJBossContextConfig(deploymentUnit);
        sipContext.addLifecycleListener((LifecycleListener)config);
        return config;
    }

    public static DeploymentUnit getSipContextAnchorDu(DeploymentUnit du) {
        DeploymentUnit parentDu = du.getParent();
        if (parentDu == null) {
            return du;
        }
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)parentDu)) {
            return parentDu;
        }
        logger.error((Object)("Can't find proper anchor deployment unit for " + du.getName() + " - This is probably a bug"));
        return null;
    }
}

