/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.as7;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.mobicents.as7.Attribute;
import org.mobicents.as7.Element;
import org.mobicents.as7.Namespace;
import org.mobicents.as7.SipConnectorDefinition;
import org.mobicents.as7.SipDefinition;

class SipSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final SipSubsystemParser INSTANCE = new SipSubsystemParser();

    SipSubsystemParser() {
    }

    static SipSubsystemParser getInstance() {
        return INSTANCE;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        SipDefinition.INSTANCE_ID.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.APPLICATION_ROUTER.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.SIP_STACK_PROPS.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.SIP_PATH_NAME.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.SIP_APP_DISPATCHER_CLASS.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.CONCURRENCY_CONTROL_MODE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.CONGESTION_CONTROL_INTERVAL.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.CONGESTION_CONTROL_POLICY.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.USE_PRETTY_ENCODING.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.ADDITIONAL_PARAMETERABLE_HEADERS.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.BASE_TIMER_INTERVAL.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.T2_INTERVAL.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.T4_INTERVAL.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.TIMER_D_INTERVAL.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.DIALOG_PENDING_REQUEST_CHECKING.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.DNS_SERVER_LOCATOR_CLASS.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.DNS_TIMEOUT.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.DNS_RESOLVER_CLASS.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.CANCELED_TIMER_TASKS_PURGE_PERIOD.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.MEMORY_THRESHOLD.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.BACK_TO_NORMAL_MEMORY_THRESHOLD.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SipDefinition.OUTBOUND_PROXY.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        if (node.hasDefined("connector")) {
            for (Property connector : node.get("connector").asPropertyList()) {
                ModelNode config = connector.getValue();
                writer.writeStartElement(Element.CONNECTOR.getLocalName());
                writer.writeAttribute("name", connector.getName());
                for (SimpleAttributeDefinition attr : SipConnectorDefinition.CONNECTOR_ATTRIBUTES) {
                    attr.marshallAsAttribute(config, false, (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"sip")});
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address.toModelNode());
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INSTANCE_ID: 
                case APPLICATION_ROUTER: 
                case SIP_STACK_PROPS: 
                case SIP_APP_DISPATCHER_CLASS: 
                case SIP_PATH_NAME: 
                case ADDITIONAL_PARAMETERABLE_HEADERS: 
                case BASE_TIMER_INTERVAL: 
                case T2_INTERVAL: 
                case T4_INTERVAL: 
                case TIMER_D_INTERVAL: 
                case DIALOG_PENDING_REQUEST_CHECKING: 
                case DNS_SERVER_LOCATOR_CLASS: 
                case DNS_TIMEOUT: 
                case DNS_RESOLVER_CLASS: 
                case CANCELED_TIMER_TASKS_PURGE_PERIOD: 
                case CONGESTION_CONTROL_INTERVAL: 
                case CONGESTION_CONTROL_POLICY: 
                case MEMORY_THRESHOLD: 
                case BACK_TO_NORMAL_MEMORY_THRESHOLD: 
                case OUTBOUND_PROXY: 
                case CONCURRENCY_CONTROL_MODE: 
                case USE_PRETTY_ENCODING: {
                    subsystem.get(attribute.getLocalName()).set(value);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        list.add(subsystem);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SIP_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONNECTOR: {
                            SipSubsystemParser.parseConnector(reader, address, list);
                            continue block10;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseConnector(XMLExtendedStreamReader reader, PathAddress parent, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        String bindingRef = null;
        ModelNode connector = new ModelNode();
        int count = reader.getAttributeCount();
        block19: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block19;
                }
                case SOCKET_BINDING: {
                    bindingRef = value;
                    SipConnectorDefinition.SOCKET_BINDING.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block19;
                }
                case SCHEME: {
                    SipConnectorDefinition.SCHEME.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block19;
                }
                case PROTOCOL: {
                    SipConnectorDefinition.PROTOCOL.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block19;
                }
                case ENABLED: {
                    SipConnectorDefinition.ENABLED.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block19;
                }
                case USE_STATIC_ADDRESS: {
                    SipConnectorDefinition.USE_STATIC_ADDRESS.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block19;
                }
                case STATIC_SERVER_ADDRESS: {
                    SipConnectorDefinition.STATIC_SERVER_ADDRESS.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block19;
                }
                case STATIC_SERVER_PORT: {
                    SipConnectorDefinition.STATIC_SERVER_PORT.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block19;
                }
                case USE_STUN: {
                    SipConnectorDefinition.USE_STUN.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block19;
                }
                case STUN_SERVER_ADDRESS: {
                    SipConnectorDefinition.STUN_SERVER_ADDRESS.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block19;
                }
                case STUN_SERVER_PORT: {
                    SipConnectorDefinition.STUN_SERVER_PORT.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block19;
                }
                case HOSTNAMES: {
                    SipConnectorDefinition.HOSTNAMES.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block19;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        if (bindingRef == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SOCKET_BINDING));
        }
        connector.get("operation").set("add");
        PathAddress address = PathAddress.pathAddress((PathAddress)parent, (PathElement[])new PathElement[]{PathElement.pathElement((String)"connector", name)});
        connector.get("address").set(address.toModelNode());
        list.add(connector);
        if (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SIP_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        default: 
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

