/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.as7;

import java.util.List;
import javax.management.MBeanServer;
import org.jboss.as.clustering.web.DistributedCacheManagerFactory;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.mobicents.as7.JvmRouteRegistryEntryProviderService;
import org.mobicents.as7.SipDefinition;
import org.mobicents.as7.SipServer;
import org.mobicents.as7.SipServerService;
import org.mobicents.as7.SipSubsystemServices;
import org.mobicents.as7.clustering.sip.MockDistributedCacheManagerFactoryService;
import org.mobicents.as7.deployment.AttachSipServerServiceProcessor;
import org.mobicents.as7.deployment.SipAnnotationDeploymentProcessor;
import org.mobicents.as7.deployment.SipComponentProcessor;
import org.mobicents.as7.deployment.SipContextFactoryDeploymentProcessor;
import org.mobicents.as7.deployment.SipJndiBindingProcessor;
import org.mobicents.as7.deployment.SipParsingDeploymentProcessor;
import org.mobicents.as7.deployment.SipWarDeploymentProcessor;
import org.mobicents.ext.javax.sip.dns.DefaultDNSServerLocator;

class SipSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static int PARSE_SIP_DEPLOYMENT_PRIORITY = 16384;
    static int SIP_ANNOTATION_DEPLOYMENT_PRIORITY = 20480;
    static int SIP_CONTEXT_FACTORY_DEPLOYMENT_PRIORITY = 24576;
    static final SipSubsystemAdd INSTANCE = new SipSubsystemAdd();

    private SipSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        SipDefinition.INSTANCE_ID.validateAndSet(operation, model);
        SipDefinition.APPLICATION_ROUTER.validateAndSet(operation, model);
        SipDefinition.SIP_STACK_PROPS.validateAndSet(operation, model);
        SipDefinition.SIP_PATH_NAME.validateAndSet(operation, model);
        SipDefinition.SIP_APP_DISPATCHER_CLASS.validateAndSet(operation, model);
        SipDefinition.CONGESTION_CONTROL_INTERVAL.validateAndSet(operation, model);
        SipDefinition.CONGESTION_CONTROL_POLICY.validateAndSet(operation, model);
        SipDefinition.CONCURRENCY_CONTROL_MODE.validateAndSet(operation, model);
        SipDefinition.USE_PRETTY_ENCODING.validateAndSet(operation, model);
        SipDefinition.ADDITIONAL_PARAMETERABLE_HEADERS.validateAndSet(operation, model);
        SipDefinition.BASE_TIMER_INTERVAL.validateAndSet(operation, model);
        SipDefinition.T2_INTERVAL.validateAndSet(operation, model);
        SipDefinition.T4_INTERVAL.validateAndSet(operation, model);
        SipDefinition.TIMER_D_INTERVAL.validateAndSet(operation, model);
        SipDefinition.DIALOG_PENDING_REQUEST_CHECKING.validateAndSet(operation, model);
        SipDefinition.DNS_SERVER_LOCATOR_CLASS.validateAndSet(operation, model);
        SipDefinition.DNS_TIMEOUT.validateAndSet(operation, model);
        SipDefinition.DNS_RESOLVER_CLASS.validateAndSet(operation, model);
        SipDefinition.CANCELED_TIMER_TASKS_PURGE_PERIOD.validateAndSet(operation, model);
        SipDefinition.MEMORY_THRESHOLD.validateAndSet(operation, model);
        SipDefinition.BACK_TO_NORMAL_MEMORY_THRESHOLD.validateAndSet(operation, model);
        SipDefinition.OUTBOUND_PROXY.validateAndSet(operation, model);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        ModelNode instanceIdModel = SipDefinition.INSTANCE_ID.resolveModelAttribute(context, fullModel);
        String instanceId = instanceIdModel.isDefined() ? instanceIdModel.asString() : null;
        ModelNode sipAppRouterFileModel = SipDefinition.APPLICATION_ROUTER.resolveModelAttribute(context, fullModel);
        String sipAppRouterFile = sipAppRouterFileModel.isDefined() ? sipAppRouterFileModel.asString() : null;
        ModelNode sipStackPropertiesFileModel = SipDefinition.SIP_STACK_PROPS.resolveModelAttribute(context, fullModel);
        String sipStackPropertiesFile = sipStackPropertiesFileModel.isDefined() ? sipStackPropertiesFileModel.asString() : null;
        ModelNode sipPathNameModel = SipDefinition.SIP_PATH_NAME.resolveModelAttribute(context, fullModel);
        String sipPathName = sipPathNameModel.isDefined() ? sipPathNameModel.asString() : null;
        ModelNode sipAppDispatcherClassModel = SipDefinition.SIP_APP_DISPATCHER_CLASS.resolveModelAttribute(context, fullModel);
        String sipAppDispatcherClass = sipAppDispatcherClassModel.isDefined() ? sipAppDispatcherClassModel.asString() : null;
        ModelNode usePrettyEncodingModel = SipDefinition.CANCELED_TIMER_TASKS_PURGE_PERIOD.resolveModelAttribute(context, fullModel);
        boolean usePrettyEncoding = usePrettyEncodingModel.isDefined() ? usePrettyEncodingModel.asBoolean() : true;
        ModelNode additionalParameterableHeadersModel = SipDefinition.ADDITIONAL_PARAMETERABLE_HEADERS.resolveModelAttribute(context, fullModel);
        String additionalParameterableHeaders = additionalParameterableHeadersModel.isDefined() ? additionalParameterableHeadersModel.asString() : null;
        ModelNode sipCongestionControlIntervalModel = SipDefinition.CONGESTION_CONTROL_INTERVAL.resolveModelAttribute(context, fullModel);
        int sipCongestionControlInterval = sipCongestionControlIntervalModel.isDefined() ? sipCongestionControlIntervalModel.asInt() : -1;
        ModelNode congestionControlPolicyModel = SipDefinition.CONGESTION_CONTROL_POLICY.resolveModelAttribute(context, fullModel);
        String congestionControlPolicy = congestionControlPolicyModel.isDefined() ? congestionControlPolicyModel.asString() : "ErrorResponse";
        ModelNode sipConcurrencyControlModeModel = SipDefinition.CONCURRENCY_CONTROL_MODE.resolveModelAttribute(context, fullModel);
        String sipConcurrencyControlMode = sipConcurrencyControlModeModel.isDefined() ? sipConcurrencyControlModeModel.asString() : null;
        ModelNode baseTimerIntervalModel = SipDefinition.BASE_TIMER_INTERVAL.resolveModelAttribute(context, fullModel);
        int baseTimerInterval = baseTimerIntervalModel.isDefined() ? baseTimerIntervalModel.asInt() : 500;
        ModelNode t2IntervalModel = SipDefinition.T2_INTERVAL.resolveModelAttribute(context, fullModel);
        int t2Interval = t2IntervalModel.isDefined() ? t2IntervalModel.asInt() : 4000;
        ModelNode t4IntervalModel = SipDefinition.T4_INTERVAL.resolveModelAttribute(context, fullModel);
        int t4Interval = t4IntervalModel.isDefined() ? t4IntervalModel.asInt() : 5000;
        ModelNode timerDIntervalModel = SipDefinition.TIMER_D_INTERVAL.resolveModelAttribute(context, fullModel);
        int timerDInterval = timerDIntervalModel.isDefined() ? timerDIntervalModel.asInt() : 32000;
        ModelNode dialogPendingRequestCheckingModel = SipDefinition.DIALOG_PENDING_REQUEST_CHECKING.resolveModelAttribute(context, fullModel);
        boolean dialogPendingRequestChecking = dialogPendingRequestCheckingModel.isDefined() ? dialogPendingRequestCheckingModel.asBoolean() : false;
        ModelNode dnsServerLocatorClassModel = SipDefinition.DNS_SERVER_LOCATOR_CLASS.resolveModelAttribute(context, fullModel);
        String dnsServerLocatorClass = dnsServerLocatorClassModel.isDefined() ? dnsServerLocatorClassModel.asString() : DefaultDNSServerLocator.class.getName();
        ModelNode dnsTimeoutModel = SipDefinition.DNS_TIMEOUT.resolveModelAttribute(context, fullModel);
        int dnsTimeout = dnsTimeoutModel.isDefined() ? Integer.valueOf(dnsTimeoutModel.asInt()) : null;
        ModelNode dnsResolverClassModel = SipDefinition.DNS_RESOLVER_CLASS.resolveModelAttribute(context, fullModel);
        String dnsResolverClass = dnsResolverClassModel.isDefined() ? dnsResolverClassModel.asString() : null;
        ModelNode callIdMaxLengthModel = SipDefinition.CALL_ID_MAX_LENGTH.resolveModelAttribute(context, fullModel);
        int callIdMaxLength = callIdMaxLengthModel.isDefined() ? callIdMaxLengthModel.asInt() : -1;
        ModelNode tagHashMaxLengthModel = SipDefinition.TAG_HASH_MAX_LENGTH.resolveModelAttribute(context, fullModel);
        int tagHashMaxLength = callIdMaxLengthModel.isDefined() ? tagHashMaxLengthModel.asInt() : -1;
        ModelNode canceledTimerTasksPurgePeriodModel = SipDefinition.CANCELED_TIMER_TASKS_PURGE_PERIOD.resolveModelAttribute(context, fullModel);
        int canceledTimerTasksPurgePeriod = canceledTimerTasksPurgePeriodModel.isDefined() ? canceledTimerTasksPurgePeriodModel.asInt() : -1;
        ModelNode memoryThresholdModel = SipDefinition.MEMORY_THRESHOLD.resolveModelAttribute(context, fullModel);
        int memoryThreshold = memoryThresholdModel.isDefined() ? memoryThresholdModel.asInt() : -1;
        ModelNode backToNormalMemoryThresholdModel = SipDefinition.BACK_TO_NORMAL_MEMORY_THRESHOLD.resolveModelAttribute(context, fullModel);
        int backToNormalMemoryThreshold = backToNormalMemoryThresholdModel.isDefined() ? backToNormalMemoryThresholdModel.asInt() : -1;
        ModelNode outboundProxyModel = SipDefinition.OUTBOUND_PROXY.resolveModelAttribute(context, fullModel);
        String outboundProxy = outboundProxyModel.isDefined() ? outboundProxyModel.asString() : null;
        final SipServerService service = new SipServerService(sipAppRouterFile, sipStackPropertiesFile, sipPathName, sipAppDispatcherClass, additionalParameterableHeaders, sipCongestionControlInterval, congestionControlPolicy, sipConcurrencyControlMode, usePrettyEncoding, baseTimerInterval, t2Interval, t4Interval, timerDInterval, dialogPendingRequestChecking, dnsServerLocatorClass, dnsTimeout, dnsResolverClass, callIdMaxLength, tagHashMaxLength, canceledTimerTasksPurgePeriod, memoryThreshold, backToNormalMemoryThreshold, outboundProxy, instanceId);
        newControllers.add(context.getServiceTarget().addService(SipSubsystemServices.JBOSS_SIP, (Service)service).addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.getPathManagerInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, service.getMbeanServer()).setInitialMode(ServiceController.Mode.ACTIVE).install());
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("sip", Phase.PARSE, PARSE_SIP_DEPLOYMENT_PRIORITY, (DeploymentUnitProcessor)new SipParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor("sip", Phase.PARSE, SIP_ANNOTATION_DEPLOYMENT_PRIORITY, (DeploymentUnitProcessor)new SipAnnotationDeploymentProcessor());
                processorTarget.addDeploymentProcessor("sip", Phase.PARSE, SIP_ANNOTATION_DEPLOYMENT_PRIORITY + 1, (DeploymentUnitProcessor)new SipComponentProcessor());
                processorTarget.addDeploymentProcessor("sip", Phase.POST_MODULE, SIP_CONTEXT_FACTORY_DEPLOYMENT_PRIORITY - 1, (DeploymentUnitProcessor)new AttachSipServerServiceProcessor(service));
                processorTarget.addDeploymentProcessor("sip", Phase.POST_MODULE, SIP_CONTEXT_FACTORY_DEPLOYMENT_PRIORITY, SipContextFactoryDeploymentProcessor.INSTANCE);
                processorTarget.addDeploymentProcessor("sip", Phase.POST_MODULE, 255, (DeploymentUnitProcessor)new SipJndiBindingProcessor());
                processorTarget.addDeploymentProcessor("sip", Phase.INSTALL, 7424, (DeploymentUnitProcessor)new SipWarDeploymentProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        ServiceTarget target = context.getServiceTarget();
        DistributedCacheManagerFactory factory = new MockDistributedCacheManagerFactoryService().getValue();
        if (factory != null) {
            InjectedValue server = new InjectedValue();
            newControllers.add(target.addService(MockDistributedCacheManagerFactoryService.JVM_ROUTE_REGISTRY_ENTRY_PROVIDER_SERVICE_NAME, (Service)new JvmRouteRegistryEntryProviderService((Value<SipServer>)server)).addDependency(SipSubsystemServices.JBOSS_SIP, SipServer.class, (Injector)server).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
            newControllers.addAll(factory.installServices(target));
        }
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

