/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.as7;

import javax.management.MBeanServer;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.Server;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardService;
import org.apache.tomcat.util.Constants;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.mobicents.as7.SipMessages;
import org.mobicents.as7.SipServer;
import org.mobicents.servlet.sip.core.SipApplicationDispatcherImpl;
import org.mobicents.servlet.sip.startup.SipProtocolHandler;
import org.mobicents.servlet.sip.startup.SipStandardEngine;
import org.mobicents.servlet.sip.startup.SipStandardService;

class SipServerService
implements SipServer,
Service<SipServer> {
    private static final Logger logger = Logger.getLogger(SipServerService.class);
    private static final String JBOSS_SIP = "jboss.sip";
    private static final String TEMP_DIR = "jboss.server.temp.dir";
    private static final String FILE_PREFIX_PATH = "file:///";
    private String sipAppRouterFile;
    private String sipStackPropertiesFile;
    final String sipPathName;
    final String sipAppDispatcherClass;
    final String additionalParameterableHeaders;
    final int sipCongestionControlInterval;
    final String congestionControlPolicy;
    final String sipConcurrencyControlMode;
    final boolean usePrettyEncoding;
    final int baseTimerInterval;
    final int t2Interval;
    final int t4Interval;
    final int timerDInterval;
    final boolean dialogPendingRequestChecking;
    final String dnsServerLocatorClass;
    final int dnsTimeout;
    final String dnsResolverClass;
    final int callIdMaxLength;
    final int tagHashMaxLength;
    final int canceledTimerTasksPurgePeriod;
    final int memoryThreshold;
    final int backToNormalMemoryThreshold;
    final String outboundProxy;
    private final String instanceId;
    private StandardServer server;
    private SipStandardEngine sipEngine;
    private SipStandardService sipService;
    private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
    private final InjectedValue<PathManager> pathManagerInjector = new InjectedValue();

    public SipServerService(String sipAppRouterFile, String sipStackPropertiesFile, String sipPathName, String sipAppDispatcherClass, String additionalParameterableHeaders, int sipCongestionControlInterval, String congestionControlPolicy, String sipConcurrencyControlMode, boolean usePrettyEncoding, int baseTimerInterval, int t2Interval, int t4Interval, int timerDInterval, boolean dialogPendingRequestChecking, String dnsServerLocatorClass, int dnsTimeout, String dnsResolverClass, int callIdMaxLength, int tagHashMaxLength, int canceledTimerTasksPurgePeriod, int memoryThreshold, int backToNormalMemoryThreshold, String outboundProxy, String instanceId) {
        this.sipAppRouterFile = sipAppRouterFile;
        this.sipStackPropertiesFile = sipStackPropertiesFile;
        this.sipPathName = sipPathName;
        this.sipAppDispatcherClass = sipAppDispatcherClass;
        this.additionalParameterableHeaders = additionalParameterableHeaders;
        this.sipCongestionControlInterval = sipCongestionControlInterval;
        this.congestionControlPolicy = congestionControlPolicy;
        this.sipConcurrencyControlMode = sipConcurrencyControlMode;
        this.instanceId = instanceId;
        this.usePrettyEncoding = usePrettyEncoding;
        this.baseTimerInterval = baseTimerInterval;
        this.t2Interval = t2Interval;
        this.t4Interval = t4Interval;
        this.timerDInterval = timerDInterval;
        this.dialogPendingRequestChecking = dialogPendingRequestChecking;
        this.dnsServerLocatorClass = dnsServerLocatorClass;
        this.dnsTimeout = dnsTimeout;
        this.dnsResolverClass = dnsResolverClass;
        this.callIdMaxLength = callIdMaxLength;
        this.tagHashMaxLength = tagHashMaxLength;
        this.canceledTimerTasksPurgePeriod = canceledTimerTasksPurgePeriod;
        this.memoryThreshold = memoryThreshold;
        this.backToNormalMemoryThreshold = backToNormalMemoryThreshold;
        this.outboundProxy = outboundProxy;
    }

    public synchronized void start(StartContext context) throws StartException {
        MBeanServer mbeanServer;
        if (Constants.ENABLE_MODELER && (mbeanServer = (MBeanServer)this.mbeanServer.getOptionalValue()) != null) {
            Registry.getRegistry(null, null).setMBeanServer(mbeanServer);
        }
        System.setProperty("catalina.home", ((PathManager)this.pathManagerInjector.getValue()).getPathEntry(TEMP_DIR).resolvePath());
        this.server = new StandardServer();
        this.sipService = new SipStandardService();
        this.server.addService((org.apache.catalina.Service)this.sipService);
        if (this.sipAppDispatcherClass != null) {
            this.sipService.setSipApplicationDispatcherClassName(this.sipAppDispatcherClass);
        } else {
            this.sipService.setSipApplicationDispatcherClassName(SipApplicationDispatcherImpl.class.getName());
        }
        String baseDir = System.getProperty("jboss.server.base.dir");
        if (this.sipAppRouterFile != null) {
            if (!this.sipAppRouterFile.startsWith(FILE_PREFIX_PATH)) {
                this.sipAppRouterFile = FILE_PREFIX_PATH.concat(baseDir).concat("/").concat(this.sipAppRouterFile);
            }
            System.setProperty("javax.servlet.sip.dar", this.sipAppRouterFile);
        }
        this.sipService.setSipPathName(this.sipPathName);
        if (this.sipStackPropertiesFile != null && !this.sipStackPropertiesFile.startsWith(FILE_PREFIX_PATH)) {
            this.sipStackPropertiesFile = FILE_PREFIX_PATH.concat(baseDir).concat("/").concat(this.sipStackPropertiesFile);
        }
        this.sipService.setSipStackPropertiesFile(this.sipStackPropertiesFile);
        if (this.sipConcurrencyControlMode != null) {
            this.sipService.setConcurrencyControlMode(this.sipConcurrencyControlMode);
        } else {
            this.sipService.setConcurrencyControlMode("None");
        }
        this.sipService.setCongestionControlCheckingInterval((long)this.sipCongestionControlInterval);
        this.sipService.setUsePrettyEncoding(this.usePrettyEncoding);
        this.sipService.setBaseTimerInterval(this.baseTimerInterval);
        this.sipService.setT2Interval(this.t2Interval);
        this.sipService.setT4Interval(this.t4Interval);
        this.sipService.setTimerDInterval(this.timerDInterval);
        if (this.additionalParameterableHeaders != null) {
            this.sipService.setAdditionalParameterableHeaders(this.additionalParameterableHeaders);
        }
        this.sipService.setDialogPendingRequestChecking(this.dialogPendingRequestChecking);
        this.sipService.setDnsServerLocatorClass(this.dnsServerLocatorClass);
        this.sipService.setDnsTimeout(this.dnsTimeout);
        this.sipService.setDnsResolverClass(this.dnsResolverClass);
        this.sipService.setCanceledTimerTasksPurgePeriod(this.canceledTimerTasksPurgePeriod);
        this.sipService.setMemoryThreshold(this.memoryThreshold);
        this.sipService.setBackToNormalMemoryThreshold(this.backToNormalMemoryThreshold);
        this.sipService.setCongestionControlPolicy(this.congestionControlPolicy);
        this.sipService.setOutboundProxy(this.outboundProxy);
        this.sipService.setName(JBOSS_SIP);
        this.sipService.setServer((Server)this.server);
        this.sipEngine = new SipStandardEngine();
        this.sipEngine.setName(JBOSS_SIP);
        this.sipEngine.setService((org.apache.catalina.Service)this.sipService);
        if (this.instanceId != null) {
            this.sipEngine.setJvmRoute(this.instanceId);
        }
        this.sipService.setContainer((Container)this.sipEngine);
        try {
            this.server.init();
            this.server.start();
        }
        catch (Exception e) {
            throw new StartException(SipMessages.MESSAGES.errorStartingSip(), (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = null;
        this.sipEngine = null;
        this.sipService = null;
    }

    public synchronized SipServer getValue() throws IllegalStateException {
        return this;
    }

    @Override
    public synchronized void addConnector(Connector connector) {
        if (connector.getProtocolHandler() instanceof SipProtocolHandler) {
            SipStandardService sipService = this.sipService;
            sipService.addConnector(connector);
        }
    }

    @Override
    public synchronized void removeConnector(Connector connector) {
        if (connector.getProtocolHandler() instanceof SipProtocolHandler) {
            SipStandardService service = this.sipService;
            service.removeConnector(connector);
        }
    }

    @Override
    public synchronized void addHost(Host host) {
        SipStandardEngine sipEngine = this.sipEngine;
        sipEngine.addChild((Container)host);
    }

    @Override
    public synchronized void removeHost(Host host) {
        SipStandardEngine sipEngine = this.sipEngine;
        sipEngine.removeChild((Container)host);
    }

    InjectedValue<MBeanServer> getMbeanServer() {
        return this.mbeanServer;
    }

    InjectedValue<PathManager> getPathManagerInjector() {
        return this.pathManagerInjector;
    }

    @Override
    public StandardServer getServer() {
        return this.server;
    }

    @Override
    public StandardService getService() {
        return this.sipService;
    }

    public SipStandardService getSipService() {
        return this.sipService;
    }
}

