/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.as7;

import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardWrapper;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.mobicents.as7.SipExtension;
import org.mobicents.as7.SipSubsystemServices;

public class SipDeploymentServletDefinition
extends SimpleResourceDefinition {
    public static final SipDeploymentServletDefinition INSTANCE = new SipDeploymentServletDefinition();
    protected static final SimpleAttributeDefinition LOAD_TIME = new SimpleAttributeDefinitionBuilder("load-time", ModelType.LONG, true).build();
    protected static final SimpleAttributeDefinition MAX_TIME = new SimpleAttributeDefinitionBuilder("maxTime", ModelType.LONG, true).build();
    protected static final SimpleAttributeDefinition MIN_TIME = new SimpleAttributeDefinitionBuilder("min-time", ModelType.LONG, true).build();
    protected static final SimpleAttributeDefinition PROCESSING_TIME = new SimpleAttributeDefinitionBuilder("processingTime", ModelType.LONG, true).build();
    protected static final SimpleAttributeDefinition REQUEST_COUNT = new SimpleAttributeDefinitionBuilder("requestCount", ModelType.INT, true).build();

    private SipDeploymentServletDefinition() {
        super(PathElement.pathElement((String)"servlet"), (ResourceDescriptionResolver)SipExtension.getResourceDescriptionResolver("deployment.servlet"));
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        registration.registerMetric((AttributeDefinition)LOAD_TIME, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, StandardWrapper wrapper) {
                response.set(wrapper.getLoadTime());
            }
        });
        registration.registerMetric((AttributeDefinition)MAX_TIME, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, StandardWrapper wrapper) {
                response.set(wrapper.getMinTime());
            }
        });
        registration.registerMetric((AttributeDefinition)MIN_TIME, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, StandardWrapper wrapper) {
                response.set(wrapper.getLoadTime());
            }
        });
        registration.registerMetric((AttributeDefinition)PROCESSING_TIME, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, StandardWrapper wrapper) {
                response.set(wrapper.getProcessingTime());
            }
        });
        registration.registerMetric((AttributeDefinition)REQUEST_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, StandardWrapper wrapper) {
                response.set(wrapper.getRequestCount());
            }
        });
    }

    static abstract class AbstractMetricsHandler
    implements OperationStepHandler {
        AbstractMetricsHandler() {
        }

        abstract void handle(ModelNode var1, String var2, StandardWrapper var3);

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            final PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            Resource sip = context.readResourceFromRoot(address.subAddress(0, address.size() - 1), false);
            ModelNode subModel = sip.getModel();
            final String appName = subModel.require("app-name").asString();
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry(false).getService(SipSubsystemServices.deploymentServiceName(appName));
                    if (controller != null) {
                        String name = address.getLastElement().getValue();
                        Context webContext = (Context)Context.class.cast(controller.getValue());
                        Wrapper wrapper = (Wrapper)Wrapper.class.cast(webContext.findChild(name));
                        ModelNode response = new ModelNode();
                        AbstractMetricsHandler.this.handle(response, name, (StandardWrapper)wrapper);
                        context.getResult().set(response);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
            context.completeStep();
        }
    }
}

