/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.as7;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.mobicents.as7.SipExtension;
import org.mobicents.as7.SipMessages;
import org.mobicents.as7.SipSubsystemServices;
import org.mobicents.as7.deployment.SIPWebContext;
import org.mobicents.servlet.sip.core.SipManager;

public class SipDeploymentDefinition
extends SimpleResourceDefinition {
    public static final SipDeploymentDefinition INSTANCE = new SipDeploymentDefinition();
    public static final AttributeDefinition APP_NAME = new SimpleAttributeDefinitionBuilder("app-name", ModelType.STRING).setStorageRuntime().build();

    private SipDeploymentDefinition() {
        super(PathElement.pathElement((String)"subsystem", (String)"sip"), (ResourceDescriptionResolver)SipExtension.getResourceDescriptionResolver("deployment"));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute(APP_NAME, null);
        for (SessionStat stat : SessionStat.values()) {
            resourceRegistration.registerMetric(stat.definition, (OperationStepHandler)SessionManagerStatsHandler.getInstance());
        }
    }

    public static enum SessionStat {
        ACTIVE_SIP_SESSIONS((AttributeDefinition)new SimpleAttributeDefinition("active-sip-sessions", ModelType.INT, false)),
        ACTIVE_SIP_APP_SESSIONS((AttributeDefinition)new SimpleAttributeDefinition("active-sip-application-sessions", ModelType.INT, false)),
        EXPIRED_SIP_SESSIONS((AttributeDefinition)new SimpleAttributeDefinition("expired-sip-sessions", ModelType.INT, false)),
        EXPIRED_SIP_APP_SESSIONS((AttributeDefinition)new SimpleAttributeDefinition("expired-sip-application-sessions", ModelType.INT, false)),
        SIP_SESSIONS_CREATED((AttributeDefinition)new SimpleAttributeDefinition("sip-sessions-created", ModelType.INT, false)),
        SIP_APP_SESSIONS_CREATED((AttributeDefinition)new SimpleAttributeDefinition("sip-application-sessions-created", ModelType.INT, false)),
        SIP_SESSIONS_CREATION_RATE((AttributeDefinition)new SimpleAttributeDefinition("sip-sessions-per-sec", ModelType.INT, false)),
        SIP_APP_SESSIONS_CREATION_RATE((AttributeDefinition)new SimpleAttributeDefinition("sip-application-sessions-per-sec", ModelType.INT, false)),
        SIP_SESSION_AVG_ALIVE_TIME((AttributeDefinition)new SimpleAttributeDefinition("sip-session-avg-alive-time", ModelType.INT, false)),
        SIP_APP_SESSION_AVG_ALIVE_TIME((AttributeDefinition)new SimpleAttributeDefinition("sip-application-session-avg-alive-time", ModelType.INT, false)),
        SIP_SESSION_MAX_ALIVE_TIME((AttributeDefinition)new SimpleAttributeDefinition("sip-session-max-alive-time", ModelType.INT, false)),
        SIP_APP_SESSION_MAX_ALIVE_TIME((AttributeDefinition)new SimpleAttributeDefinition("sip-application-session-max-alive-time", ModelType.INT, false)),
        REJECTED_SIP_SESSIONS((AttributeDefinition)new SimpleAttributeDefinition("rejected-sip-sessions", ModelType.INT, false)),
        REJECTED_SIP_APP_SESSIONS((AttributeDefinition)new SimpleAttributeDefinition("rejected-sip-application-sessions", ModelType.INT, false)),
        MAX_ACTIVE_SIP_SESSIONS((AttributeDefinition)new SimpleAttributeDefinition("max-active-sip-sessions", ModelType.INT, false));

        private static final Map<String, SessionStat> MAP;
        final AttributeDefinition definition;

        private SessionStat(AttributeDefinition definition) {
            this.definition = definition;
        }

        public final String toString() {
            return this.definition.getName();
        }

        public static synchronized SessionStat getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, SessionStat>();
            for (SessionStat stat : EnumSet.allOf(SessionStat.class)) {
                MAP.put(stat.toString(), stat);
            }
        }
    }

    static class SessionManagerStatsHandler
    extends AbstractRuntimeOnlyHandler {
        static SessionManagerStatsHandler INSTANCE = new SessionManagerStatsHandler();

        private SessionManagerStatsHandler() {
        }

        public static SessionManagerStatsHandler getInstance() {
            return INSTANCE;
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            Resource sip = context.readResourceFromRoot(address.subAddress(0, address.size()), false);
            ModelNode subModel = sip.getModel();
            String appName = APP_NAME.resolveModelAttribute(context, subModel).asString();
            ServiceController controller = context.getServiceRegistry(false).getService(SipSubsystemServices.deploymentServiceName(appName));
            SessionStat stat = SessionStat.getStat(operation.require("name").asString());
            if (stat == null) {
                context.getFailureDescription().set(SipMessages.MESSAGES.unknownMetric(operation.require("name").asString()));
            } else {
                SIPWebContext sipContext = (SIPWebContext)((Object)SIPWebContext.class.cast(controller.getValue()));
                SipManager sm = (SipManager)sipContext.getManager();
                ModelNode result = new ModelNode();
                switch (stat) {
                    case ACTIVE_SIP_SESSIONS: {
                        result.set(sm.getActiveSipSessions());
                        break;
                    }
                    case ACTIVE_SIP_APP_SESSIONS: {
                        result.set(sm.getActiveSipApplicationSessions());
                        break;
                    }
                    case EXPIRED_SIP_SESSIONS: {
                        result.set(sm.getExpiredSipSessions());
                        break;
                    }
                    case EXPIRED_SIP_APP_SESSIONS: {
                        result.set(sm.getExpiredSipApplicationSessions());
                        break;
                    }
                    case MAX_ACTIVE_SIP_SESSIONS: {
                        result.set(sm.getMaxActiveSipSessions());
                        break;
                    }
                    case SIP_SESSIONS_CREATED: {
                        result.set(sm.getSipSessionCounter());
                        break;
                    }
                    case SIP_APP_SESSIONS_CREATED: {
                        result.set(sm.getSipApplicationSessionCounter());
                        break;
                    }
                    case SIP_SESSIONS_CREATION_RATE: {
                        result.set(sm.getNumberOfSipSessionCreationPerSecond());
                        break;
                    }
                    case SIP_APP_SESSIONS_CREATION_RATE: {
                        result.set(sm.getNumberOfSipApplicationSessionCreationPerSecond());
                        break;
                    }
                    case SIP_SESSION_AVG_ALIVE_TIME: {
                        result.set(sm.getSipSessionAverageAliveTime());
                        break;
                    }
                    case SIP_APP_SESSION_AVG_ALIVE_TIME: {
                        result.set(sm.getSipApplicationSessionAverageAliveTime());
                        break;
                    }
                    case SIP_SESSION_MAX_ALIVE_TIME: {
                        result.set(sm.getSipSessionMaxAliveTime());
                        break;
                    }
                    case SIP_APP_SESSION_MAX_ALIVE_TIME: {
                        result.set(sm.getSipApplicationSessionMaxAliveTime());
                        break;
                    }
                    case REJECTED_SIP_SESSIONS: {
                        result.set(sm.getRejectedSipSessions());
                        break;
                    }
                    case REJECTED_SIP_APP_SESSIONS: {
                        result.set(sm.getRejectedSipSessions());
                        break;
                    }
                    default: {
                        throw new IllegalStateException(SipMessages.MESSAGES.unknownMetric((Object)stat));
                    }
                }
                context.getResult().set(result);
            }
            context.completeStep();
        }
    }
}

