/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.as7;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.apache.catalina.connector.Connector;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.mobicents.as7.SipMessages;
import org.mobicents.as7.SipServer;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.startup.SipProtocolHandler;

class SipConnectorService
implements Service<Connector> {
    private String protocol = "SIP/2.0";
    private String scheme = "sip";
    private Boolean useStaticAddress = false;
    private String staticServerAddress = null;
    private int staticServerPort = -1;
    private Boolean useStun = false;
    private String stunServerAddress = null;
    private int stunServerPort = -1;
    private String hostNames = null;
    private Boolean enableLookups = null;
    private String proxyName = null;
    private Integer proxyPort = null;
    private Integer redirectPort = null;
    private Boolean secure = null;
    private Integer maxPostSize = null;
    private Integer maxSavePostSize = null;
    private Connector connector;
    private final InjectedValue<Executor> executor = new InjectedValue();
    private final InjectedValue<SocketBinding> binding = new InjectedValue();
    private final InjectedValue<SipServer> server = new InjectedValue();

    public SipConnectorService(String protocol, String scheme, boolean useStaticAddress, String staticServerAddress, int staticServerPort, boolean useStun, String stunServerAddress, int stunServerPort, String hostNames) {
        if (protocol != null) {
            this.protocol = protocol;
        }
        if (scheme != null) {
            this.scheme = scheme;
        }
        this.useStaticAddress = useStaticAddress;
        if (staticServerAddress != null) {
            this.staticServerAddress = staticServerAddress;
        }
        this.staticServerPort = staticServerPort;
        this.useStun = useStun;
        if (stunServerAddress != null) {
            this.stunServerAddress = stunServerAddress;
        }
        this.stunServerPort = stunServerPort;
        this.hostNames = hostNames;
    }

    public synchronized void start(StartContext context) throws StartException {
        Logger.getLogger((String)"org.mobicents.as7").debug((Object)("SipConnectorService.start(), protocol = " + this.protocol + " - scheme = " + this.scheme));
        SocketBinding binding = (SocketBinding)this.binding.getValue();
        InetSocketAddress address = binding.getSocketAddress();
        Executor executor = (Executor)this.executor.getOptionalValue();
        try {
            Connector connector = new Connector(SipProtocolHandler.class.getName());
            connector.setPort(address.getPort());
            connector.setScheme(this.scheme);
            SipConnector sipConnector = new SipConnector();
            sipConnector.setIpAddress(address.getAddress().getHostAddress());
            sipConnector.setPort(address.getPort());
            sipConnector.setTransport(binding.getName().substring(binding.getName().lastIndexOf("sip-") + "sip-".length()));
            sipConnector.setUseStaticAddress(this.useStaticAddress.booleanValue());
            sipConnector.setStaticServerAddress(this.staticServerAddress);
            sipConnector.setStaticServerPort(this.staticServerPort);
            sipConnector.setUseStun(this.useStun.booleanValue());
            sipConnector.setStunServerAddress(this.stunServerAddress);
            sipConnector.setStunServerPort(this.stunServerPort);
            sipConnector.setHostNames(this.hostNames);
            Logger.getLogger((String)"org.mobicents.as7").debug((Object)("SipConnectorService.start(), address = " + address.getAddress().getHostAddress() + " - port = " + address.getPort() + " - transport = " + sipConnector.getTransport()));
            Logger.getLogger((String)"org.mobicents.as7").debug((Object)("SipConnectorService.start(), hostnames = " + this.hostNames));
            SipProtocolHandler sipProtocolHandler = (SipProtocolHandler)connector.getProtocolHandler();
            sipProtocolHandler.setSipConnector(sipConnector);
            if (this.enableLookups != null) {
                connector.setEnableLookups(this.enableLookups.booleanValue());
            }
            if (this.maxPostSize != null) {
                connector.setMaxPostSize(this.maxPostSize.intValue());
            }
            if (this.maxSavePostSize != null) {
                connector.setMaxSavePostSize(this.maxSavePostSize.intValue());
            }
            if (this.proxyName != null) {
                connector.setProxyName(this.proxyName);
            }
            if (this.proxyPort != null) {
                connector.setProxyPort(this.proxyPort.intValue());
            }
            if (this.redirectPort != null) {
                connector.setRedirectPort(this.redirectPort.intValue());
            }
            if (this.secure != null) {
                connector.setSecure(this.secure.booleanValue());
            }
            this.getSipServer().addConnector(connector);
            connector.init();
            connector.start();
            this.connector = connector;
        }
        catch (Exception e) {
            throw new StartException(SipMessages.MESSAGES.connectorStartError(), (Throwable)e);
        }
        binding.getSocketBindings().getNamedRegistry().registerBinding((ManagedBinding)new ConnectorBinding(binding));
    }

    public synchronized void stop(StopContext context) {
        SocketBinding binding = (SocketBinding)this.binding.getValue();
        binding.getSocketBindings().getNamedRegistry().unregisterBinding(binding.getName());
        Connector connector = this.connector;
        try {
            connector.pause();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            connector.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getSipServer().removeConnector(connector);
        this.connector = null;
    }

    public synchronized Connector getValue() throws IllegalStateException {
        Connector connector = this.connector;
        if (connector == null) {
            throw SipMessages.MESSAGES.nullValue();
        }
        return connector;
    }

    protected boolean isEnableLookups() {
        return this.enableLookups;
    }

    protected void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    protected String getProxyName() {
        return this.proxyName;
    }

    protected void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    protected int getProxyPort() {
        return this.proxyPort;
    }

    protected void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    protected int getRedirectPort() {
        return this.redirectPort;
    }

    protected void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    protected boolean isSecure() {
        return this.secure;
    }

    protected void setSecure(boolean secure) {
        this.secure = secure;
    }

    protected int getMaxPostSize() {
        return this.maxPostSize;
    }

    protected void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    protected int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    protected void setMaxSavePostSize(int maxSavePostSize) {
        this.maxSavePostSize = maxSavePostSize;
    }

    InjectedValue<Executor> getExecutor() {
        return this.executor;
    }

    InjectedValue<SocketBinding> getBinding() {
        return this.binding;
    }

    InjectedValue<SipServer> getServer() {
        return this.server;
    }

    private SipServer getSipServer() {
        return (SipServer)this.server.getValue();
    }

    static class ConnectorBinding
    implements ManagedBinding {
        private final SocketBinding binding;

        private ConnectorBinding(SocketBinding binding) {
            this.binding = binding;
        }

        public String getSocketBindingName() {
            return this.binding.getName();
        }

        public InetSocketAddress getBindAddress() {
            return this.binding.getSocketAddress();
        }

        public void close() throws IOException {
        }
    }
}

