/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.as7;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.InetAddressValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.mobicents.as7.SipConnectorAdd;
import org.mobicents.as7.SipConnectorMetrics;
import org.mobicents.as7.SipConnectorRemove;
import org.mobicents.as7.SipExtension;

public class SipConnectorDefinition
extends SimpleResourceDefinition {
    protected static final SipConnectorDefinition INSTANCE = new SipConnectorDefinition();
    protected static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setXmlName("name").setAllowNull(true).build();
    protected static final SimpleAttributeDefinition PROTOCOL = new SimpleAttributeDefinitionBuilder("protocol", ModelType.STRING).setXmlName("protocol").setAllowNull(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1)).build();
    protected static final SimpleAttributeDefinition SOCKET_BINDING = new SimpleAttributeDefinitionBuilder("socket-binding", ModelType.STRING).setXmlName("socket-binding").setAllowNull(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1)).build();
    protected static final SimpleAttributeDefinition SCHEME = new SimpleAttributeDefinitionBuilder("scheme", ModelType.STRING).setXmlName("scheme").setAllowNull(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1)).build();
    protected static final SimpleAttributeDefinition ENABLED = new SimpleAttributeDefinitionBuilder("enabled", ModelType.BOOLEAN).setXmlName("enabled").setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(true)).build();
    protected static final SimpleAttributeDefinition USE_STATIC_ADDRESS = new SimpleAttributeDefinitionBuilder("use-static-address", ModelType.BOOLEAN).setXmlName("use-static-address").setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(false)).build();
    protected static final SimpleAttributeDefinition STATIC_SERVER_ADDRESS = new SimpleAttributeDefinitionBuilder("static-server-address", ModelType.STRING).setXmlName("static-server-address").setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new InetAddressValidator(true, false)).setRequires(new String[]{"use-static-address"}).build();
    protected static final SimpleAttributeDefinition STATIC_SERVER_PORT = new SimpleAttributeDefinitionBuilder("static-server-port", ModelType.INT).setXmlName("static-server-port").setAllowNull(true).setValidator((ParameterValidator)new IntRangeValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setRequires(new String[]{"use-static-address"}).build();
    protected static final SimpleAttributeDefinition USE_STUN = new SimpleAttributeDefinitionBuilder("use-stun", ModelType.BOOLEAN).setXmlName("use-stun").setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(false)).build();
    protected static final SimpleAttributeDefinition STUN_SERVER_ADDRESS = new SimpleAttributeDefinitionBuilder("stun-server-address", ModelType.STRING).setXmlName("stun-server-address").setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new InetAddressValidator(true, false)).setRequires(new String[]{"use-stun"}).build();
    protected static final SimpleAttributeDefinition STUN_SERVER_PORT = new SimpleAttributeDefinitionBuilder("stun-server-port", ModelType.INT).setXmlName("stun-server-port").setAllowNull(true).setValidator((ParameterValidator)new IntRangeValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setRequires(new String[]{"use-stun"}).build();
    protected static final SimpleAttributeDefinition HOSTNAMES = new SimpleAttributeDefinitionBuilder("hostnames", ModelType.STRING).setXmlName("hostnames").setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1)).build();
    protected static final SimpleAttributeDefinition[] CONNECTOR_ATTRIBUTES = new SimpleAttributeDefinition[]{PROTOCOL, SCHEME, SOCKET_BINDING, ENABLED, USE_STATIC_ADDRESS, STATIC_SERVER_ADDRESS, STATIC_SERVER_PORT, USE_STUN, STUN_SERVER_ADDRESS, STUN_SERVER_PORT, HOSTNAMES};

    private SipConnectorDefinition() {
        super(SipExtension.CONNECTOR_PATH, (ResourceDescriptionResolver)SipExtension.getResourceDescriptionResolver("connector"), (OperationStepHandler)SipConnectorAdd.INSTANCE, (OperationStepHandler)SipConnectorRemove.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration connectors) {
        connectors.registerReadOnlyAttribute((AttributeDefinition)NAME, null);
        for (SimpleAttributeDefinition def : CONNECTOR_ATTRIBUTES) {
            connectors.registerReadWriteAttribute((AttributeDefinition)def, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{def}));
        }
        for (SimpleAttributeDefinition def : SipConnectorMetrics.ATTRIBUTES) {
            connectors.registerMetric((AttributeDefinition)def, (OperationStepHandler)SipConnectorMetrics.INSTANCE);
        }
    }
}

