/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.management;

import java.util.Locale;
import javax.persistence.Cache;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jpa.hibernate4.management.CollectionResourceDefinition;
import org.jboss.as.jpa.hibernate4.management.EntityResourceDefinition;
import org.jboss.as.jpa.hibernate4.management.HibernateDescriptions;
import org.jboss.as.jpa.hibernate4.management.HibernateStatisticsResource;
import org.jboss.as.jpa.hibernate4.management.ManagementLookup;
import org.jboss.as.jpa.hibernate4.management.QueryResourceDefinition;
import org.jboss.as.jpa.hibernate4.management.SecondLevelCacheResourceDefinition;
import org.jboss.as.jpa.hibernate4.management.StatisticsEnabledWriteHandler;
import org.jboss.as.jpa.spi.ManagementAdaptor;
import org.jboss.as.jpa.spi.PersistenceUnitServiceRegistry;
import org.jboss.dmr.ModelNode;

public class HibernateManagementAdaptor
implements ManagementAdaptor {
    private static final HibernateManagementAdaptor INSTANCE = new HibernateManagementAdaptor();
    private static final String PROVIDER_LABEL = "hibernate-persistence-unit";
    public static final String OPERATION_CLEAR = "clear";
    public static final String OPERATION_EVICTALL = "evict-all";
    public static final String OPERATION_SUMMARY = "summary";
    public static final String OPERATION_STATISTICS_ENABLED = "enabled";
    public static final String OPERATION_ENTITY_DELETE_COUNT = "entity-delete-count";
    public static final String OPERATION_ENTITY_INSERT_COUNT = "entity-insert-count";
    public static final String OPERATION_ENTITY_LOAD_COUNT = "entity-load-count";
    public static final String OPERATION_ENTITY_FETCH_COUNT = "entity-fetch-count";
    public static final String OPERATION_ENTITY_UPDATE_COUNT = "entity-update-count";
    public static final String ATTRIBUTE_QUERY_NAME = "query-name";
    public static final String OPERATION_QUERY_EXECUTION_COUNT = "query-execution-count";
    public static final String OPERATION_QUERY_EXECUTION_ROW_COUNT = "query-execution-row-count";
    public static final String OPERATION_QUERY_EXECUTION_AVG_TIME = "query-execution-average-time";
    public static final String OPERATION_QUERY_EXECUTION_MAX_TIME = "query-execution-max-time";
    public static final String OPERATION_QUERY_EXECUTION_MIN_TIME = "query-execution-min-time";
    public static final String OPERATION_QUERY_EXECUTION_MAX_TIME_QUERY_STRING = "query-execution-max-time-query-string";
    public static final String OPERATION_QUERY_CACHE_HIT_COUNT = "query-cache-hit-count";
    public static final String OPERATION_QUERY_CACHE_MISS_COUNT = "query-cache-miss-count";
    public static final String OPERATION_QUERY_CACHE_PUT_COUNT = "query-cache-put-count";
    public static final String OPERATION_FLUSH_COUNT = "flush-count";
    public static final String OPERATION_CONNECT_COUNT = "connect-count";
    public static final String OPERATION_SECOND_LEVEL_CACHE_HIT_COUNT = "second-level-cache-hit-count";
    public static final String OPERATION_SECOND_LEVEL_CACHE_MISS_COUNT = "second-level-cache-miss-count";
    public static final String OPERATION_SECOND_LEVEL_CACHE_PUT_COUNT = "second-level-cache-put-count";
    public static final String OPERATION_SESSION_CLOSE_COUNT = "session-close-count";
    public static final String OPERATION_SESSION_OPEN_COUNT = "session-open-count";
    public static final String OPERATION_COLLECTION_LOAD_COUNT = "collection-load-count";
    public static final String OPERATION_COLLECTION_FETCH_COUNT = "collection-fetch-count";
    public static final String OPERATION_COLLECTION_UPDATE_COUNT = "collection-update-count";
    public static final String OPERATION_COLLECTION_REMOVE_COUNT = "collection-remove-count";
    public static final String OPERATION_COLLECTION_RECREATED_COUNT = "collection-recreated-count";
    public static final String OPERATION_SUCCESSFUL_TRANSACTION_COUNT = "successful-transaction-count";
    public static final String OPERATION_COMPLETED_TRANSACTION_COUNT = "completed-transaction-count";
    public static final String OPERATION_PREPARED_STATEMENT_COUNT = "prepared-statement-count";
    public static final String OPERATION_CLOSE_STATEMENT_COUNT = "close-statement-count";
    public static final String OPERATION_OPTIMISTIC_FAILURE_COUNT = "optimistic-failure-count";
    private PersistenceUnitServiceRegistry persistenceUnitRegistry;

    public static HibernateManagementAdaptor getInstance() {
        return INSTANCE;
    }

    public void register(ManagementResourceRegistration jpaSubsystemDeployments, PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        this.persistenceUnitRegistry = persistenceUnitRegistry;
        DescriptionProvider topLevelDescriptions = new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return HibernateDescriptions.describeTopLevelAttributes(locale);
            }
        };
        ManagementResourceRegistration jpaHibernateRegistration = jpaSubsystemDeployments.registerSubModel(PathElement.pathElement((String)this.getIdentificationLabel()), topLevelDescriptions);
        this.registerStatisticAttributes(jpaHibernateRegistration);
        this.registerStatisticOperations(jpaHibernateRegistration);
        jpaHibernateRegistration.registerSubModel((ResourceDefinition)new SecondLevelCacheResourceDefinition(persistenceUnitRegistry));
        jpaHibernateRegistration.registerSubModel((ResourceDefinition)new QueryResourceDefinition(persistenceUnitRegistry));
        jpaHibernateRegistration.registerSubModel((ResourceDefinition)new EntityResourceDefinition(persistenceUnitRegistry));
        jpaHibernateRegistration.registerSubModel((ResourceDefinition)new CollectionResourceDefinition(persistenceUnitRegistry));
    }

    public Resource createPersistenceUnitResource(String persistenceUnitName, String providerLabel) {
        return new HibernateStatisticsResource(persistenceUnitName, this.persistenceUnitRegistry, providerLabel);
    }

    private void registerStatisticOperations(ManagementResourceRegistration jpaHibernateRegistration) {
        DescriptionProvider clear = new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return HibernateDescriptions.clear(locale);
            }
        };
        AbstractMetricsHandler clearHandler = new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                stats.getStatistics().clear();
            }
        };
        jpaHibernateRegistration.registerOperationHandler(OPERATION_CLEAR, (OperationStepHandler)clearHandler, clear);
        DescriptionProvider evictAll = new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return HibernateDescriptions.evictall(locale);
            }
        };
        AbstractMetricsHandler evictAllHandler = new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                Cache secondLevelCache = stats.getEntityManagerFactory().getCache();
                if (secondLevelCache != null) {
                    secondLevelCache.evictAll();
                }
            }
        };
        jpaHibernateRegistration.registerOperationHandler(OPERATION_EVICTALL, (OperationStepHandler)evictAllHandler, evictAll);
        DescriptionProvider summary = new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return HibernateDescriptions.summary(locale);
            }
        };
        AbstractMetricsHandler summaryHandler = new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                stats.getStatistics().logSummary();
            }
        };
        jpaHibernateRegistration.registerOperationHandler(OPERATION_SUMMARY, (OperationStepHandler)summaryHandler, summary);
    }

    private void registerStatisticAttributes(ManagementResourceRegistration jpaHibernateRegistration) {
        jpaHibernateRegistration.registerMetric(OPERATION_ENTITY_DELETE_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getEntityDeleteCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_ENTITY_INSERT_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getEntityInsertCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_ENTITY_LOAD_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getEntityLoadCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_ENTITY_FETCH_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getEntityFetchCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_ENTITY_UPDATE_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getEntityUpdateCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_QUERY_EXECUTION_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getQueryExecutionCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_QUERY_EXECUTION_MAX_TIME, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getQueryExecutionMaxTime());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_QUERY_EXECUTION_MAX_TIME_QUERY_STRING, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                String sql = stats.getStatistics().getQueryExecutionMaxTimeQueryString();
                if (sql != null) {
                    response.set(sql);
                } else {
                    context.getResult();
                }
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_QUERY_CACHE_HIT_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getQueryCacheHitCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_QUERY_CACHE_MISS_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getQueryCacheMissCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_QUERY_CACHE_PUT_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getQueryCachePutCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_FLUSH_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getFlushCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_CONNECT_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getConnectCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_SECOND_LEVEL_CACHE_HIT_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getSecondLevelCacheHitCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_SECOND_LEVEL_CACHE_MISS_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getSecondLevelCacheMissCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_SECOND_LEVEL_CACHE_PUT_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getSecondLevelCachePutCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_SESSION_CLOSE_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getSessionCloseCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_SESSION_OPEN_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getSessionOpenCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_COLLECTION_LOAD_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getCollectionLoadCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_COLLECTION_FETCH_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getCollectionFetchCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_COLLECTION_UPDATE_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getCollectionUpdateCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_COLLECTION_REMOVE_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getCollectionRemoveCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_COLLECTION_RECREATED_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getCollectionRecreateCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_SUCCESSFUL_TRANSACTION_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getSuccessfulTransactionCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_COMPLETED_TRANSACTION_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getTransactionCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_PREPARED_STATEMENT_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getPrepareStatementCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_CLOSE_STATEMENT_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getCloseStatementCount());
            }
        });
        jpaHibernateRegistration.registerMetric(OPERATION_OPTIMISTIC_FAILURE_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().getOptimisticFailureCount());
            }
        });
        jpaHibernateRegistration.registerReadWriteAttribute(OPERATION_STATISTICS_ENABLED, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, ManagementLookup stats, OperationContext context) {
                response.set(stats.getStatistics().isStatisticsEnabled());
            }
        }, (OperationStepHandler)new StatisticsEnabledWriteHandler(this.persistenceUnitRegistry), AttributeAccess.Storage.RUNTIME);
    }

    public String getIdentificationLabel() {
        return PROVIDER_LABEL;
    }

    abstract class AbstractMetricsHandler
    extends AbstractRuntimeOnlyHandler {
        AbstractMetricsHandler() {
        }

        abstract void handle(ModelNode var1, String var2, ManagementLookup var3, OperationContext var4);

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            String puResourceName = address.getLastElement().getValue();
            ManagementLookup stats = ManagementLookup.create(HibernateManagementAdaptor.this.persistenceUnitRegistry, puResourceName);
            if (stats != null) {
                this.handle(context.getResult(), address.getLastElement().getValue(), stats, context);
            }
            context.stepCompleted();
        }
    }
}

