/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.hardware.dahdi;

import java.io.IOException;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.mobicents.media.hardware.dahdi.Channel;
import org.mobicents.media.hardware.dahdi.SelectorKeyImpl;
import org.mobicents.protocols.stream.api.SelectorKey;
import org.mobicents.protocols.stream.api.Stream;
import org.mobicents.protocols.stream.api.StreamSelector;

public class Selector
implements StreamSelector {
    private static final String LIB_NAME = "mobicents-dahdi-linux";
    public static final int READ = 1;
    public static final int WRITE = 2;
    private int[] fds = new int[480];
    private FastList<Channel> registered = new FastList();
    private int ops;
    private FastList<SelectorKey> selected = new FastList();
    private static Logger logger = Logger.getLogger(Selector.class);

    public SelectorKey register(Channel channel) {
        this.registered.add((Object)channel);
        logger.info((Object)("Registering file descriptor:" + channel.fd));
        this.doRegister(channel.fd);
        SelectorKeyImpl key = new SelectorKeyImpl(channel, this);
        channel.selectorKey = key;
        return key;
    }

    public void unregister(Channel channel) {
        this.registered.remove((Object)channel);
        channel.selectorKey = null;
        this.doUnregister(channel.fd);
    }

    public native void doRegister(int var1);

    public native void doUnregister(int var1);

    public native int doPoll(int[] var1, int var2, int var3);

    public FastList<SelectorKey> selectNow(int ops, int timeout) throws IOException {
        int count = this.doPoll(this.fds, ops, 1);
        this.selected.clear();
        for (int i = 0; i < count; ++i) {
            FastList.Node n = this.registered.head();
            FastList.Node end = this.registered.tail();
            while ((n = n.getNext()) != end) {
                Channel channel = (Channel)n.getValue();
                if (channel.fd != this.fds[i]) continue;
                this.selected.add((Object)channel.selectorKey);
            }
        }
        return this.selected;
    }

    public void setOperation(int v) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getOperations() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isReadOperation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isWriteOperation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isClosed() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FastList<Stream> getRegisteredStreams() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        try {
            System.loadLibrary(LIB_NAME);
            System.out.println("Loaded library mobicents-dahdi-linux");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

