/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.sms;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.restcomm.dao.ClientsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.dao.RegistrationsDao;
import org.mobicents.servlet.restcomm.entities.Client;
import org.mobicents.servlet.restcomm.entities.Registration;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.patterns.Observing;
import org.mobicents.servlet.restcomm.patterns.StopObserving;
import org.mobicents.servlet.restcomm.sms.GetLastSmsRequest;
import org.mobicents.servlet.restcomm.sms.SmsSessionAttribute;
import org.mobicents.servlet.restcomm.sms.SmsSessionInfo;
import org.mobicents.servlet.restcomm.sms.SmsSessionRequest;
import org.mobicents.servlet.restcomm.sms.SmsSessionResponse;

public final class SmsSession
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final Configuration configuration;
    private final SipFactory factory;
    private final List<ActorRef> observers;
    private final SipURI transport;
    private final Map<String, Object> attributes;
    private ConcurrentHashMap<String, String> customRequestHeaderMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> customHttpHeaderMap;
    private final DaoManager storage;
    private SmsSessionRequest initial;
    private SmsSessionRequest last;

    public SmsSession(Configuration configuration, SipFactory factory, SipURI transport, DaoManager storage) {
        this.configuration = configuration;
        this.factory = factory;
        this.observers = new ArrayList<ActorRef>();
        this.transport = transport;
        this.attributes = new HashMap<String, Object>();
        this.storage = storage;
    }

    private void inbound(Object message) throws IOException {
        SipServletRequest request = (SipServletRequest)message;
        SipURI uri = (SipURI)request.getFrom().getURI();
        String from = uri.getUser();
        uri = (SipURI)request.getTo().getURI();
        String to = uri.getUser();
        String body = null;
        if (request.getContentLength() > 0) {
            body = new String(request.getRawContent());
        }
        Iterator headerIt = request.getHeaderNames();
        while (headerIt.hasNext()) {
            String headerName = (String)headerIt.next();
            if (!headerName.startsWith("X-")) continue;
            this.customRequestHeaderMap.put(headerName, request.getHeader(headerName));
        }
        this.last = new SmsSessionRequest(from, to, body, this.customRequestHeaderMap);
        if (this.initial == null) {
            this.initial = this.last;
        }
        ActorRef self = this.self();
        for (ActorRef observer : this.observers) {
            observer.tell((Object)this.last, self);
        }
    }

    private SmsSessionInfo info() {
        String from = this.initial.from();
        String to = this.initial.to();
        ImmutableMap attributes = ImmutableMap.copyOf(this.attributes);
        return new SmsSessionInfo(from, to, (Map)attributes);
    }

    private void observe(Object message) {
        ActorRef self = this.self();
        Observe request = (Observe)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.add(observer);
            observer.tell((Object)new Observing(self), self);
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (Observe.class.equals(klass)) {
            this.observe(message);
        } else if (StopObserving.class.equals(klass)) {
            this.stopObserving(message);
        } else if (GetLastSmsRequest.class.equals(klass)) {
            sender.tell((Object)this.last, self);
        } else if (SmsSessionAttribute.class.equals(klass)) {
            SmsSessionAttribute attribute = (SmsSessionAttribute)message;
            this.attributes.put(attribute.name(), attribute.value());
        } else if (SmsSessionRequest.class.equals(klass)) {
            this.customHttpHeaderMap = ((SmsSessionRequest)message).headers();
            this.outbound(message);
        } else if (message instanceof SipServletRequest) {
            this.inbound(message);
        } else if (message instanceof SipServletResponse) {
            this.response(message);
        }
    }

    private void response(Object message) {
        SipServletResponse response = (SipServletResponse)message;
        int status = response.getStatus();
        SmsSessionInfo info = this.info();
        SmsSessionResponse result = null;
        result = 202 == status || 200 == status ? new SmsSessionResponse(info, true) : new SmsSessionResponse(info, false);
        ActorRef self = this.self();
        for (ActorRef observer : this.observers) {
            observer.tell((Object)result, self);
        }
    }

    private void outbound(Object message) {
        this.last = (SmsSessionRequest)message;
        if (this.initial == null) {
            this.initial = this.last;
        }
        ActorRef self = this.self();
        String from = this.last.from();
        String to = this.last.to();
        String body = this.last.body();
        String prefix = this.configuration.getString("outbound-prefix");
        String service = this.configuration.getString("outbound-endpoint");
        if (service == null) {
            return;
        }
        ClientsDao clients = this.storage.getClientsDao();
        Client toClient = clients.getClient(to);
        Registration toClientRegistration = null;
        if (toClient != null) {
            RegistrationsDao registrations = this.storage.getRegistrationsDao();
            toClientRegistration = registrations.getRegistration(toClient.getLogin());
        }
        SipApplicationSession application = this.factory.createApplicationSession();
        StringBuilder buffer = new StringBuilder();
        buffer.append("sip:").append(from).append("@").append(this.transport.getHost() + ":" + this.transport.getPort());
        String sender = buffer.toString();
        buffer = new StringBuilder();
        if (toClient != null && toClientRegistration != null) {
            buffer.append(toClientRegistration.getLocation());
        } else {
            buffer.append("sip:");
            if (prefix != null) {
                buffer.append(prefix);
            }
            buffer.append(to).append("@").append(service);
        }
        String recipient = buffer.toString();
        try {
            application.setAttribute(SmsSession.class.getName(), (Object)self);
            SipServletRequest sms = this.factory.createRequest(application, "MESSAGE", sender, recipient);
            SipURI uri = (SipURI)this.factory.createURI(recipient);
            sms.pushRoute(uri);
            sms.setRequestURI((URI)uri);
            sms.setContent((Object)body, "text/plain");
            SipSession session = sms.getSession();
            session.setHandler("SmsService");
            if (this.customHttpHeaderMap != null && !this.customHttpHeaderMap.isEmpty()) {
                for (String headerName : this.customHttpHeaderMap.keySet()) {
                    sms.setHeader(headerName, this.customHttpHeaderMap.get(headerName));
                }
            }
            sms.send();
        }
        catch (Exception exception) {
            SmsSessionInfo info = this.info();
            SmsSessionResponse error = new SmsSessionResponse(info, false);
            for (ActorRef observer : this.observers) {
                observer.tell((Object)error, self);
            }
            this.logger.error(exception.getMessage(), (Object)exception);
        }
    }

    private void stopObserving(Object message) {
        StopObserving request = (StopObserving)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }
}

