/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.sms;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Currency;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.dao.AccountsDao;
import org.mobicents.servlet.restcomm.dao.ApplicationsDao;
import org.mobicents.servlet.restcomm.dao.ClientsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.dao.IncomingPhoneNumbersDao;
import org.mobicents.servlet.restcomm.dao.NotificationsDao;
import org.mobicents.servlet.restcomm.dao.SmsMessagesDao;
import org.mobicents.servlet.restcomm.entities.Application;
import org.mobicents.servlet.restcomm.entities.Client;
import org.mobicents.servlet.restcomm.entities.IncomingPhoneNumber;
import org.mobicents.servlet.restcomm.entities.Notification;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.entities.SmsMessage;
import org.mobicents.servlet.restcomm.interpreter.SmsInterpreterBuilder;
import org.mobicents.servlet.restcomm.interpreter.StartInterpreter;
import org.mobicents.servlet.restcomm.sms.CreateSmsSession;
import org.mobicents.servlet.restcomm.sms.DestroySmsSession;
import org.mobicents.servlet.restcomm.sms.SmsServiceResponse;
import org.mobicents.servlet.restcomm.sms.SmsSession;
import org.mobicents.servlet.restcomm.sms.SmsSessionAttribute;
import org.mobicents.servlet.restcomm.sms.SmsSessionRequest;
import org.mobicents.servlet.restcomm.telephony.util.B2BUAHelper;
import org.mobicents.servlet.restcomm.telephony.util.CallControlHelper;
import org.mobicents.servlet.restcomm.util.UriUtils;

public final class SmsService
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final ActorSystem system;
    private final Configuration configuration;
    private boolean authenticateUsers = true;
    private final ServletConfig servletConfig;
    private final SipFactory sipFactory;
    private final DaoManager storage;
    private final ServletContext servletContext;
    static final int ERROR_NOTIFICATION = 0;
    static final int WARNING_NOTIFICATION = 1;
    private boolean useTo = true;

    public SmsService(ActorSystem system, Configuration configuration, SipFactory factory, DaoManager storage, ServletContext servletContext) {
        this.system = system;
        this.configuration = configuration;
        Configuration runtime = configuration.subset("runtime-settings");
        this.authenticateUsers = runtime.getBoolean("authenticate");
        this.servletConfig = (ServletConfig)configuration.getProperty(ServletConfig.class.getName());
        this.sipFactory = factory;
        this.storage = storage;
        this.servletContext = servletContext;
    }

    private void message(Object message) throws IOException {
        ActorRef self = this.self();
        SipServletRequest request = (SipServletRequest)message;
        SipURI fromURI = (SipURI)request.getFrom().getURI();
        String fromUser = fromURI.getUser();
        ClientsDao clients = this.storage.getClientsDao();
        Client client = clients.getClient(fromUser);
        AccountsDao accounts = this.storage.getAccountsDao();
        ApplicationsDao applications = this.storage.getApplicationsDao();
        if (client != null && this.authenticateUsers && !CallControlHelper.checkAuthentication((SipServletRequest)request, (DaoManager)this.storage)) {
            this.logger.info("Client " + client.getLogin() + " failed to authenticate");
            return;
        }
        String toUser = CallControlHelper.getUserSipId((SipServletRequest)request, (boolean)this.useTo);
        if (this.redirectToHostedSmsApp(self, request, accounts, applications, toUser)) {
            this.logger.info("Message to :" + toUser + " matched to one of the hosted applications");
            SipServletResponse messageAccepted = request.createResponse(202);
            messageAccepted.send();
            return;
        }
        if (client != null) {
            Client toClient = clients.getClient(toUser);
            if (toClient != null) {
                if (B2BUAHelper.redirectToB2BUA((SipServletRequest)request, (Client)client, (Client)toClient, (DaoManager)this.storage, (SipFactory)this.sipFactory)) {
                    this.logger.info("P2P, Message from: " + client.getLogin() + " redirected to registered client: " + toClient.getLogin());
                    return;
                }
            } else {
                this.logger.info("Restcomm will route this SMS to an external aggregator: " + client.getLogin() + " to: " + toUser);
                ActorRef session = this.session();
                Sid sid = Sid.generate((Sid.Type)Sid.Type.SMS_MESSAGE);
                SmsMessage.Builder builder = SmsMessage.builder();
                builder.setSid(sid);
                builder.setAccountSid(client.getAccountSid());
                builder.setApiVersion(client.getApiVersion());
                builder.setRecipient(toUser);
                builder.setSender(client.getLogin());
                builder.setBody(new String(request.getRawContent()));
                builder.setDirection(SmsMessage.Direction.OUTBOUND_CALL);
                builder.setStatus(SmsMessage.Status.RECEIVED);
                builder.setPrice(new BigDecimal("0.00"));
                builder.setPriceUnit(Currency.getInstance("USD"));
                StringBuilder buffer = new StringBuilder();
                buffer.append("/").append(client.getApiVersion()).append("/Accounts/");
                buffer.append(client.getAccountSid().toString()).append("/SMS/Messages/");
                buffer.append(sid.toString());
                URI uri = URI.create(buffer.toString());
                builder.setUri(uri);
                SmsMessage record = builder.build();
                SmsMessagesDao messages = this.storage.getSmsMessagesDao();
                messages.addSmsMessage(record);
                session.tell((Object)new SmsSessionAttribute("record", (Object)record), this.self());
                SmsSessionRequest sms = new SmsSessionRequest(client.getLogin(), toUser, new String(request.getRawContent()), null);
                session.tell((Object)sms, this.self());
            }
        } else {
            SipServletResponse response = request.createResponse(404);
            response.send();
            String errMsg = "Restcomm cannot process this SMS because the destination number cannot be found. To: " + toUser;
            this.sendNotification(errMsg, 11005, "error", true);
        }
    }

    private boolean redirectToHostedSmsApp(ActorRef self, SipServletRequest request, AccountsDao accounts, ApplicationsDao applications, String id) throws IOException {
        boolean isFoundHostedApp = false;
        SipURI uri = (SipURI)request.getRequestURI();
        String to = uri.getUser();
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        String phone = to;
        try {
            phone = phoneNumberUtil.format(phoneNumberUtil.parse(to, "US"), PhoneNumberUtil.PhoneNumberFormat.E164);
        }
        catch (Exception e) {
            // empty catch block
        }
        IncomingPhoneNumbersDao numbers = this.storage.getIncomingPhoneNumbersDao();
        IncomingPhoneNumber number = numbers.getIncomingPhoneNumber(phone);
        if (number == null) {
            number = numbers.getIncomingPhoneNumber(to);
        }
        try {
            if (number != null) {
                URI appUri = number.getSmsUrl();
                ActorRef interpreter = null;
                if (appUri != null) {
                    SmsInterpreterBuilder builder = new SmsInterpreterBuilder(this.system);
                    builder.setSmsService(self);
                    builder.setConfiguration(this.configuration);
                    builder.setStorage(this.storage);
                    builder.setAccount(number.getAccountSid());
                    builder.setVersion(number.getApiVersion());
                    Sid sid = number.getSmsApplicationSid();
                    if (sid != null) {
                        Application application = applications.getApplication(sid);
                        builder.setUrl(UriUtils.resolve((String)request.getLocalAddr(), (int)8080, (URI)application.getSmsUrl()));
                        builder.setMethod(application.getSmsMethod());
                        builder.setFallbackUrl(UriUtils.resolve((String)request.getLocalAddr(), (int)8080, (URI)application.getSmsFallbackUrl()));
                        builder.setFallbackMethod(application.getSmsFallbackMethod());
                    } else {
                        builder.setUrl(UriUtils.resolve((String)request.getLocalAddr(), (int)8080, (URI)appUri));
                        builder.setMethod(number.getSmsMethod());
                        URI appFallbackUrl = number.getSmsFallbackUrl();
                        if (appFallbackUrl != null) {
                            builder.setFallbackUrl(UriUtils.resolve((String)request.getLocalAddr(), (int)8080, (URI)number.getSmsFallbackUrl()));
                            builder.setFallbackMethod(number.getSmsFallbackMethod());
                        }
                    }
                    interpreter = builder.build();
                }
                ActorRef session = this.session();
                session.tell((Object)request, self);
                StartInterpreter start = new StartInterpreter(session);
                interpreter.tell((Object)start, self);
                isFoundHostedApp = true;
            }
        }
        catch (Exception e) {
            String errMsg = "There is no valid Restcomm SMS Request URL configured for this number : " + phone;
            this.sendNotification(errMsg, 12003, "error", true);
        }
        return isFoundHostedApp;
    }

    public void onReceive(Object message) throws Exception {
        SipServletResponse response;
        SipServletRequest request;
        String method;
        UntypedActorContext context = this.getContext();
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (CreateSmsSession.class.equals(klass)) {
            ActorRef session = this.session();
            SmsServiceResponse response2 = new SmsServiceResponse((Object)session);
            sender.tell((Object)response2, self);
        } else if (DestroySmsSession.class.equals(klass)) {
            DestroySmsSession request2 = (DestroySmsSession)message;
            ActorRef session = request2.session();
            context.stop(session);
        } else if (message instanceof SipServletRequest) {
            SipServletRequest request3 = (SipServletRequest)message;
            String method2 = request3.getMethod();
            if ("MESSAGE".equalsIgnoreCase(method2)) {
                this.message(message);
            }
        } else if (message instanceof SipServletResponse && "MESSAGE".equalsIgnoreCase(method = (request = (response = (SipServletResponse)message).getRequest()).getMethod())) {
            this.response(message);
        }
    }

    private void response(Object message) throws Exception {
        ActorRef self = this.self();
        SipServletResponse response = (SipServletResponse)message;
        if (B2BUAHelper.isB2BUASession((SipServletMessage)response)) {
            B2BUAHelper.forwardResponse((SipServletResponse)response);
            return;
        }
        SipApplicationSession application = response.getApplicationSession();
        ActorRef session = (ActorRef)application.getAttribute(SmsSession.class.getName());
        session.tell((Object)response, self);
    }

    private SipURI outboundInterface() {
        SipURI result = null;
        List uris = (List)this.servletContext.getAttribute("javax.servlet.sip.outboundInterfaces");
        for (SipURI uri : uris) {
            String transport = uri.getTransportParam();
            if (!"udp".equalsIgnoreCase(transport)) continue;
            result = uri;
        }
        return result;
    }

    private ActorRef session() {
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                Configuration smsConfiguration = SmsService.this.configuration.subset("sms-aggregator");
                return new SmsSession(smsConfiguration, SmsService.this.sipFactory, SmsService.this.outboundInterface(), SmsService.this.storage);
            }
        }));
    }

    private void sendNotification(String errMessage, int errCode, String errType, boolean createNotification) {
        NotificationsDao notifications = this.storage.getNotificationsDao();
        if (errType == "warning") {
            this.logger.warning(errMessage);
            if (createNotification) {
                Notification notification = this.notification(1, errCode, errMessage);
                notifications.addNotification(notification);
            }
        } else if (errType == "error") {
            this.logger.error(errMessage);
            if (createNotification) {
                Notification notification = this.notification(0, errCode, errMessage);
                notifications.addNotification(notification);
            }
        } else if (errType == "info") {
            this.logger.info(errMessage);
        }
    }

    private Notification notification(int log, int error, String message) {
        String version = this.configuration.subset("runtime-settings").getString("api-version");
        Sid accountId = new Sid("ACae6e420f425248d6a26948c17a9e2acf");
        Notification.Builder builder = Notification.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.NOTIFICATION);
        builder.setSid(sid);
        builder.setAccountSid(accountId);
        builder.setApiVersion(version);
        builder.setLog(log);
        builder.setErrorCode(error);
        String base = this.configuration.subset("runtime-settings").getString("error-dictionary-uri");
        StringBuilder buffer = new StringBuilder();
        buffer.append(base);
        if (!base.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(error).append(".html");
        URI info = URI.create(buffer.toString());
        builder.setMoreInfo(info);
        builder.setMessageText(message);
        DateTime now = DateTime.now();
        builder.setMessageDate(now);
        try {
            builder.setRequestUrl(new URI(""));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        builder.setRequestMethod("");
        builder.setRequestVariables("");
        buffer = new StringBuilder();
        buffer.append("/").append(version).append("/Accounts/");
        buffer.append(accountId.toString()).append("/Notifications/");
        buffer.append(sid.toString());
        URI uri = URI.create(buffer.toString());
        builder.setUri(uri);
        return builder.build();
    }
}

