/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.stack;

import java.net.DatagramSocket;
import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.StunException;
import net.java.stun4j.stack.NetAccessManager;
import net.java.stun4j.stack.StunProvider;

public class StunStack {
    private static StunStack stackInstance = null;
    private NetAccessManager netAccessManager = new NetAccessManager();
    public static final int DEFAULT_THREAD_POOL_SIZE = 5;
    private StunProvider stunProvider = new StunProvider(this);

    public static synchronized StunStack getInstance() {
        if (stackInstance == null) {
            stackInstance = new StunStack();
        }
        return stackInstance;
    }

    public void start() {
        this.netAccessManager.start();
    }

    public static void shutDown() {
        if (stackInstance == null) {
            return;
        }
        StunStack.stackInstance.stunProvider.shutDown();
        StunStack.stackInstance.netAccessManager.shutDown();
        StunStack.stackInstance.netAccessManager = null;
        StunStack.stackInstance.stunProvider = null;
        stackInstance = null;
    }

    public void setThreadPoolSize(int threadPoolSize) throws StunException {
        this.netAccessManager.setThreadPoolSize(threadPoolSize);
    }

    public void installNetAccessPoint(NetAccessPointDescriptor apDescriptor) throws StunException {
        this.checkStarted();
        this.netAccessManager.installNetAccessPoint(apDescriptor);
    }

    public NetAccessPointDescriptor installNetAccessPoint(DatagramSocket sock) throws StunException {
        this.checkStarted();
        return this.netAccessManager.installNetAccessPoint(sock);
    }

    public void removeNetAccessPoint(NetAccessPointDescriptor apDescriptor) throws StunException {
        this.checkStarted();
        this.netAccessManager.removeNetAccessPoint(apDescriptor);
    }

    public StunProvider getProvider() {
        return this.stunProvider;
    }

    private StunStack() {
        this.netAccessManager.setEventHandler(this.getProvider());
    }

    void checkStarted() throws StunException {
        if (!this.netAccessManager.isRunning()) {
            throw new StunException(1, "The stack needs to be started, for the requested method to work.");
        }
    }

    NetAccessManager getNetAccessManager() {
        return this.netAccessManager;
    }
}

