/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.stack;

import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.message.Response;
import net.java.stun4j.stack.StunProvider;
import net.java.stun4j.stack.TransactionID;

class StunServerTransaction
implements Runnable {
    private long transactionLifetime = 16000L;
    private StunProvider providerCallback = null;
    private StunAddress responseDestination = null;
    private Response response = null;
    private NetAccessPointDescriptor apDescriptor = null;
    private TransactionID transactionID = null;
    private long expirationDate = -1L;
    private Thread runningThread = null;
    private boolean expired = true;
    private boolean isRetransmitting = false;

    public StunServerTransaction(StunProvider providerCallback, TransactionID tranID) {
        this.providerCallback = providerCallback;
        this.transactionID = tranID;
        this.runningThread = new Thread(this);
    }

    public void start() {
        this.expired = false;
        this.runningThread.start();
    }

    public void run() {
        this.runningThread.setName("ServTran");
        this.schedule(this.transactionLifetime);
        this.waitNextScheduledDate();
        this.expire();
        this.providerCallback.removeServerTransaction(this);
    }

    void sendResponse(Response response, NetAccessPointDescriptor sendThrough, StunAddress sendTo) throws StunException {
        if (!this.isRetransmitting) {
            this.response = response;
            response.setTransactionID(this.transactionID.getTransactionID());
            this.apDescriptor = sendThrough;
            this.responseDestination = sendTo;
        }
        this.isRetransmitting = true;
        this.retransmitResponse();
    }

    void retransmitResponse() throws StunException {
        if (this.expired || !this.isRetransmitting) {
            return;
        }
        this.providerCallback.getNetAccessManager().sendMessage(this.response, this.apDescriptor, this.responseDestination);
    }

    synchronized void waitNextScheduledDate() {
        long current = System.currentTimeMillis();
        while (this.expirationDate - current > 0L) {
            try {
                this.wait(this.expirationDate - current);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.expired) {
                return;
            }
            current = System.currentTimeMillis();
        }
    }

    void schedule(long timeout) {
        this.expirationDate = System.currentTimeMillis() + timeout;
    }

    synchronized void expire() {
        this.expired = true;
        this.notifyAll();
    }

    TransactionID getTransactionID() {
        return this.transactionID;
    }

    boolean isReransmitting() {
        return this.isRetransmitting;
    }
}

