/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.stack;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.ResponseCollector;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.StunMessageEvent;
import net.java.stun4j.message.Message;
import net.java.stun4j.message.Request;
import net.java.stun4j.message.Response;
import net.java.stun4j.stack.EventDispatcher;
import net.java.stun4j.stack.MessageEventHandler;
import net.java.stun4j.stack.NetAccessManager;
import net.java.stun4j.stack.RequestListener;
import net.java.stun4j.stack.StunClientTransaction;
import net.java.stun4j.stack.StunServerTransaction;
import net.java.stun4j.stack.StunStack;
import net.java.stun4j.stack.TransactionID;

public class StunProvider
implements MessageEventHandler {
    private static final Logger logger = Logger.getLogger(StunProvider.class.getName());
    private Hashtable clientTransactions = new Hashtable();
    private Hashtable serverTransactions = new Hashtable();
    private StunStack stunStack = null;
    private EventDispatcher eventDispatcher = new EventDispatcher();

    StunProvider(StunStack stunStack) {
        this.stunStack = stunStack;
    }

    public void sendRequest(Request request, StunAddress sendTo, NetAccessPointDescriptor sendThrough, ResponseCollector collector) throws StunException {
        this.stunStack.checkStarted();
        StunClientTransaction clientTransaction = new StunClientTransaction(this, request, sendTo, sendThrough, collector);
        this.clientTransactions.put(clientTransaction.getTransactionID(), clientTransaction);
        clientTransaction.sendRequest();
    }

    public void sendResponse(byte[] transactionID, Response response, NetAccessPointDescriptor sendThrough, StunAddress sendTo) throws StunException {
        this.stunStack.checkStarted();
        TransactionID tid = TransactionID.createTransactionID(transactionID);
        StunServerTransaction sTran = (StunServerTransaction)this.serverTransactions.get(tid);
        if (sTran == null || sTran.isReransmitting()) {
            throw new StunException(3, "The transaction specified in the response object does not exist or has already transmitted a response.");
        }
        sTran.sendResponse(response, sendThrough, sendTo);
    }

    public void addRequestListener(RequestListener requestListener) {
        this.eventDispatcher.addRequestListener(requestListener);
    }

    public void removeRequestListener(RequestListener listener) {
        this.eventDispatcher.removeRequestListener(listener);
    }

    public synchronized void addRequestListener(NetAccessPointDescriptor apDescriptor, RequestListener listener) {
        this.eventDispatcher.addRequestListener(apDescriptor, listener);
    }

    NetAccessManager getNetAccessManager() {
        return this.stunStack.getNetAccessManager();
    }

    synchronized void removeClientTransaction(StunClientTransaction tran) {
        this.clientTransactions.remove(tran.getTransactionID());
    }

    synchronized void removeServerTransaction(StunServerTransaction tran) {
        this.serverTransactions.remove(tran.getTransactionID());
    }

    public void handleMessageEvent(StunMessageEvent event) {
        Message msg = event.getMessage();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Received a message on NetAP" + event.getSourceAccessPoint() + " of type:" + msg.getMessageType());
        }
        if (msg instanceof Request) {
            TransactionID serverTid = TransactionID.createTransactionID(msg.getTransactionID());
            StunServerTransaction sTran = (StunServerTransaction)this.serverTransactions.get(serverTid);
            if (sTran != null) {
                try {
                    sTran.retransmitResponse();
                    logger.finest("Response retransmitted");
                }
                catch (StunException ex) {
                    logger.log(Level.WARNING, "Failed to retransmit a stun response", ex);
                }
                String propagate = System.getProperty("net.java.stun4j.PROPAGATE_RECEIVED_RETRANSMISSIONS");
                if (propagate == null || !propagate.trim().equalsIgnoreCase("true")) {
                    return;
                }
            } else {
                sTran = new StunServerTransaction(this, serverTid);
                this.serverTransactions.put(serverTid, sTran);
                sTran.start();
            }
            this.eventDispatcher.fireMessageEvent(event);
        } else if (msg instanceof Response) {
            TransactionID tid = TransactionID.createTransactionID(msg.getTransactionID());
            StunClientTransaction tran = (StunClientTransaction)this.clientTransactions.remove(tid);
            if (tran != null) {
                tran.handleResponse(event);
            } else {
                logger.fine("Dropped response - no matching client tran found.");
                logger.fine("response tid was - " + tid.toString());
                logger.fine("all tids in stock were" + this.clientTransactions.toString());
            }
        }
    }

    void shutDown() {
        Runnable tran;
        TransactionID item;
        this.eventDispatcher.removeAllListeners();
        Enumeration tids = this.clientTransactions.keys();
        while (tids.hasMoreElements()) {
            item = (TransactionID)tids.nextElement();
            tran = (StunClientTransaction)this.clientTransactions.remove(item);
            if (tran == null) continue;
            ((StunClientTransaction)tran).cancel();
        }
        tids = this.serverTransactions.keys();
        while (tids.hasMoreElements()) {
            item = (TransactionID)tids.nextElement();
            tran = (StunServerTransaction)this.clientTransactions.remove(item);
            if (tran == null) continue;
            ((StunServerTransaction)tran).expire();
        }
    }
}

