/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.stack;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.ResponseCollector;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.StunMessageEvent;
import net.java.stun4j.message.Request;
import net.java.stun4j.stack.StunProvider;
import net.java.stun4j.stack.TransactionID;

class StunClientTransaction
implements Runnable {
    private static final Logger logger = Logger.getLogger(StunClientTransaction.class.getName());
    public static final int DEFAULT_MAX_RETRANSMISSIONS = 8;
    public int maxRetransmissions = 8;
    public static final int DEFAULT_ORIGINAL_WAIT_INTERVAL = 100;
    public int originalWaitInterval = 100;
    public static final int DEFAULT_MAX_WAIT_INTERVAL = 1600;
    public int maxWaitInterval = 1600;
    private int retransmissionsCounter = 0;
    private int lastWaitInterval = this.originalWaitInterval;
    private StunProvider providerCallback = null;
    private Request request = null;
    private StunAddress requestDestination = null;
    private TransactionID transactionID = null;
    private NetAccessPointDescriptor apDescriptor = null;
    private ResponseCollector responseCollector = null;
    private boolean cancelled = false;
    private long nextRetransmissionDate = -1L;
    private Thread runningThread = null;

    public StunClientTransaction(StunProvider providerCallback, Request request, StunAddress requestDestination, NetAccessPointDescriptor apDescriptor, ResponseCollector responseCollector) {
        this.providerCallback = providerCallback;
        this.request = request;
        this.apDescriptor = apDescriptor;
        this.responseCollector = responseCollector;
        this.requestDestination = requestDestination;
        this.initTransactionConfiguration();
        this.transactionID = TransactionID.createTransactionID();
        try {
            request.setTransactionID(this.transactionID.getTransactionID());
        }
        catch (StunException ex) {
            throw new IllegalArgumentException("The TransactionID class genereated an invalid transaction ID");
        }
        this.runningThread = new Thread(this);
    }

    public void run() {
        this.runningThread.setName("CliTran");
        while (this.retransmissionsCounter++ < this.maxRetransmissions) {
            this.waitUntilNextRetransmissionDate();
            if (this.cancelled) {
                return;
            }
            if (this.lastWaitInterval < this.maxWaitInterval) {
                this.lastWaitInterval *= 2;
            }
            try {
                this.providerCallback.getNetAccessManager().sendMessage(this.request, this.apDescriptor, this.requestDestination);
            }
            catch (StunException ex) {
                logger.log(Level.WARNING, "A client tran retransmission failed", ex);
            }
            this.schedule(this.lastWaitInterval);
        }
        if (this.lastWaitInterval < this.maxWaitInterval) {
            this.lastWaitInterval *= 2;
        }
        this.schedule(this.lastWaitInterval);
        this.waitUntilNextRetransmissionDate();
        this.responseCollector.processTimeout();
        this.providerCallback.removeClientTransaction(this);
    }

    void sendRequest() throws StunException {
        this.providerCallback.getNetAccessManager().sendMessage(this.request, this.apDescriptor, this.requestDestination);
        this.schedule(this.originalWaitInterval);
        this.runningThread.start();
    }

    Request getRequest() {
        return this.request;
    }

    synchronized void waitUntilNextRetransmissionDate() {
        long current = System.currentTimeMillis();
        while (this.nextRetransmissionDate - current > 0L) {
            try {
                this.wait(this.nextRetransmissionDate - current);
            }
            catch (InterruptedException ex) {
                logger.log(Level.FINE, "Interrupted", ex);
            }
            if (this.cancelled) {
                return;
            }
            current = System.currentTimeMillis();
        }
    }

    void schedule(long timeout) {
        this.nextRetransmissionDate = System.currentTimeMillis() + timeout;
    }

    synchronized void cancel() {
        this.cancelled = true;
        this.notifyAll();
    }

    void handleResponse(StunMessageEvent evt) {
        String keepTran = System.getProperty("net.java.stun4j.KEEP_CLIENT_TRANS_AFTER_A_RESPONSE");
        if (keepTran == null || !keepTran.trim().equalsIgnoreCase("true")) {
            this.cancel();
        }
        this.responseCollector.processResponse(evt);
    }

    TransactionID getTransactionID() {
        return this.transactionID;
    }

    private void initTransactionConfiguration() {
        String maxWaitIntervalStr;
        String originalWaitIntervalStr;
        String maxRetransmissionsStr = System.getProperty("net.java.stun4j.MAX_RETRANSMISSIONS");
        if (maxRetransmissionsStr != null && maxRetransmissionsStr.trim().length() > 0) {
            try {
                this.maxRetransmissions = Integer.parseInt(maxRetransmissionsStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.FINE, "Failed to parse MAX_RETRANSMISSIONS", e);
                this.maxRetransmissions = 8;
            }
        }
        if ((originalWaitIntervalStr = System.getProperty("net.java.stun4j.ORIGINAL_WAIT_INTERVAL")) != null && originalWaitIntervalStr.trim().length() > 0) {
            try {
                this.originalWaitInterval = Integer.parseInt(originalWaitIntervalStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.FINE, "Failed to parse ORIGINAL_WAIT_INTERVAL", e);
                this.originalWaitInterval = 100;
            }
        }
        if ((maxWaitIntervalStr = System.getProperty("net.java.stun4j.MAX_WAIT_INTERVAL")) != null && maxWaitIntervalStr.trim().length() > 0) {
            try {
                this.maxWaitInterval = Integer.parseInt(maxWaitIntervalStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.FINE, "Failed to parse MAX_WAIT_INTERVAL", e);
                this.maxWaitInterval = 1600;
            }
        }
    }
}

