/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.stack;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.logging.Logger;
import junit.framework.TestCase;
import net.java.stun4j.MsgFixture;
import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.ResponseCollector;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunMessageEvent;
import net.java.stun4j.message.MessageFactory;
import net.java.stun4j.message.Request;
import net.java.stun4j.message.Response;
import net.java.stun4j.stack.DatagramCollector;
import net.java.stun4j.stack.RequestListener;
import net.java.stun4j.stack.StunProvider;
import net.java.stun4j.stack.StunStack;

public class ShallowStackTest
extends TestCase {
    private static final Logger logger = Logger.getLogger(ShallowStackTest.class.getName());
    private StunProvider stunProvider = null;
    private StunStack stunStack = null;
    private MsgFixture msgFixture = null;
    private StunAddress stun4jAddressOfDummyImpl = null;
    private InetSocketAddress socketAddressOfStun4jStack = null;
    private DatagramCollector dgramCollector = new DatagramCollector();
    private NetAccessPointDescriptor apDescriptor = null;
    private DatagramSocket dummyImplSocket = null;
    private DatagramPacket bindingRequestPacket = new DatagramPacket(new byte[4096], 4096);

    public ShallowStackTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.msgFixture = new MsgFixture();
        this.msgFixture.setUp();
        this.stun4jAddressOfDummyImpl = new StunAddress(InetAddress.getByName("127.0.0.1"), 6000);
        this.socketAddressOfStun4jStack = new InetSocketAddress(InetAddress.getByName("127.0.0.1"), 5000);
        this.stunStack = StunStack.getInstance();
        this.stunStack.start();
        this.stunProvider = this.stunStack.getProvider();
        this.apDescriptor = new NetAccessPointDescriptor(new StunAddress(InetAddress.getByName("127.0.0.1"), 5000));
        this.stunStack.installNetAccessPoint(this.apDescriptor);
        this.dummyImplSocket = new DatagramSocket(6000);
    }

    protected void tearDown() throws Exception {
        this.msgFixture.tearDown();
        ShallowStackTest shallowStackTest = this;
        shallowStackTest.stunStack.shutDown();
        this.dummyImplSocket.close();
        this.msgFixture = null;
        super.tearDown();
    }

    public void testSendRequest() throws Exception {
        Request bindingRequest = MessageFactory.createBindingRequest();
        this.dgramCollector.startListening(this.dummyImplSocket);
        this.stunProvider.sendRequest(bindingRequest, this.stun4jAddressOfDummyImpl, this.apDescriptor, new SimpleResponseCollector());
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        DatagramPacket receivedPacket = this.dgramCollector.collectPacket();
        ShallowStackTest.assertTrue((String)"The stack did not properly send a Binding Request", (receivedPacket.getLength() > 0 ? 1 : 0) != 0);
        Request receivedRequest = (Request)Request.decode(receivedPacket.getData(), '\u0000', (char)receivedPacket.getLength());
        ShallowStackTest.assertEquals((String)"The received request did not match the one that was sent.", (Object)bindingRequest, (Object)receivedRequest);
        this.dgramCollector.startListening(this.dummyImplSocket);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        receivedPacket = this.dgramCollector.collectPacket();
        ShallowStackTest.assertTrue((String)"The stack did not retransmit a Binding Request", (receivedPacket.getLength() > 0 ? 1 : 0) != 0);
        receivedRequest = (Request)Request.decode(receivedPacket.getData(), '\u0000', (char)receivedPacket.getLength());
        ShallowStackTest.assertEquals((String)"The retransmitted request did not match the original.", (Object)bindingRequest, (Object)receivedRequest);
    }

    public void testReceiveRequest() throws Exception {
        SimpleRequestCollector requestCollector = new SimpleRequestCollector();
        this.stunProvider.addRequestListener(requestCollector);
        this.dummyImplSocket.send(new DatagramPacket(this.msgFixture.bindingRequest, this.msgFixture.bindingRequest.length, this.socketAddressOfStun4jStack));
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        Request collectedRequest = requestCollector.collectedRequest;
        ShallowStackTest.assertNotNull((String)"No request has been received", (Object)collectedRequest);
        byte[] expectedReturn = this.msgFixture.bindingRequest;
        byte[] actualReturn = collectedRequest.encode();
        ShallowStackTest.assertTrue((String)"Received request was not the same as the one that was sent", (boolean)Arrays.equals(expectedReturn, actualReturn));
    }

    public void testSendResponse() throws Exception {
        SimpleRequestCollector requestCollector = new SimpleRequestCollector();
        this.stunProvider.addRequestListener(requestCollector);
        this.dummyImplSocket.send(new DatagramPacket(this.msgFixture.bindingRequest, this.msgFixture.bindingRequest.length, this.socketAddressOfStun4jStack));
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        Request collectedRequest = requestCollector.collectedRequest;
        byte[] expectedReturn = this.msgFixture.bindingRequest;
        byte[] actualReturn = collectedRequest.encode();
        ShallowStackTest.assertTrue((String)"Received request was not the same as the one that was sent", (boolean)Arrays.equals(expectedReturn, actualReturn));
        Response bindingResponse = MessageFactory.createBindingResponse(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, 1904), new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_2, 3478), new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_3, 3479));
        this.dgramCollector.startListening(this.dummyImplSocket);
        this.stunProvider.sendResponse(collectedRequest.getTransactionID(), bindingResponse, this.apDescriptor, this.stun4jAddressOfDummyImpl);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        DatagramPacket receivedPacket = this.dgramCollector.collectPacket();
        ShallowStackTest.assertTrue((String)"The stack did not properly send a Binding Request", (receivedPacket.getLength() > 0 ? 1 : 0) != 0);
        Response receivedResponse = (Response)Response.decode(receivedPacket.getData(), '\u0000', (char)receivedPacket.getLength());
        ShallowStackTest.assertEquals((String)"The received request did not match the one that was sent.", (Object)bindingResponse, (Object)receivedResponse);
    }

    public void testReceiveResponse() throws Exception {
        SimpleResponseCollector collector = new SimpleResponseCollector();
        Request bindingRequest = MessageFactory.createBindingRequest();
        this.stunProvider.sendRequest(bindingRequest, this.stun4jAddressOfDummyImpl, this.apDescriptor, collector);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        byte[] response = new byte[this.msgFixture.bindingResponse.length];
        System.arraycopy(this.msgFixture.bindingResponse, 0, response, 0, response.length);
        System.arraycopy(bindingRequest.getTransactionID(), 0, response, 4, 16);
        this.dummyImplSocket.send(new DatagramPacket(response, response.length, this.socketAddressOfStun4jStack));
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        Response collectedResponse = collector.collectedResponse;
        byte[] expectedReturn = response;
        byte[] actualReturn = collectedResponse.encode();
        ShallowStackTest.assertTrue((String)"Received request was not the same as the one that was sent", (boolean)Arrays.equals(expectedReturn, actualReturn));
    }

    public class SimpleRequestCollector
    implements RequestListener {
        Request collectedRequest = null;

        public void requestReceived(StunMessageEvent evt) {
            this.collectedRequest = (Request)evt.getMessage();
            logger.info("Received request.");
        }
    }

    public class SimpleResponseCollector
    implements ResponseCollector {
        Response collectedResponse = null;

        public void processResponse(StunMessageEvent evt) {
            this.collectedResponse = (Response)evt.getMessage();
            logger.info("Received response.");
        }

        public void processTimeout() {
            logger.info("Timeout");
        }
    }
}

