/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.stack;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.StunAddress;
import net.java.stun4j.stack.ErrorHandler;
import net.java.stun4j.stack.MessageQueue;
import net.java.stun4j.stack.RawMessage;

class NetAccessPoint
implements Runnable {
    private static final Logger logger = Logger.getLogger(NetAccessPoint.class.getName());
    private static final int MAX_DATAGRAM_SIZE = 8192;
    private MessageQueue messageQueue = null;
    protected DatagramSocket sock;
    private boolean isUsingExternalSocket = false;
    private boolean isRunning;
    private NetAccessPointDescriptor apDescriptor = null;
    private ErrorHandler errorHandler = null;
    private Object socketLock = new Object();

    NetAccessPoint() {
    }

    NetAccessPoint(NetAccessPointDescriptor apDescriptor, MessageQueue messageQueue, ErrorHandler errorHandler) {
        this.apDescriptor = apDescriptor;
        this.messageQueue = messageQueue;
        this.errorHandler = errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() throws IOException {
        Object object = this.socketLock;
        synchronized (object) {
            if (this.sock == null) {
                this.sock = new DatagramSocket(this.getDescriptor().getAddress().getSocketAddress());
                this.isUsingExternalSocket = false;
                logger.info("Bound a socket on ap: " + this.toString());
            }
            this.sock.setReceiveBufferSize(8192);
            this.isRunning = true;
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    NetAccessPointDescriptor getDescriptor() {
        return this.apDescriptor;
    }

    public void run() {
        while (this.isRunning) {
            try {
                int bufsize = this.sock.getReceiveBufferSize();
                byte[] message = new byte[bufsize];
                DatagramPacket packet = new DatagramPacket(message, bufsize);
                this.sock.receive(packet);
                RawMessage rawMessage = new RawMessage(message, packet.getLength(), packet.getAddress(), packet.getPort(), this.getDescriptor());
                this.messageQueue.add(rawMessage);
            }
            catch (SocketException ex) {
                if (!this.isRunning) continue;
                logger.log(Level.WARNING, "A net access point has gone useless:", ex);
                this.stop();
                this.errorHandler.handleFatalError(this, "A socket exception was thrown while trying to receive a message.", ex);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "A net access point has gone useless:", ex);
                this.errorHandler.handleError(ex.getMessage(), ex);
            }
            catch (Throwable ex) {
                logger.log(Level.WARNING, "A net access point has gone useless:", ex);
                this.stop();
                this.errorHandler.handleFatalError(this, "Unknown error occurred while listening for messages!", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void stop() {
        this.isRunning = false;
        if (this.sock != null && !this.isUsingExternalSocket) {
            Object object = this.socketLock;
            synchronized (object) {
                this.sock.close();
                logger.info("Closed socket on ap " + this.toString());
                this.sock = null;
                String hardSocketClose = System.getProperty("net.java.stun4j.stack.HARD_SOCK_CLOSE");
                if (hardSocketClose == null || hardSocketClose.equalsIgnoreCase("true")) {
                    int waitForSockClose;
                    block10: {
                        waitForSockClose = 200;
                        try {
                            String waitForSockCloseStr = System.getProperty("net.java.stun4j.stack.WAIT_FOR_SOCK_CLOSE");
                            if (waitForSockCloseStr != null && waitForSockCloseStr.length() > 0) {
                                waitForSockClose = Integer.parseInt(System.getProperty(waitForSockCloseStr));
                            }
                        }
                        catch (Throwable t) {
                            logger.log(Level.WARNING, "Failed to parse wait_for_sock_close prop", t);
                            if (waitForSockClose >= 0) break block10;
                            waitForSockClose = 200;
                        }
                    }
                    try {
                        this.wait(waitForSockClose);
                    }
                    catch (InterruptedException t) {
                        logger.warning("Interrupted waiting for sock close.");
                    }
                    System.gc();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMessage(byte[] message, StunAddress address) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(message, 0, message.length, address.getSocketAddress());
        Object object = this.socketLock;
        synchronized (object) {
            this.sock.send(datagramPacket);
        }
    }

    public String toString() {
        return "net.java.stun4j.stack.AccessPoint@" + this.apDescriptor.getAddress() + " status: " + (this.isRunning ? "not" : "") + " running";
    }

    void useExternalSocket(DatagramSocket socket) {
        this.sock = socket;
        this.isUsingExternalSocket = true;
    }
}

