/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.stack;

import java.io.IOException;
import java.net.DatagramSocket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.message.Message;
import net.java.stun4j.stack.ErrorHandler;
import net.java.stun4j.stack.MessageEventHandler;
import net.java.stun4j.stack.MessageProcessor;
import net.java.stun4j.stack.MessageQueue;
import net.java.stun4j.stack.NetAccessPoint;

class NetAccessManager
implements ErrorHandler {
    private static final Logger logger = Logger.getLogger(NetAccessManager.class.getName());
    private Hashtable netAccessPoints = new Hashtable();
    private MessageQueue messageQueue = new MessageQueue();
    private Vector messageProcessors = new Vector();
    private MessageEventHandler messageEventHandler = null;
    private boolean isRunning = false;
    private int initialThreadPoolSize = 5;

    NetAccessManager() {
    }

    synchronized void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.initThreadPool();
    }

    void shutDown() {
        if (!this.isRunning) {
            return;
        }
        logger.info("removing " + this.netAccessPoints.size() + " access points.");
        Enumeration keys = this.netAccessPoints.keys();
        while (keys.hasMoreElements()) {
            NetAccessPointDescriptor apd = (NetAccessPointDescriptor)keys.nextElement();
            this.removeNetAccessPoint(apd);
            logger.info(".");
        }
        logger.info("removed all access points");
        while (!this.messageProcessors.isEmpty()) {
            MessageProcessor mp = (MessageProcessor)this.messageProcessors.remove(0);
            mp.stop();
        }
        this.isRunning = false;
    }

    boolean isRunning() {
        return this.isRunning;
    }

    void setEventHandler(MessageEventHandler evtHandler) {
        this.messageEventHandler = evtHandler;
    }

    public void handleError(String message, Throwable error) {
        logger.log(Level.WARNING, "The following error occurred", error);
    }

    public void handleFatalError(Runnable callingThread, String message, Throwable error) {
        if (callingThread instanceof NetAccessPoint) {
            NetAccessPoint ap = (NetAccessPoint)callingThread;
            this.removeNetAccessPoint(ap.getDescriptor());
            try {
                logger.log(Level.WARNING, "An access point has unexpectedly stopped. AP:" + ap.toString(), error);
                this.installNetAccessPoint(ap.getDescriptor());
            }
            catch (StunException ex) {
                this.removeNetAccessPoint(ap.getDescriptor());
                logger.log(Level.WARNING, "Failed to relaunch accesspoint:" + ap, ex);
            }
        } else if (callingThread instanceof MessageProcessor) {
            MessageProcessor mp = (MessageProcessor)callingThread;
            logger.log(Level.WARNING, "A message processor has unexpectedly stopped. AP:" + mp.toString(), error);
            mp.stop();
            this.messageProcessors.remove(mp);
            mp = new MessageProcessor(this.messageQueue, this.messageEventHandler, this);
            mp.start();
            logger.fine("A message processor has been relaunched because of an error.");
        }
    }

    void installNetAccessPoint(NetAccessPointDescriptor apDescriptor) throws StunException {
        if (this.netAccessPoints.containsKey(apDescriptor)) {
            return;
        }
        NetAccessPoint ap = new NetAccessPoint(apDescriptor, this.messageQueue, this);
        this.netAccessPoints.put(apDescriptor, ap);
        try {
            ap.start();
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "The NAPD(" + ap + ") failed to bind ", ex);
            throw new StunException(4, "An IOException occurred while starting access point: " + apDescriptor.toString(), ex);
        }
    }

    NetAccessPointDescriptor installNetAccessPoint(DatagramSocket socket) throws StunException {
        StunAddress address = new StunAddress(socket.getLocalAddress(), socket.getLocalPort());
        NetAccessPointDescriptor apDescriptor = new NetAccessPointDescriptor(address);
        if (this.netAccessPoints.containsKey(apDescriptor)) {
            return apDescriptor;
        }
        NetAccessPoint ap = new NetAccessPoint(apDescriptor, this.messageQueue, this);
        ap.useExternalSocket(socket);
        this.netAccessPoints.put(apDescriptor, ap);
        try {
            ap.start();
        }
        catch (IOException ex) {
            throw new StunException(4, "An IOException occurred while starting the access point", ex);
        }
        return apDescriptor;
    }

    void removeNetAccessPoint(NetAccessPointDescriptor apDescriptor) {
        NetAccessPoint ap = (NetAccessPoint)this.netAccessPoints.remove(apDescriptor);
        if (ap != null) {
            ap.stop();
        }
    }

    void setThreadPoolSize(int threadPoolSize) throws StunException {
        if (threadPoolSize < 1) {
            throw new StunException(2, threadPoolSize + " is not a legal thread pool size value.");
        }
        if (!this.isRunning) {
            this.initialThreadPoolSize = threadPoolSize;
            return;
        }
        if (this.messageProcessors.size() < threadPoolSize) {
            this.fillUpThreadPool(threadPoolSize);
        } else {
            this.shrinkThreadPool(threadPoolSize);
        }
    }

    private void initThreadPool() {
        this.fillUpThreadPool(this.initialThreadPoolSize);
    }

    private void fillUpThreadPool(int newSize) {
        this.messageProcessors.ensureCapacity(newSize);
        for (int i = this.messageProcessors.size(); i < newSize; ++i) {
            MessageProcessor mp = new MessageProcessor(this.messageQueue, this.messageEventHandler, this);
            this.messageProcessors.add(mp);
            mp.start();
        }
    }

    private void shrinkThreadPool(int newSize) {
        while (this.messageProcessors.size() > newSize) {
            MessageProcessor mp = (MessageProcessor)this.messageProcessors.remove(0);
            mp.stop();
        }
    }

    void sendMessage(Message stunMessage, NetAccessPointDescriptor apDescriptor, StunAddress address) throws StunException {
        byte[] bytes = stunMessage.encode();
        NetAccessPoint ap = (NetAccessPoint)this.netAccessPoints.get(apDescriptor);
        if (ap == null) {
            throw new StunException(2, "The specified access point had not been installed.");
        }
        try {
            ap.sendMessage(bytes, address);
        }
        catch (Exception ex) {
            throw new StunException(4, "An Exception occurred while sending message bytes through a network socket!", ex);
        }
    }
}

