/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.stack;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.StunMessageEvent;
import net.java.stun4j.stack.RequestListener;

public class EventDispatcher {
    private Vector requestListeners;
    private Hashtable requestListenersChildren;

    public synchronized void addRequestListener(RequestListener listener) {
        if (this.requestListeners == null) {
            this.requestListeners = new Vector();
        }
        this.requestListeners.addElement(listener);
    }

    public synchronized void addRequestListener(NetAccessPointDescriptor descriptor, RequestListener listener) {
        EventDispatcher child;
        if (this.requestListenersChildren == null) {
            this.requestListenersChildren = new Hashtable();
        }
        if ((child = (EventDispatcher)this.requestListenersChildren.get(descriptor)) == null) {
            child = new EventDispatcher();
            this.requestListenersChildren.put(descriptor, child);
        }
        child.addRequestListener(listener);
    }

    public synchronized void removeRequestListener(RequestListener listener) {
        if (this.requestListeners == null) {
            return;
        }
        this.requestListeners.removeElement(listener);
    }

    public synchronized void removeRequestListener(NetAccessPointDescriptor apDescriptor, RequestListener listener) {
        if (this.requestListenersChildren == null) {
            return;
        }
        EventDispatcher child = (EventDispatcher)this.requestListenersChildren.get(apDescriptor);
        if (child == null) {
            return;
        }
        child.removeRequestListener(listener);
    }

    public void fireMessageEvent(StunMessageEvent evt) {
        NetAccessPointDescriptor apDescriptor = evt.getSourceAccessPoint();
        if (this.requestListeners != null) {
            Iterator iterator = this.requestListeners.iterator();
            while (iterator.hasNext()) {
                RequestListener target = (RequestListener)iterator.next();
                target.requestReceived(evt);
            }
        }
        if (this.requestListenersChildren != null && apDescriptor != null) {
            EventDispatcher child = (EventDispatcher)this.requestListenersChildren.get(apDescriptor);
            apDescriptor.getAddress().toString();
            Enumeration enumer = this.requestListenersChildren.elements();
            while (enumer.hasMoreElements()) {
                Object item = enumer.nextElement();
            }
            if (child != null) {
                child.fireMessageEvent(evt);
            }
        }
    }

    public synchronized boolean hasRequestListeners(NetAccessPointDescriptor apDescriptor) {
        EventDispatcher child;
        if (this.requestListeners != null && !this.requestListeners.isEmpty()) {
            return true;
        }
        if (this.requestListenersChildren != null && (child = (EventDispatcher)this.requestListenersChildren.get(apDescriptor)) != null && child.requestListeners != null) {
            return !child.requestListeners.isEmpty();
        }
        return false;
    }

    public void removeAllListeners() {
        if (this.requestListeners != null) {
            this.requestListeners.removeAllElements();
        }
        this.requestListenersChildren = null;
    }
}

