/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.message;

import junit.framework.TestCase;
import net.java.stun4j.MsgFixture;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.attribute.AttributeFactory;
import net.java.stun4j.attribute.ChangeRequestAttribute;
import net.java.stun4j.attribute.ChangedAddressAttribute;
import net.java.stun4j.attribute.ErrorCodeAttribute;
import net.java.stun4j.attribute.MappedAddressAttribute;
import net.java.stun4j.attribute.SourceAddressAttribute;
import net.java.stun4j.attribute.UnknownAttributesAttribute;
import net.java.stun4j.message.MessageFactory;
import net.java.stun4j.message.Request;
import net.java.stun4j.message.Response;

public class MessageFactoryTest
extends TestCase {
    private MessageFactory messageFactory = null;
    private MsgFixture msgFixture;

    public MessageFactoryTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.messageFactory = new MessageFactory();
        this.msgFixture = new MsgFixture();
        this.msgFixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.messageFactory = null;
        this.msgFixture.tearDown();
        this.msgFixture = null;
        super.tearDown();
    }

    public void testCreateBindingErrorResponse() throws StunException {
        char errorCode = '\u0190';
        Response expectedReturn = new Response();
        expectedReturn.setMessageType('\u0111');
        ErrorCodeAttribute errorCodeAtt = AttributeFactory.createErrorCodeAttribute(errorCode);
        expectedReturn.addAttribute(errorCodeAtt);
        Response actualReturn = MessageFactory.createBindingErrorResponse(errorCode);
        MessageFactoryTest.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testCreateBindingErrorResponse1() throws StunException {
        char errorCode = '\u0190';
        String reasonPhrase = "Bad Request";
        Response expectedReturn = new Response();
        expectedReturn.setMessageType('\u0111');
        ErrorCodeAttribute errorCodeAtt = AttributeFactory.createErrorCodeAttribute(errorCode, reasonPhrase);
        expectedReturn.addAttribute(errorCodeAtt);
        Response actualReturn = MessageFactory.createBindingErrorResponse(errorCode, reasonPhrase);
        MessageFactoryTest.assertEquals((String)"Failed to create an error code attribute.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testCreateBindingErrorResponseUnknownAttributes() throws StunException {
        char errorCode = '\u01a4';
        char[] unknownAttributes = new char[]{'\u0015', '\u0016', '\u0017'};
        Response expectedReturn = new Response();
        expectedReturn.setMessageType('\u0111');
        ErrorCodeAttribute errorCodeAtt = AttributeFactory.createErrorCodeAttribute(errorCode);
        errorCodeAtt.setReasonPhrase(ErrorCodeAttribute.getDefaultReasonPhrase(errorCode));
        expectedReturn.addAttribute(errorCodeAtt);
        UnknownAttributesAttribute unknownAtts = AttributeFactory.createUnknownAttributesAttribute();
        for (int i = 0; i < unknownAttributes.length; ++i) {
            unknownAtts.addAttributeID(unknownAttributes[i]);
        }
        expectedReturn.addAttribute(unknownAtts);
        Response actualReturn = MessageFactory.createBindingErrorResponseUnknownAttributes(unknownAttributes);
        MessageFactoryTest.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testCreateBindingErrorResponseUnknownAttributes1() throws StunException {
        char errorCode = '\u01a4';
        String reasonPhrase = "UnknwonAttributes";
        char[] unknownAttributes = new char[]{'\u0015', '\u0016', '\u0017'};
        Response expectedReturn = new Response();
        expectedReturn.setMessageType('\u0111');
        ErrorCodeAttribute errorCodeAtt = AttributeFactory.createErrorCodeAttribute(errorCode, reasonPhrase);
        expectedReturn.addAttribute(errorCodeAtt);
        UnknownAttributesAttribute unknownAtts = AttributeFactory.createUnknownAttributesAttribute();
        for (int i = 0; i < unknownAttributes.length; ++i) {
            unknownAtts.addAttributeID(unknownAttributes[i]);
        }
        expectedReturn.addAttribute(unknownAtts);
        Response actualReturn = MessageFactory.createBindingErrorResponseUnknownAttributes(reasonPhrase, unknownAttributes);
        MessageFactoryTest.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testCreateBindingRequest() throws StunException {
        Request bindingRequest;
        Request expectedReturn = bindingRequest = new Request();
        bindingRequest.setMessageType('\u0001');
        ChangeRequestAttribute changeRequest = AttributeFactory.createChangeRequestAttribute(false, false);
        bindingRequest.addAttribute(changeRequest);
        MessageFactoryTest messageFactoryTest = this;
        Request actualReturn = messageFactoryTest.messageFactory.createBindingRequest();
        MessageFactoryTest.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testCreateBindingResponse() throws StunException {
        Response bindingResponse = new Response();
        bindingResponse.setMessageType('\u0101');
        MappedAddressAttribute mappedAddress = AttributeFactory.createMappedAddressAttribute(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, 1904));
        bindingResponse.addAttribute(mappedAddress);
        SourceAddressAttribute sourceAddress = AttributeFactory.createSourceAddressAttribute(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_2, 3478));
        bindingResponse.addAttribute(sourceAddress);
        ChangedAddressAttribute changedAddress = AttributeFactory.createChangedAddressAttribute(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_3, 3479));
        bindingResponse.addAttribute(changedAddress);
        Response expectedReturn = bindingResponse;
        Response actualReturn = MessageFactory.createBindingResponse(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, 1904), new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_2, 3478), new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_3, 3479));
        MessageFactoryTest.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }
}

