/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.message;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.attribute.AttributeFactory;
import net.java.stun4j.attribute.ChangeRequestAttribute;
import net.java.stun4j.attribute.ChangedAddressAttribute;
import net.java.stun4j.attribute.ErrorCodeAttribute;
import net.java.stun4j.attribute.MappedAddressAttribute;
import net.java.stun4j.attribute.SourceAddressAttribute;
import net.java.stun4j.attribute.UnknownAttributesAttribute;
import net.java.stun4j.message.Request;
import net.java.stun4j.message.Response;

public class MessageFactory {
    private static final Logger logger = Logger.getLogger(MessageFactory.class.getName());

    public static Request createBindingRequest() {
        Request bindingRequest = new Request();
        try {
            bindingRequest.setMessageType('\u0001');
        }
        catch (StunException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        ChangeRequestAttribute attribute = AttributeFactory.createChangeRequestAttribute();
        try {
            bindingRequest.addAttribute(attribute);
        }
        catch (StunException ex) {
            throw new RuntimeException("Failed to add a change request attribute to a binding request!");
        }
        return bindingRequest;
    }

    public static Response createBindingResponse(StunAddress mappedAddress, StunAddress sourceAddress, StunAddress changedAddress) throws StunException {
        Response bindingResponse = new Response();
        bindingResponse.setMessageType('\u0101');
        MappedAddressAttribute mappedAddressAttribute = AttributeFactory.createMappedAddressAttribute(mappedAddress);
        SourceAddressAttribute sourceAddressAttribute = AttributeFactory.createSourceAddressAttribute(sourceAddress);
        ChangedAddressAttribute changedAddressAttribute = AttributeFactory.createChangedAddressAttribute(changedAddress);
        try {
            bindingResponse.addAttribute(mappedAddressAttribute);
            bindingResponse.addAttribute(sourceAddressAttribute);
            bindingResponse.addAttribute(changedAddressAttribute);
        }
        catch (StunException ex) {
            throw new StunException(3, "Failed to add a mandatory attribute to the binding response.");
        }
        return bindingResponse;
    }

    private static Response createBindingErrorResponse(char errorCode, String reasonPhrase, char[] unknownAttributes) throws StunException {
        Response bindingErrorResponse = new Response();
        bindingErrorResponse.setMessageType('\u0111');
        UnknownAttributesAttribute unknownAttributesAttribute = null;
        ErrorCodeAttribute errorCodeAttribute = AttributeFactory.createErrorCodeAttribute(errorCode, reasonPhrase);
        bindingErrorResponse.addAttribute(errorCodeAttribute);
        if (unknownAttributes != null) {
            unknownAttributesAttribute = AttributeFactory.createUnknownAttributesAttribute();
            for (int i = 0; i < unknownAttributes.length; ++i) {
                unknownAttributesAttribute.addAttributeID(unknownAttributes[i]);
            }
            bindingErrorResponse.addAttribute(unknownAttributesAttribute);
        }
        return bindingErrorResponse;
    }

    public static Response createBindingErrorResponseUnknownAttributes(char[] unknownAttributes) throws StunException {
        return MessageFactory.createBindingErrorResponse('\u01a4', null, unknownAttributes);
    }

    public static Response createBindingErrorResponseUnknownAttributes(String reasonPhrase, char[] unknownAttributes) throws StunException {
        return MessageFactory.createBindingErrorResponse('\u01a4', reasonPhrase, unknownAttributes);
    }

    public static Response createBindingErrorResponse(char errorCode, String reasonPhrase) throws StunException {
        return MessageFactory.createBindingErrorResponse(errorCode, reasonPhrase, null);
    }

    public static Response createBindingErrorResponse(char errorCode) throws StunException {
        return MessageFactory.createBindingErrorResponse(errorCode, null, null);
    }

    public static Request createShareSecretRequest() {
        throw new UnsupportedOperationException("Shared Secret Support is not currently impolemented");
    }

    public static Response createSharedSecretResponse() {
        throw new UnsupportedOperationException("Shared Secret Support is not currently impolemented");
    }

    public static Response createSharedSecretErrorResponse() {
        throw new UnsupportedOperationException("Shared Secret Support is not currently impolemented");
    }
}

