/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.message;

import java.util.Iterator;
import java.util.LinkedHashMap;
import net.java.stun4j.StunException;
import net.java.stun4j.attribute.Attribute;
import net.java.stun4j.attribute.AttributeDecoder;
import net.java.stun4j.message.Request;
import net.java.stun4j.message.Response;

public abstract class Message {
    public static final char BINDING_REQUEST = '\u0001';
    public static final char BINDING_RESPONSE = '\u0101';
    public static final char BINDING_ERROR_RESPONSE = '\u0111';
    public static final char SHARED_SECRET_REQUEST = '\u0002';
    public static final char SHARED_SECRET_RESPONSE = '\u0102';
    public static final char SHARED_SECRET_ERROR_RESPONSE = '\u0112';
    public static final byte HEADER_LENGTH = 20;
    protected char messageType = '\u0000';
    protected byte[] transactionID = null;
    public static final byte TRANSACTION_ID_LENGTH = 16;
    protected LinkedHashMap attributes = new LinkedHashMap();
    public static final byte N_A = 0;
    public static final byte C = 1;
    public static final byte O = 2;
    public static final byte M = 3;
    protected static final byte BINDING_REQUEST_PRESENTITY_INDEX = 0;
    protected static final byte BINDING_RESPONSE_PRESENTITY_INDEX = 1;
    protected static final byte BINDING_ERROR_RESPONSE_PRESENTITY_INDEX = 2;
    protected static final byte SHARED_SECRET_REQUEST_PRESENTITY_INDEX = 3;
    protected static final byte SHARED_SECRET_RESPONSE_PRESENTITY_INDEX = 4;
    protected static final byte SHARED_SECRET_ERROR_RESPONSE_PRESENTITY_INDEX = 5;
    protected static final byte MAPPED_ADDRESS_PRESENTITY_INDEX = 0;
    protected static final byte RESPONSE_ADDRESS_PRESENTITY_INDEX = 1;
    protected static final byte CHANGE_REQUEST_PRESENTITY_INDEX = 2;
    protected static final byte SOURCE_ADDRESS_PRESENTITY_INDEX = 3;
    protected static final byte CHANGED_ADDRESS_PRESENTITY_INDEX = 4;
    protected static final byte USERNAME_PRESENTITY_INDEX = 5;
    protected static final byte PASSWORD_PRESENTITY_INDEX = 6;
    protected static final byte MESSAGE_INTEGRITY_PRESENTITY_INDEX = 7;
    protected static final byte ERROR_CODE_PRESENTITY_INDEX = 8;
    protected static final byte UNKNOWN_ATTRIBUTES_PRESENTITY_INDEX = 9;
    protected static final byte REFLECTED_FROM_PRESENTITY_INDEX = 10;
    protected static final byte XOR_MAPPED_ADDRESS_PRESENTITY_INDEX = 11;
    protected static final byte XOR_ONLY_PRESENTITY_INDEX = 12;
    protected static final byte SERVER_PRESENTITY_INDEX = 13;
    protected static final byte UNKNOWN_OPTIONAL_ATTRIBUTES_PRESENTITY_INDEX = 14;
    protected static final byte[][] attributePresentities = new byte[][]{{0, 3, 0, 0, 0, 0}, {2, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 0, 0}, {0, 3, 0, 0, 0, 0}, {0, 3, 0, 0, 0, 0}, {2, 0, 0, 0, 3, 0}, {0, 0, 0, 0, 3, 0}, {2, 2, 0, 0, 0, 0}, {0, 0, 3, 0, 0, 3}, {0, 0, 1, 0, 0, 1}, {0, 1, 0, 0, 0, 0}, {0, 3, 0, 0, 0, 0}, {2, 0, 0, 0, 0, 0}, {0, 2, 2, 0, 2, 2}, {2, 2, 2, 2, 2, 2}};

    protected Message() {
    }

    public char getDataLength() {
        char length = '\u0000';
        Attribute att = null;
        Iterator iter = this.attributes.entrySet().iterator();
        while (iter.hasNext()) {
            att = (Attribute)iter.next().getValue();
            length = (char)(length + (att.getDataLength() + 4));
        }
        return length;
    }

    public void addAttribute(Attribute attribute) throws StunException {
        Character attributeType = new Character(attribute.getAttributeType());
        if (this.getAttributePresentity(attributeType.charValue()) == 0) {
            throw new StunException(2, "The attribute " + attribute.getName() + " is not allowed in a " + this.getName());
        }
        this.attributes.put(attributeType, attribute);
    }

    public Attribute getAttribute(char attributeType) {
        return (Attribute)this.attributes.get(new Character(attributeType));
    }

    public void removeAttribute(char attributeType) {
        this.attributes.remove(new Character(attributeType));
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    protected void setMessageType(char messageType) throws StunException {
        this.messageType = messageType;
    }

    public char getMessageType() {
        return this.messageType;
    }

    public void setTransactionID(byte[] tranID) throws StunException {
        if (tranID == null || tranID.length != 16) {
            throw new StunException(2, "Invalid transaction id");
        }
        this.transactionID = new byte[16];
        System.arraycopy(tranID, 0, this.transactionID, 0, 16);
    }

    public byte[] getTransactionID() {
        return this.transactionID;
    }

    protected byte getAttributePresentity(char attributeType) {
        int msgIndex = -1;
        int attributeIndex = -1;
        switch (this.messageType) {
            case '\u0001': {
                msgIndex = 0;
                break;
            }
            case '\u0101': {
                msgIndex = 1;
                break;
            }
            case '\u0111': {
                msgIndex = 2;
                break;
            }
            case '\u0002': {
                msgIndex = 3;
                break;
            }
            case '\u0102': {
                msgIndex = 4;
                break;
            }
            case '\u0112': {
                msgIndex = 5;
            }
        }
        switch (attributeType) {
            case '\u0001': {
                attributeIndex = 0;
                break;
            }
            case '\u0002': {
                attributeIndex = 1;
                break;
            }
            case '\u0003': {
                attributeIndex = 2;
                break;
            }
            case '\u0004': {
                attributeIndex = 3;
                break;
            }
            case '\u0005': {
                attributeIndex = 4;
                break;
            }
            case '\u0006': {
                attributeIndex = 5;
                break;
            }
            case '\u0007': {
                attributeIndex = 6;
                break;
            }
            case '\b': {
                attributeIndex = 7;
                break;
            }
            case '\t': {
                attributeIndex = 8;
                break;
            }
            case '\n': {
                attributeIndex = 9;
                break;
            }
            case '\u000b': {
                attributeIndex = 10;
                break;
            }
            case '\u8020': {
                attributeIndex = 11;
                break;
            }
            case '!': {
                attributeIndex = 12;
                break;
            }
            case '\u8022': {
                attributeIndex = 13;
                break;
            }
            default: {
                attributeIndex = 14;
            }
        }
        return attributePresentities[attributeIndex][msgIndex];
    }

    public String getName() {
        switch (this.messageType) {
            case '\u0001': {
                return "BINDING-REQUEST";
            }
            case '\u0101': {
                return "BINDING-RESPONSE";
            }
            case '\u0111': {
                return "BINDING-ERROR-RESPONSE";
            }
            case '\u0002': {
                return "SHARED-SECRET-REQUEST";
            }
            case '\u0102': {
                return "SHARED-SECRET-RESPONSE";
            }
            case '\u0112': {
                return "SHARED-SECRET-ERROR-RESPONSE";
            }
        }
        return "UNKNOWN-MESSAGE";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Message) || obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Message msg = (Message)obj;
        if (msg.getMessageType() != this.getMessageType()) {
            return false;
        }
        if (msg.getDataLength() != this.getDataLength()) {
            return false;
        }
        Iterator iter = this.attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Attribute localAtt = (Attribute)iter.next().getValue();
            if (localAtt.equals(msg.getAttribute(localAtt.getAttributeType()))) continue;
            return false;
        }
        return true;
    }

    public byte[] encode() throws StunException {
        this.validateAttributePresentity();
        char dataLength = this.getDataLength();
        byte[] binMsg = new byte[20 + dataLength];
        int offset = 0;
        binMsg[offset++] = (byte)(this.getMessageType() >> 8);
        binMsg[offset++] = (byte)(this.getMessageType() & 0xFF);
        binMsg[offset++] = (byte)(dataLength >> 8);
        binMsg[offset++] = (byte)(dataLength & 0xFF);
        System.arraycopy(this.getTransactionID(), 0, binMsg, offset, 16);
        offset += 16;
        Iterator iter = this.attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Attribute attribute = (Attribute)iter.next().getValue();
            byte[] attBinValue = attribute.encode();
            System.arraycopy(attBinValue, 0, binMsg, offset, attBinValue.length);
            offset += attBinValue.length;
        }
        return binMsg;
    }

    public static Message decode(byte[] binMessage, char offset, char arrayLen) throws StunException {
        arrayLen = (char)Math.min(binMessage.length, arrayLen);
        if (binMessage == null || arrayLen - offset < 20) {
            throw new StunException(2, "The given binary array is not a valid StunMessage");
        }
        char c = offset;
        char c2 = offset = (char)(offset + '\u0001');
        offset = (char)(offset + '\u0001');
        char messageType = (char)(binMessage[c] << 8 | binMessage[c2] & 0xFF);
        Message message = Message.isResponseType(messageType) ? new Response() : new Request();
        message.setMessageType(messageType);
        char c3 = offset;
        char c4 = offset = (char)(offset + '\u0001');
        offset = (char)(offset + '\u0001');
        char length = (char)(binMessage[c3] << 8 | binMessage[c4] & 0xFF);
        if (arrayLen - offset - 16 < length) {
            throw new StunException(2, "The given binary array does not seem to contain a whole StunMessage");
        }
        byte[] tranID = new byte[16];
        System.arraycopy(binMessage, offset, tranID, 0, 16);
        message.setTransactionID(tranID);
        offset = (char)(offset + 16);
        while (offset - 20 < length) {
            Attribute att = AttributeDecoder.decode(binMessage, offset, (char)(length - offset));
            message.addAttribute(att);
            offset = (char)(offset + (att.getDataLength() + 4));
        }
        return message;
    }

    protected void validateAttributePresentity() throws StunException {
        for (char i = '\u0001'; i < '\u000b'; i = (char)(i + '\u0001')) {
            if (this.getAttributePresentity(i) != 3 || this.getAttribute(i) != null) continue;
            throw new StunException(1, "A mandatory attribute (type=" + i + ") is missing!");
        }
    }

    public static boolean isResponseType(char type) {
        return (type >> 8 & 1) != 0;
    }

    public static boolean isRequestType(char type) {
        return !Message.isResponseType(type);
    }

    public String toString() {
        return this.getName() + "(" + this.getMessageType() + ")[attrib.count=" + this.getAttributeCount() + " len=" + this.getDataLength() + " tranID=" + this.getTransactionID() + "]";
    }
}

