/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.client;

import junit.framework.TestCase;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.client.NetworkConfigurationDiscoveryProcess;
import net.java.stun4j.client.ResponseSequenceServer;
import net.java.stun4j.client.StunDiscoveryReport;
import net.java.stun4j.message.MessageFactory;
import net.java.stun4j.message.Response;

public class StunAddressDiscovererTest_v6
extends TestCase {
    private NetworkConfigurationDiscoveryProcess stunAddressDiscoverer = null;
    private StunAddress discovererAddress = new StunAddress("::1", 16555);
    private ResponseSequenceServer responseServer = null;
    private StunAddress responseServerAddress = new StunAddress("::1", 20999);
    private StunAddress mappedClientAddress = new StunAddress("2001:660:4701:1001:ff::1", 16612);
    private StunAddress mappedClientAddressPort2 = new StunAddress("2001:660:4701:1001:ff::1", 16611);

    public StunAddressDiscovererTest_v6(String name) throws StunException {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.responseServer = new ResponseSequenceServer(this.responseServerAddress);
        this.stunAddressDiscoverer = new NetworkConfigurationDiscoveryProcess(this.discovererAddress, this.responseServerAddress);
        this.stunAddressDiscoverer.start();
        this.responseServer.start();
    }

    protected void tearDown() throws Exception {
        this.responseServer.shutDown();
        this.stunAddressDiscoverer.shutDown();
        this.stunAddressDiscoverer = null;
        super.tearDown();
    }

    public void testRecognizeBlockedUDP() throws StunException {
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("UDP Blocking Firewall");
        expectedReturn.setPublicAddress(null);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer.determineAddress();
        StunAddressDiscovererTest_v6.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeSymmetricNat() throws StunException {
        Response testIResponse1 = MessageFactory.createBindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse2 = null;
        Response testIResponse3 = MessageFactory.createBindingResponse(this.mappedClientAddressPort2, this.responseServerAddress, this.responseServerAddress);
        this.responseServer.addMessage(testIResponse1);
        this.responseServer.addMessage(testIResponse2);
        this.responseServer.addMessage(testIResponse3);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Symmetric NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer.determineAddress();
        StunAddressDiscovererTest_v6.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizePortRestrictedCone() throws StunException {
        Response testIResponse1 = MessageFactory.createBindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse2 = null;
        Response testIResponse3 = MessageFactory.createBindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse4 = null;
        this.responseServer.addMessage(testIResponse1);
        this.responseServer.addMessage(testIResponse2);
        this.responseServer.addMessage(testIResponse3);
        this.responseServer.addMessage(testIResponse4);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Port Restricted Cone NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer.determineAddress();
        StunAddressDiscovererTest_v6.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeRestrictedCone() throws StunException {
        Response testIResponse1 = MessageFactory.createBindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse2 = null;
        Response testIResponse3 = MessageFactory.createBindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse4 = MessageFactory.createBindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        this.responseServer.addMessage(testIResponse1);
        this.responseServer.addMessage(testIResponse2);
        this.responseServer.addMessage(testIResponse3);
        this.responseServer.addMessage(testIResponse4);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Restricted Cone NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer.determineAddress();
        StunAddressDiscovererTest_v6.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeFullCone() throws StunException {
        Response testIResponse1 = MessageFactory.createBindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse2 = MessageFactory.createBindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        this.responseServer.addMessage(testIResponse1);
        this.responseServer.addMessage(testIResponse2);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Full Cone NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer.determineAddress();
        StunAddressDiscovererTest_v6.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeUdpSymmetricFirewall() throws StunException {
        Response testIResponse1 = MessageFactory.createBindingResponse(this.discovererAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse2 = null;
        this.responseServer.addMessage(testIResponse1);
        this.responseServer.addMessage(testIResponse2);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Symmetric UDP Firewall");
        expectedReturn.setPublicAddress(this.discovererAddress);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer.determineAddress();
        StunAddressDiscovererTest_v6.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeOpenInternet() throws StunException {
        Response testIResponse1 = MessageFactory.createBindingResponse(this.discovererAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse2 = MessageFactory.createBindingResponse(this.discovererAddress, this.responseServerAddress, this.responseServerAddress);
        this.responseServer.addMessage(testIResponse1);
        this.responseServer.addMessage(testIResponse2);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Open Internet Configuration");
        expectedReturn.setPublicAddress(this.discovererAddress);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer.determineAddress();
        StunAddressDiscovererTest_v6.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }
}

