/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.client;

import junit.framework.TestCase;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.client.NetworkConfigurationDiscoveryProcess;
import net.java.stun4j.client.ResponseSequenceServer;
import net.java.stun4j.client.StunDiscoveryReport;
import net.java.stun4j.message.MessageFactory;
import net.java.stun4j.message.Response;

public class StunAddressDiscovererTest_v4v6
extends TestCase {
    private NetworkConfigurationDiscoveryProcess stunAddressDiscoverer_v6 = null;
    private NetworkConfigurationDiscoveryProcess stunAddressDiscoverer_v4 = null;
    private StunAddress discovererAddress_v4 = new StunAddress("127.0.0.1", 17555);
    private StunAddress discovererAddress_v6 = new StunAddress("::1", 17555);
    private ResponseSequenceServer responseServer_v6 = null;
    private ResponseSequenceServer responseServer_v4 = null;
    private StunAddress responseServerAddress_v6 = new StunAddress("::1", 21999);
    private StunAddress responseServerAddress_v4 = new StunAddress("127.0.0.1", 21999);
    private StunAddress mappedClientAddress_v6 = new StunAddress("2001:660:4701:1001:ff::1", 17612);
    private StunAddress mappedClientAddress_v6_Port2 = new StunAddress("2001:660:4701:1001:ff::1", 17611);
    private StunAddress mappedClientAddress_v4 = new StunAddress("130.79.99.55", 17612);
    private StunAddress mappedClientAddress_v4_Port2 = new StunAddress("130.79.99.55", 17611);

    public StunAddressDiscovererTest_v4v6(String name) throws StunException {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.responseServer_v6 = new ResponseSequenceServer(this.responseServerAddress_v6);
        this.responseServer_v4 = new ResponseSequenceServer(this.responseServerAddress_v4);
        this.stunAddressDiscoverer_v6 = new NetworkConfigurationDiscoveryProcess(this.discovererAddress_v6, this.responseServerAddress_v6);
        this.stunAddressDiscoverer_v4 = new NetworkConfigurationDiscoveryProcess(this.discovererAddress_v4, this.responseServerAddress_v4);
        this.stunAddressDiscoverer_v6.start();
        this.stunAddressDiscoverer_v4.start();
        this.responseServer_v6.start();
        this.responseServer_v4.start();
    }

    protected void tearDown() throws Exception {
        this.responseServer_v6.shutDown();
        this.responseServer_v4.shutDown();
        this.stunAddressDiscoverer_v6.shutDown();
        this.stunAddressDiscoverer_v6 = null;
        this.stunAddressDiscoverer_v4.shutDown();
        this.stunAddressDiscoverer_v4 = null;
        Thread.currentThread();
        Thread.sleep(1000L);
        super.tearDown();
    }

    public void testRecognizeSymmetricNat_Local_v6_Public_v4() throws StunException {
        Response testIResponse1 = MessageFactory.createBindingResponse(this.mappedClientAddress_v4, this.responseServerAddress_v6, this.responseServerAddress_v6);
        Response testIResponse2 = null;
        Response testIResponse3 = MessageFactory.createBindingResponse(this.mappedClientAddress_v4_Port2, this.responseServerAddress_v6, this.responseServerAddress_v6);
        this.responseServer_v6.addMessage(testIResponse1);
        this.responseServer_v6.addMessage(testIResponse2);
        this.responseServer_v6.addMessage(testIResponse3);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Symmetric NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress_v4);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer_v6.determineAddress();
        StunAddressDiscovererTest_v4v6.assertEquals((String)"The StunAddressDiscoverer failed for a v4-v6 sym env.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeSymmetricNat_Local_v4_Public_v6() throws StunException {
        Response testIResponse1 = MessageFactory.createBindingResponse(this.mappedClientAddress_v6, this.responseServerAddress_v4, this.responseServerAddress_v4);
        Response testIResponse2 = null;
        Response testIResponse3 = MessageFactory.createBindingResponse(this.mappedClientAddress_v6_Port2, this.responseServerAddress_v4, this.responseServerAddress_v4);
        this.responseServer_v4.addMessage(testIResponse1);
        this.responseServer_v4.addMessage(testIResponse2);
        this.responseServer_v4.addMessage(testIResponse3);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Symmetric NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress_v6);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer_v4.determineAddress();
        StunAddressDiscovererTest_v4v6.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeFullCone_Local_v6_Public_v4() throws StunException {
        Response testIResponse1 = MessageFactory.createBindingResponse(this.mappedClientAddress_v4, this.responseServerAddress_v6, this.responseServerAddress_v6);
        Response testIResponse2 = MessageFactory.createBindingResponse(this.mappedClientAddress_v4, this.responseServerAddress_v6, this.responseServerAddress_v6);
        this.responseServer_v6.addMessage(testIResponse1);
        this.responseServer_v6.addMessage(testIResponse2);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Full Cone NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress_v4);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer_v6.determineAddress();
        StunAddressDiscovererTest_v4v6.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeFullCone_Local_v4_Public_v6() throws StunException {
        Response testIResponse1 = MessageFactory.createBindingResponse(this.mappedClientAddress_v6, this.responseServerAddress_v4, this.responseServerAddress_v4);
        Response testIResponse2 = MessageFactory.createBindingResponse(this.mappedClientAddress_v6, this.responseServerAddress_v4, this.responseServerAddress_v4);
        this.responseServer_v4.addMessage(testIResponse1);
        this.responseServer_v4.addMessage(testIResponse2);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Full Cone NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress_v6);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer_v4.determineAddress();
        StunAddressDiscovererTest_v4v6.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }
}

