/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.client;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.StunMessageEvent;
import net.java.stun4j.message.Response;
import net.java.stun4j.stack.RequestListener;
import net.java.stun4j.stack.StunProvider;
import net.java.stun4j.stack.StunStack;

public class ResponseSequenceServer
implements RequestListener {
    private static final Logger logger = Logger.getLogger(ResponseSequenceServer.class.getName());
    private Vector messageSequence = new Vector();
    private StunStack stunStack = null;
    private StunProvider stunProvider = null;
    private StunAddress serverAddress = null;
    private NetAccessPointDescriptor apDescriptor = null;

    public ResponseSequenceServer(StunAddress bindAddress) {
        this.serverAddress = bindAddress;
    }

    public void start() throws StunException {
        this.stunStack = StunStack.getInstance();
        this.stunProvider = this.stunStack.getProvider();
        this.apDescriptor = new NetAccessPointDescriptor(this.serverAddress);
        this.stunStack.installNetAccessPoint(this.apDescriptor);
        this.stunProvider.addRequestListener(this.apDescriptor, this);
        this.stunStack.start();
    }

    public void shutDown() {
        this.messageSequence.removeAllElements();
        ResponseSequenceServer responseSequenceServer = this;
        responseSequenceServer.stunStack.shutDown();
        this.stunStack = null;
        this.stunProvider = null;
    }

    public void addMessage(Response response) {
        if (response == null) {
            this.messageSequence.add(new Boolean(false));
        } else {
            this.messageSequence.add(response);
        }
    }

    public void requestReceived(StunMessageEvent evt) {
        if (this.messageSequence.isEmpty()) {
            return;
        }
        Object obj = this.messageSequence.remove(0);
        if (!(obj instanceof Response)) {
            return;
        }
        Response res = (Response)obj;
        try {
            this.stunProvider.sendResponse(evt.getMessage().getTransactionID(), res, this.apDescriptor, evt.getRemoteAddress());
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "failed to send a response", ex);
        }
    }

    public String toString() {
        return this.serverAddress == null ? "null" : this.serverAddress.toString();
    }
}

