/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.client;

import java.net.InetAddress;
import java.util.logging.Logger;
import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.StunMessageEvent;
import net.java.stun4j.attribute.ChangeRequestAttribute;
import net.java.stun4j.attribute.ChangedAddressAttribute;
import net.java.stun4j.attribute.MappedAddressAttribute;
import net.java.stun4j.client.BlockingRequestSender;
import net.java.stun4j.client.StunDiscoveryReport;
import net.java.stun4j.message.MessageFactory;
import net.java.stun4j.message.Request;
import net.java.stun4j.stack.StunProvider;
import net.java.stun4j.stack.StunStack;

public class NetworkConfigurationDiscoveryProcess {
    private static final Logger logger = Logger.getLogger(NetworkConfigurationDiscoveryProcess.class.getName());
    private boolean started = false;
    private StunStack stunStack = null;
    private StunProvider stunProvider = null;
    private NetAccessPointDescriptor apDescriptor = null;
    private StunAddress serverAddress = null;
    private BlockingRequestSender requestSender = null;

    public NetworkConfigurationDiscoveryProcess(StunAddress localAddress, StunAddress serverAddress) {
        this.apDescriptor = new NetAccessPointDescriptor(localAddress);
        this.serverAddress = serverAddress;
    }

    public NetworkConfigurationDiscoveryProcess(NetAccessPointDescriptor apDescriptor, StunAddress serverAddress) {
        this.apDescriptor = apDescriptor;
        this.serverAddress = serverAddress;
    }

    public void shutDown() {
        NetworkConfigurationDiscoveryProcess networkConfigurationDiscoveryProcess = this;
        networkConfigurationDiscoveryProcess.stunStack.shutDown();
        this.stunStack = null;
        this.stunProvider = null;
        this.apDescriptor = null;
        this.requestSender = null;
        this.started = false;
    }

    public void start() throws StunException {
        this.stunStack = StunStack.getInstance();
        this.stunStack.start();
        this.stunStack.installNetAccessPoint(this.apDescriptor);
        this.stunProvider = this.stunStack.getProvider();
        this.requestSender = new BlockingRequestSender(this.stunProvider, this.apDescriptor);
        this.started = true;
    }

    public StunDiscoveryReport determineAddress() throws StunException {
        this.checkStarted();
        StunDiscoveryReport report = new StunDiscoveryReport();
        StunMessageEvent evt = this.doTestI(this.serverAddress);
        if (evt == null) {
            report.setNatType("UDP Blocking Firewall");
            return report;
        }
        StunAddress mappedAddress = ((MappedAddressAttribute)evt.getMessage().getAttribute('\u0001')).getAddress();
        logger.info("mapped address is=" + mappedAddress + ", name=" + mappedAddress.getHostName());
        StunAddress backupServerAddress = ((ChangedAddressAttribute)evt.getMessage().getAttribute('\u0005')).getAddress();
        logger.info("backup server address is=" + backupServerAddress + ", name=" + backupServerAddress.getHostName());
        report.setPublicAddress(mappedAddress);
        if (mappedAddress.equals(this.apDescriptor.getAddress())) {
            evt = this.doTestII(this.serverAddress);
            if (evt == null) {
                report.setNatType("Symmetric UDP Firewall");
                return report;
            }
            report.setNatType("Open Internet Configuration");
            return report;
        }
        evt = this.doTestII(this.serverAddress);
        if (evt == null) {
            evt = this.doTestI(backupServerAddress);
            if (evt == null) {
                logger.info("Failed to receive a response from backup stun server!");
                return report;
            }
            StunAddress mappedAddress2 = ((MappedAddressAttribute)evt.getMessage().getAttribute('\u0001')).getAddress();
            if (mappedAddress.equals(mappedAddress2)) {
                evt = this.doTestIII(this.serverAddress);
                if (evt == null) {
                    report.setNatType("Port Restricted Cone NAT");
                    return report;
                }
                report.setNatType("Restricted Cone NAT");
                return report;
            }
            report.setNatType("Symmetric NAT");
            return report;
        }
        report.setNatType("Full Cone NAT");
        return report;
    }

    private StunMessageEvent doTestI(StunAddress serverAddress) throws StunException {
        Request request = MessageFactory.createBindingRequest();
        ChangeRequestAttribute changeRequest = (ChangeRequestAttribute)request.getAttribute('\u0003');
        changeRequest.setChangeIpFlag(false);
        changeRequest.setChangePortFlag(false);
        StunMessageEvent evt = this.requestSender.sendRequestAndWaitForResponse(request, serverAddress);
        if (evt != null) {
            logger.info("TEST I res=" + evt.getRemoteAddress().toString() + " - " + evt.getRemoteAddress().getHostName());
        } else {
            logger.info("NO RESPONSE received to TEST I.");
        }
        return evt;
    }

    private StunMessageEvent doTestII(StunAddress serverAddress) throws StunException {
        Request request = MessageFactory.createBindingRequest();
        ChangeRequestAttribute changeRequest = (ChangeRequestAttribute)request.getAttribute('\u0003');
        changeRequest.setChangeIpFlag(true);
        changeRequest.setChangePortFlag(true);
        StunMessageEvent evt = this.requestSender.sendRequestAndWaitForResponse(request, serverAddress);
        if (evt != null) {
            logger.info("Test II res=" + evt.getRemoteAddress().toString() + " - " + evt.getRemoteAddress().getHostName());
        } else {
            logger.info("NO RESPONSE received to Test II.");
        }
        return evt;
    }

    private StunMessageEvent doTestIII(StunAddress serverAddress) throws StunException {
        Request request = MessageFactory.createBindingRequest();
        ChangeRequestAttribute changeRequest = (ChangeRequestAttribute)request.getAttribute('\u0003');
        changeRequest.setChangeIpFlag(false);
        changeRequest.setChangePortFlag(true);
        StunMessageEvent evt = this.requestSender.sendRequestAndWaitForResponse(request, serverAddress);
        if (evt != null) {
            logger.info("Test III res=" + evt.getRemoteAddress().toString() + " - " + evt.getRemoteAddress().getHostName());
        } else {
            logger.info("NO RESPONSE received to Test III.");
        }
        return evt;
    }

    private void checkStarted() throws StunException {
        if (!this.started) {
            throw new StunException(1, "The Discoverer must be started before launching the discovery process!");
        }
    }

    public static void main(String[] args) throws Exception {
        StunAddress localAddr = null;
        StunAddress serverAddr = null;
        if (args.length == 4) {
            localAddr = new StunAddress(args[2], (int)Integer.valueOf(args[3]));
            serverAddr = new StunAddress(args[0], (int)Integer.valueOf(args[1]));
        } else {
            localAddr = new StunAddress(InetAddress.getLocalHost(), 5678);
            serverAddr = new StunAddress("stun01bak.sipphone.com.", 3479);
        }
        NetworkConfigurationDiscoveryProcess addressDiscovery = new NetworkConfigurationDiscoveryProcess(localAddr, serverAddr);
        addressDiscovery.start();
        StunDiscoveryReport report = addressDiscovery.determineAddress();
        System.out.println(report);
        System.exit(0);
    }
}

