/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.ResponseCollector;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.StunMessageEvent;
import net.java.stun4j.message.Request;
import net.java.stun4j.stack.StunProvider;

class BlockingRequestSender
implements ResponseCollector {
    private static final Logger logger = Logger.getLogger(BlockingRequestSender.class.getName());
    private StunProvider stunProvider = null;
    private NetAccessPointDescriptor apDescriptor = null;
    StunMessageEvent responseEvent = null;
    private boolean ended = false;
    private Object sendLock = new Object();

    BlockingRequestSender(StunProvider stunProvider, NetAccessPointDescriptor apDescriptor) {
        this.stunProvider = stunProvider;
        this.apDescriptor = apDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processResponse(StunMessageEvent evt) {
        Object object = this.sendLock;
        synchronized (object) {
            this.responseEvent = evt;
            this.ended = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processTimeout() {
        Object object = this.sendLock;
        synchronized (object) {
            this.ended = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StunMessageEvent sendRequestAndWaitForResponse(Request request, StunAddress serverAddress) throws StunException {
        Object object = this.sendLock;
        synchronized (object) {
            this.stunProvider.sendRequest(request, serverAddress, this.apDescriptor, this);
        }
        this.ended = false;
        while (!this.ended) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                logger.log(Level.WARNING, "Interrupted", ex);
            }
        }
        StunMessageEvent res = this.responseEvent;
        this.responseEvent = null;
        return res;
    }
}

