/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.attribute;

import net.java.stun4j.StunAddress;
import net.java.stun4j.attribute.AddressAttribute;

public class XorMappedAddressAttribute
extends AddressAttribute {
    public static final String NAME = "XOR-MAPPED-ADDRESS";

    XorMappedAddressAttribute() {
        super('\u8020');
    }

    public static StunAddress applyXor(StunAddress address, byte[] transactionID) {
        byte[] addressBytes = address.getAddressBytes();
        char port = address.getPort();
        char portModifier = (char)(transactionID[1] << 8 & 0xFF00 | transactionID[0] & 0xFF);
        port = (char)(port ^ portModifier);
        for (int i = 0; i < addressBytes.length; ++i) {
            int n = i;
            addressBytes[n] = (byte)(addressBytes[n] ^ transactionID[i]);
        }
        StunAddress xoredAdd = new StunAddress(addressBytes, (int)port);
        return xoredAdd;
    }

    public StunAddress applyXor(byte[] transactionID) {
        return XorMappedAddressAttribute.applyXor(this.getAddress(), transactionID);
    }
}

