/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.attribute;

import java.util.Arrays;
import java.util.Iterator;
import junit.framework.TestCase;
import net.java.stun4j.MsgFixture;
import net.java.stun4j.StunException;
import net.java.stun4j.attribute.UnknownAttributesAttribute;

public class UnknownAttributesAttributeTest
extends TestCase {
    private UnknownAttributesAttribute unknownAttributesAttribute = null;
    private MsgFixture binMessagesFixture;

    public UnknownAttributesAttributeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.unknownAttributesAttribute = new UnknownAttributesAttribute();
        this.binMessagesFixture = new MsgFixture();
        this.binMessagesFixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.unknownAttributesAttribute = null;
        this.binMessagesFixture.tearDown();
        this.binMessagesFixture = null;
        super.tearDown();
    }

    public void testUnknownAttributesAttribute() {
        this.unknownAttributesAttribute = new UnknownAttributesAttribute();
        UnknownAttributesAttributeTest.assertEquals((String)"UnknownAttributesAttribute() did not properly set the Attribute's type field!", (int)10, (int)this.unknownAttributesAttribute.getAttributeType());
    }

    public void testAddAttributeID() {
        char attributeID = '\"';
        this.unknownAttributesAttribute.addAttributeID(attributeID);
        UnknownAttributesAttributeTest.assertEquals((String)"addAttributeID does not seem to properly add the attribute ID", (int)attributeID, (int)this.unknownAttributesAttribute.getAttribute(0));
        UnknownAttributesAttributeTest.assertEquals((String)"addAttributeID does not seem to properly add the attribute ID", (int)1, (int)this.unknownAttributesAttribute.getAttributeCount());
        this.unknownAttributesAttribute.addAttributeID(attributeID);
        UnknownAttributesAttributeTest.assertEquals((String)"Adding a 2nd time the same attributeID should not change the number of attributes", (int)1, (int)this.unknownAttributesAttribute.getAttributeCount());
    }

    public void testDecodeAttributeBody() throws StunException {
        byte[] attributeValue = this.binMessagesFixture.unknownAttsDecodeTestValue;
        this.unknownAttributesAttribute.decodeAttributeBody(attributeValue, '\u0004', (char)(attributeValue.length - 4));
        UnknownAttributesAttributeTest.assertTrue((String)"The 32 attribute id was not found after decoding a binary array that contained it.", (boolean)this.unknownAttributesAttribute.contains(' '));
        UnknownAttributesAttributeTest.assertTrue((String)"The 33 attribute id was not found after decoding a binary array that contained it.", (boolean)this.unknownAttributesAttribute.contains('!'));
        UnknownAttributesAttributeTest.assertTrue((String)"The 34 attribute id was not found after decoding a binary array that contained it.", (boolean)this.unknownAttributesAttribute.contains('\"'));
        UnknownAttributesAttributeTest.assertEquals((String)("The decoded attribute contained " + this.unknownAttributesAttribute.getAttributeCount() + " attribute ids when there were only " + 3 + " in the original binary array."), (int)3, (int)this.unknownAttributesAttribute.getAttributeCount());
    }

    public void testEncode() {
        byte[] expectedReturn = this.binMessagesFixture.unknownAttsEncodeExpectedResult;
        this.unknownAttributesAttribute.addAttributeID(' ');
        this.unknownAttributesAttribute.addAttributeID('!');
        byte[] actualReturn = this.unknownAttributesAttribute.encode();
        UnknownAttributesAttributeTest.assertTrue((String)"UnknownAttributesAttribute did not encode properly.", (boolean)Arrays.equals(actualReturn, expectedReturn));
    }

    public void testEquals() {
        UnknownAttributesAttribute target = new UnknownAttributesAttribute();
        boolean expectedReturn = false;
        boolean actualReturn = this.unknownAttributesAttribute.equals(null);
        UnknownAttributesAttributeTest.assertEquals((String)"Equals failed for a null object", (boolean)expectedReturn, (boolean)actualReturn);
        this.unknownAttributesAttribute.addAttributeID('\u0019');
        target.addAttributeID('\u0019');
        this.unknownAttributesAttribute.addAttributeID('\u001a');
        actualReturn = this.unknownAttributesAttribute.equals(target);
        UnknownAttributesAttributeTest.assertEquals((String)"Equals failed when comparing different objects.", (boolean)expectedReturn, (boolean)actualReturn);
        target.addAttributeID('\u001a');
        expectedReturn = true;
        actualReturn = this.unknownAttributesAttribute.equals(target);
        UnknownAttributesAttributeTest.assertEquals((String)"Equals failed to recognize identical objects.", (boolean)expectedReturn, (boolean)actualReturn);
    }

    public void testGetAttribute() {
        char expectedId1 = '\u0014';
        char expectedId2 = '\u0015';
        this.unknownAttributesAttribute.addAttributeID(expectedId1);
        this.unknownAttributesAttribute.addAttributeID(expectedId2);
        char actualId1 = this.unknownAttributesAttribute.getAttribute(0);
        char actualId2 = this.unknownAttributesAttribute.getAttribute(1);
        UnknownAttributesAttributeTest.assertEquals((String)"getAttribute() return value mismatch", (char)expectedId1, (char)actualId1);
        UnknownAttributesAttributeTest.assertEquals((String)"getAttribute() return value mismatch", (char)expectedId2, (char)actualId2);
    }

    public void testGetAttributeCount() {
        int expectedReturn = 5;
        this.unknownAttributesAttribute.addAttributeID('\u0015');
        this.unknownAttributesAttribute.addAttributeID('\u0016');
        this.unknownAttributesAttribute.addAttributeID('\u0017');
        this.unknownAttributesAttribute.addAttributeID('\u0018');
        this.unknownAttributesAttribute.addAttributeID('\u0019');
        this.unknownAttributesAttribute.addAttributeID('\u0019');
        int actualReturn = this.unknownAttributesAttribute.getAttributeCount();
        UnknownAttributesAttributeTest.assertEquals((String)"getAttributeCount did not return the expected value", (int)expectedReturn, (int)actualReturn);
    }

    public void testGetAttributes() {
        char expectedId1 = '\u0014';
        char expectedId2 = '\u0015';
        this.unknownAttributesAttribute.addAttributeID(expectedId1);
        this.unknownAttributesAttribute.addAttributeID(expectedId2);
        Iterator iterator = this.unknownAttributesAttribute.getAttributes();
        char actualId1 = ((Character)iterator.next()).charValue();
        char actualId2 = ((Character)iterator.next()).charValue();
        UnknownAttributesAttributeTest.assertEquals((String)"getAttributes() return value mismatch", (char)expectedId1, (char)actualId1);
        UnknownAttributesAttributeTest.assertEquals((String)"getAttributes() return value mismatch", (char)expectedId2, (char)actualId2);
    }

    public void testGetDataLength() {
        char expectedReturn = '\b';
        this.unknownAttributesAttribute.addAttributeID('\u0014');
        this.unknownAttributesAttribute.addAttributeID('\u0015');
        this.unknownAttributesAttribute.addAttributeID('\u0016');
        char actualReturn = this.unknownAttributesAttribute.getDataLength();
        UnknownAttributesAttributeTest.assertEquals((String)"Incorrect testGetDataLength() return value", (char)expectedReturn, (char)actualReturn);
        this.unknownAttributesAttribute.addAttributeID('\u0017');
        actualReturn = this.unknownAttributesAttribute.getDataLength();
        UnknownAttributesAttributeTest.assertEquals((String)"Incorrect testGetDataLength() return value", (char)expectedReturn, (char)actualReturn);
    }

    public void testGetName() {
        String expectedReturn = "UNKNOWN-ATTRIBUTES";
        String actualReturn = this.unknownAttributesAttribute.getName();
        UnknownAttributesAttributeTest.assertEquals((String)"getName() return", (String)expectedReturn, (String)actualReturn);
    }
}

