/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.attribute;

import java.util.Arrays;
import junit.framework.TestCase;
import net.java.stun4j.MsgFixture;
import net.java.stun4j.StunException;
import net.java.stun4j.attribute.ServerAttribute;

public class TestServerAttribute
extends TestCase {
    private ServerAttribute serverAttribute = null;
    MsgFixture msgFixture = null;
    String serverValue = "turnserver.org";
    byte[] attributeBinValue = new byte[]{-128, 34, 0, (byte)this.serverValue.length(), 116, 117, 114, 110, 115, 101, 114, 118, 101, 114, 46, 111, 114, 103};

    protected void setUp() throws Exception {
        super.setUp();
        this.msgFixture = new MsgFixture();
        this.serverAttribute = new ServerAttribute();
        this.serverAttribute.setServer(this.serverValue.getBytes());
        this.msgFixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.serverAttribute = null;
        this.msgFixture.tearDown();
        this.msgFixture = null;
        super.tearDown();
    }

    public void testDecodeAttributeBody() throws StunException {
        char offset = '\u0000';
        ServerAttribute decoded = new ServerAttribute();
        char length = (char)this.serverValue.length();
        decoded.decodeAttributeBody(this.serverValue.getBytes(), offset, length);
        TestServerAttribute.assertEquals((String)"decode failed", (Object)this.serverAttribute, (Object)decoded);
    }

    public void testEncode() {
        TestServerAttribute.assertTrue((String)"encode failed", (boolean)Arrays.equals(this.serverAttribute.encode(), this.attributeBinValue));
    }

    public void testEquals() {
        ServerAttribute serverAttribute2 = new ServerAttribute();
        serverAttribute2.setServer(this.serverValue.getBytes());
        TestServerAttribute.assertEquals((String)"testequals failed", (Object)this.serverAttribute, (Object)serverAttribute2);
        serverAttribute2 = new ServerAttribute();
        serverAttribute2.setServer("some other server".getBytes());
        TestServerAttribute.assertFalse((String)"testequals failed", (boolean)this.serverAttribute.equals(serverAttribute2));
        TestServerAttribute.assertFalse((String)"testequals failed", (boolean)this.serverAttribute.equals(null));
    }

    public void testGetDataLength() {
        char expectedReturn = (char)this.serverValue.length();
        char actualReturn = this.serverAttribute.getDataLength();
        TestServerAttribute.assertEquals((String)"getDataLength - failed", (char)expectedReturn, (char)actualReturn);
    }

    public void testGetName() {
        String expectedReturn = "SERVER";
        String actualReturn = this.serverAttribute.getName();
        TestServerAttribute.assertEquals((String)"getting name failed", (String)expectedReturn, (String)actualReturn);
    }

    public void testSetGetServer() {
        byte[] expectedReturn = this.serverValue.getBytes();
        ServerAttribute att = new ServerAttribute();
        att.setServer(expectedReturn);
        byte[] actualReturn = att.getServer();
        TestServerAttribute.assertTrue((String)"server setter or getter failed", (boolean)Arrays.equals(expectedReturn, actualReturn));
    }
}

