/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.attribute;

import java.util.Arrays;
import net.java.stun4j.StunException;
import net.java.stun4j.attribute.Attribute;

public class ServerAttribute
extends Attribute {
    private byte[] server = null;

    protected ServerAttribute() {
        super('\u8022');
    }

    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        this.server = new byte[length];
        System.arraycopy(attributeValue, offset, this.server, 0, length);
    }

    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength()];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        System.arraycopy(this.server, 0, binValue, 4, this.getDataLength());
        return binValue;
    }

    public char getDataLength() {
        return (char)this.server.length;
    }

    public String getName() {
        return "SERVER";
    }

    public byte[] getServer() {
        if (this.server == null) {
            return null;
        }
        byte[] copy = new byte[this.server.length];
        System.arraycopy(this.server, 0, copy, 0, this.server.length);
        return this.server;
    }

    public void setServer(byte[] server) {
        if (server == null) {
            this.server = null;
        }
        this.server = new byte[server.length];
        System.arraycopy(server, 0, this.server, 0, server.length);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServerAttribute) || obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ServerAttribute att = (ServerAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.server, this.server);
    }
}

